/* ------------------------------------------------------------------- */
/* isMARC     : Convert a metatag struct to ISMARC                     */
/*              (i.e. UKMARC as used in the National and University    */
/*              Library of Island).                                    */
/*                                                                     */
/* Specs      : http://www.bibsys.no/meta/d2m/iscross.txt              */
/*                                                                     */
/* Author     : Ole Husby                                              */
/* Last update: 1998-09-30                                             */
/* ------------------------------------------------------------------- */

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include "d2m.h" 




/* ------------------------------------------------------------------- */
/* Splits Icelandig name without a comma                               */
/* ------------------------------------------------------------------- */

int split_ice2(char *str)
{
  char *q, *temp, *suba, *subi, *subb;

  if (!strstr(str, " "))
    return 1;

  suba = (char *) malloc(strlen(str) + 50);
  subi = (char *) malloc(strlen(str) + 50);
  subb = (char *) malloc(strlen(str) + 50);
  temp = (char *) malloc(strlen(str) + 50);

  *suba = *subi = *subb = *temp = 0;

  q = strtok(str, " ");
  while (q)
  {
    while ( ( q[0] == ' ' ) && ( strlen(q) ) )
      q++;

    while( ( q[strlen(q) - 1] == ' ' ) && ( strlen(q) ) )
      q[strlen(q) - 1] = '\0';

    if (*q)
    {
      if (!*suba)
        strcpy(suba, q);
      else
      {
        if (*temp)
        {
          if (*subi)
            strcat(subi, " ");
          strcat(subi, temp);
        }
        strcpy(temp, q);
      }
    }
    q = strtok(NULL, " ");
  }

  *str = 0;

  if (*temp)
  {
    if (*subi)
      strcpy(subb, temp);
    else
      strcpy(subi, temp);
  }

  if (*suba)
  {
    strcpy(str, suba);
    if (*subi)
    {
      strcat(str, " $i ");
      strcat(str, subi); 
    }
    if (*subb)
    {
      strcat(str, " $b ");
      strcat(str, subb); 
    }
  }

  free(suba);
  free(subi);
  free(subb);
  free(temp);

  return 40;
}





/* ------------------------------------------------------------------- */
/* Splits Icelandig name                                               */
/* ------------------------------------------------------------------- */

int split_icename(char *str, int i2)
{
  char *p, *q, subtag[5];

  if (!strstr(str, ","))
  {
    if (i2)
      return split_ice2(str);
    else
      return 1;
  }

  p = (char *) malloc(strlen(str) + 50);
  *p = 0;
  *subtag = 0;

  q = strtok(str, ",");
  if (q)
  {
    strcpy(p, q);
    q = strtok(NULL, "\0");
    if (q)
    {
      while ( ( q[0] == ' ' ) && ( strlen(q) ) )
        q++;
      strcat(p, " $h ");
      strcat(p, q);
    }
    strcpy(str, p);
  }

  free(p);

  return 10;
}


int isMARC(struct metatag *mt, struct marcrec *mr)
{
  char pre[64], type_tag[4], creator_tag[4], title_tag[6];
  int i, ind, ice2;

  *pre = 0;

  if (strcasecmp(mt->name, "title") == 0)
  {
    if ( (!*mt->type)
         | (strcasecmp(mt->type, "main") == 0)
         | (strcasecmp(mt->type, "long") == 0) )
    {
      if (mr->ntitles)
        strcpy(title_tag, "24630");
      else
        strcpy(title_tag, "24510");

      mr->ntitles++;

      sprintf(pre, "%s$a", title_tag);
    }
  }

  else if (strcasecmp(mt->name, "creator") == 0)
  {
    if ( strcasecmp(mt->type, "personal") == 0) 
    {
      if (!mr->ncreators)
        strcpy(creator_tag, "100");
      else 
        strcpy(creator_tag, "700");

      ice2 = 1; 
      ind = split_icename(mt->value, ice2);
      sprintf(pre, "%s%2d$a", creator_tag, ind);
    }
    else if (strcasecmp(mt->type, "corporate") == 0)
    {
      if (!mr->ncreators)
        strcpy(creator_tag, "110");
      else 
        strcpy(creator_tag, "710");
      sprintf(pre, "%s20$a", creator_tag);
    }
    else
    {
      ice2 = 0;
      strcpy(pre, "720  $a");
      ind = split_icename(mt->value, ice2);
    }
    mr->ncreators++;
  }

  else if (strncasecmp(mt->name, "contributor", 11) == 0)
  {
    if ( strcasecmp(mt->type, "personal") == 0) 
    {
      ice2 = 1; 
      ind = split_icename(mt->value, ice2);
      sprintf(pre, "700%2d$a", ind);
    }
    else if (strcasecmp(mt->type, "corporate") == 0)
    {
      strcpy(pre, "71020$a");
    }
    else
    {
      ice2 = 0;
      strcpy(pre, "720  $a");
      ind = split_icename(mt->value, ice2);
    }
    mr->ncreators++;
  }


  else if (strcasecmp(mt->name, "publisher") == 0)
    strcpy(pre, "260  $b");

  else if (strcasecmp(mt->name, "description") == 0)
    strcpy(pre, "513  $a");

  else if (strcasecmp(mt->name, "coverage") == 0)
  {
    if (strcasecmp(mt->type , "spatial") == 0)
    {
      strcpy(pre, "651  $a");
      split_subj(mt->value);
    }
    else
      strcpy(pre, "500  $a");
  }

  else if (strcasecmp(mt->name, "source") == 0)
    strcpy(pre, "787  $a");

  else if (strcasecmp(mt->name, "rights") == 0)
  {
    if (strcasecmp(mt->scheme, "url") == 0)
      strcpy(pre, "856  $3 rights $u");
    else
      strcpy(pre, "500  $a");
  }

  else if (strcasecmp(mt->name, "identifier") == 0)
  {
    if (!*mt->scheme)
      strcpy(mr->url, mt->value);
    else if (strcasecmp(mt->scheme, "url") == 0)
      strcpy(mr->url, mt->value);
    else if (strcasecmp(mt->scheme, "urn") == 0)
      strcpy(pre, "8567 $u urn:");
    else if (strcasecmp(mt->scheme, "nbn") == 0)
      strcpy(pre, "015  $a");
    else if (strcasecmp(mt->scheme, "isbn") == 0)
      strcpy(pre, "021  $a");
    else if (strcasecmp(mt->scheme, "issn") == 0)
      strcpy(pre, "022  $a");
    else if (strcasecmp(mt->scheme, "isrc") == 0)
      strcpy(pre, "024  $a");
    else if (strcasecmp(mt->scheme, "ismn") == 0)
      strcpy(pre, "025  $a");
    else if (strcasecmp(mt->scheme, "isrn") == 0)
      strcpy(pre, "027  $a");
  }

  else if (strcasecmp(mt->name, "type") == 0)
    strcpy(pre, "655  $a");

  else if (strcasecmp(mt->name, "relation") == 0)
    strcpy(pre, "787  $a");

  else if (strcasecmp(mt->name, "language") == 0)
  {
    if (strcasecmp(mt->scheme, "z39.53") == 0)
    {
      strcpy(pre, "04109$a");
      if (strlen(mt->value) == 3) 
        put008(mr->s008, mt->value, F008_LANGUAGE);
    }
    else if (strcasecmp(mt->scheme, "usmarc") == 0)
      strcpy(pre, "04109$a");
    else
      strcpy(pre, "546  $a");
  }

  else if (strcasecmp(mt->name, "format") == 0)
    strcpy(mr->fmat, mt->value); 

  else if (strcasecmp(mt->name, "subject") == 0)
  {
    if (!*mt->scheme)
      strcpy(pre, "680  $a");
    else if (strcasecmp(mt->scheme, "udc") == 0)
      strcpy(pre, "080  $a");
    else if (strcasecmp(mt->scheme, "lcc") == 0)
      strcpy(pre, "050  $a");
    else if (strcasecmp(mt->scheme, "lcsh") == 0)
      strcpy(pre, "650  $a");
    else if (strcasecmp(mt->scheme, "ddc") == 0)
      strcpy(pre, "082  $a");
    else if (strcasecmp(mt->scheme, "nlm") == 0)
      strcpy(pre, "060  $a");
    else if (strcasecmp(mt->scheme, "landslyk") == 0)
      strcpy(pre, "659  $a");
    else if (strcasecmp(mt->scheme, "kerfefn") == 0)
      strcpy(pre, "659  $a");
    else if (strcasecmp(mt->scheme, "dbc") == 0)
      strcpy(pre, "65002$a");
    else if (strcasecmp(mt->scheme, "mesh") == 0)
      strcpy(pre, "690  $a");
    else
      strcpy(pre, "65004$a");
  }

  else if (strcasecmp(mt->name, "date") == 0)
  {
    if (find_year(mt->value))
    {
      strcpy(mr->year, mt->value);
      put008(mr->s008, mt->value, F008_DATE1);
    }
  }

  if (*pre)
  {
    strcat(mr->marcline, pre);
    strcat(mr->marcline, " ");
    strcat(mr->marcline, mt->value);
    strcat(mr->marcline, "\n");
  }
}
