/**
 *#########################################################################
 *
 * A component of the Gatherer application, part of the Greenstone digital
 * library suite from the New Zealand Digital Library Project at the
 * University of Waikato, New Zealand.
 *
 * <BR><BR>
 *
 * Author: John Thompson, Greenstone Digital Library, University of Waikato
 *
 * <BR><BR>
 *
 * Copyright (C) 1999 New Zealand Digital Library Project
 *
 * <BR><BR>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * <BR><BR>
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * <BR><BR>
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *########################################################################
 */
package org.greenstone.gatherer.util;
/**
 * Title:        Gatherer<br>
 * Description:  The Gatherer: a tool for gathering and enriching a digital collection.<br>
 * Copyright:    Copyright (c) 2001<br>
 * Company:      The University of Waikato<br>
 * Written:        /  /01<br>
 * Revised:      21/06/02 - Moved into correct package and commented.<br>
 * @author John Thompson, 9826509
 * @version 2.1
 */
import java.awt.event.FocusListener;
import javax.swing.tree.*;
import org.greenstone.gatherer.file.FileSystemModel;

/** Any component that wants to act a GTree like drag'n'drop component must implement this. */
public interface DragComponent {
    public void addFocusListener(FocusListener listener);
    /** In order for the appearance to be consistant, given we may be in the situation where the pointer has left our focus but the ghost remains, this method allows other members of the Group to tell this component to repair the 'spoilt' region left by its ghost. */
    public void clearGhost();
    /** Used to notify this component that it has gained focus by some method other that mouse focus. */
    public void gainFocus();	 
    /** Retrieve the model associated with this component. */
    public FileSystemModel getTreeModel();
    /** This method is used to inform this component when it loses focus by means other than a drag mouse event, and should indicate this somehow. */
    public void loseFocus();
    /** Set the components group. */
    public void setGroup(DragGroup group);
}
