/**
 *#########################################################################
 *
 * A component of the Gatherer application, part of the Greenstone digital
 * library suite from the New Zealand Digital Library Project at the
 * University of Waikato, New Zealand.
 *
 * <BR><BR>
 *
 * Author: John Thompson, Greenstone Digital Library, University of Waikato
 *
 * <BR><BR>
 *
 * Copyright (C) 1999 New Zealand Digital Library Project
 *
 * <BR><BR>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * <BR><BR>
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * <BR><BR>
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *########################################################################
 */
package org.greenstone.gatherer.shell;

/**
 * Title:        The Gatherer<br>
 * Description:  The Gatherer: a tool for gathering and enriching digital collections.<br>
 * Copyright:    Copyright (c) 2001<br>
 * Company:      The University of Waikato<br>
 * Written:        /  /01<br>
 * Revised:      12/05/02 - Commented<br>
 *               29/05/02 - Moved into correct package<br>
 * @author John Thompson, Greenstone Digital Libraries
 * @version 2.1
 */
import java.util.EventListener;

/** This interface details the methods required of a class that wishes to listen to a <strong>GShell</strong>.
 */
public interface GShellListener 
    extends EventListener {
    /** All implementation of <i>GShellListener</i> must include this method so the listener can be informed of messages from the <strong>GShell</strong>.
     * @param event A <strong>GShellEvent</strong> that contains, amoung other things, the message.
     */
    public void message(GShellEvent event);

    /** All implementation of <i>GShellListener</i> must include this method so the listener can be informed when a <strong>GShell</strong> begins its task.
     * @param event A <strong>GShellEvent</strong> that contains details of the initial state of the <strong>GShell</strong> before task comencement.
     */
    public void processBegun(GShellEvent event);

    /** All implementation of <i>GShellListener</i> must include this method so the listener can be informed when a <strong>GShell</strong> completes its task.
     * @param event A <strong>GShellEvent</strong> that contains details of the final state of the <strong>GShell</strong> after task completion.
     */
    public void processComplete(GShellEvent event);
}
