/**
 *#########################################################################
 *
 * A component of the Gatherer application, part of the Greenstone digital
 * library suite from the New Zealand Digital Library Project at the
 * University of Waikato, New Zealand.
 *
 * <BR><BR>
 *
 * Author: John Thompson, Greenstone Digital Library, University of Waikato
 *
 * <BR><BR>
 *
 * Copyright (C) 1999 New Zealand Digital Library Project
 *
 * <BR><BR>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * <BR><BR>
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * <BR><BR>
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *########################################################################
 */
package org.greenstone.gatherer.gui;

import javax.swing.ImageIcon;
import javax.swing.JButton;
import org.greenstone.gatherer.util.Utility;

/** A button that knows whether it should paint itself as opaque or otherwise. */
public class GLIButton
    extends JButton {

    public GLIButton() {
	super();
	setOpaque(!Utility.isMac());
    }

    public GLIButton(ImageIcon icon) {
	super(icon);
	setOpaque(!Utility.isMac());
    }

    public GLIButton(String title) {
	super(title);
	setOpaque(!Utility.isMac());
    }

    public GLIButton(String title, ImageIcon icon) {
	super(title, icon);
	setOpaque(!Utility.isMac());
    }

    public GLIButton(ImageIcon icon, String tooltip) {
	super(icon);
	setOpaque(!Utility.isMac());
	setToolTipText(tooltip);
    }
    public GLIButton(String title, String tooltip) {
	super(title);
	setOpaque(!Utility.isMac());
	setToolTipText(tooltip);
    }

    public GLIButton(String title, ImageIcon icon, String tooltip) {
	super(title, icon);
	setOpaque(!Utility.isMac());
	setToolTipText(tooltip);
    }

   
}
