/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jimi.core.decoder.png;

import com.sun.jimi.core.JimiException;
import com.sun.jimi.core.compat.AdaptiveRasterImage;
import com.sun.jimi.core.decoder.png.IDATEnumeration;
import com.sun.jimi.core.util.JimiUtil;
import java.awt.image.ColorModel;
import java.awt.image.DirectColorModel;
import java.awt.image.IndexColorModel;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.SequenceInputStream;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;

public class PNGReader {
    static final int CHUNK_bKGD = 1649100612;
    static final int CHUNK_cHRM = 1665684045;
    static final int CHUNK_gAMA = 1732332865;
    static final int CHUNK_hIST = 1749635924;
    static final int CHUNK_IDAT = 1229209940;
    static final int CHUNK_IEND = 1229278788;
    static final int CHUNK_IHDR = 1229472850;
    static final int CHUNK_PLTE = 1347179589;
    static final int CHUNK_pHYs = 1883789683;
    static final int CHUNK_sBIT = 1933723988;
    static final int CHUNK_tEXt = 1950701684;
    static final int CHUNK_tIME = 1950960965;
    static final int CHUNK_tRNS = 1951551059;
    static final int CHUNK_zTXt = 2052348020;
    static final int[] startingRow = new int[]{0, 0, 0, 4, 0, 2, 0, 1};
    static final int[] startingCol = new int[]{0, 0, 4, 0, 2, 0, 1, 0};
    static final int[] rowInc = new int[]{1, 8, 8, 8, 4, 4, 2, 2};
    static final int[] colInc = new int[]{1, 8, 8, 4, 4, 2, 2, 1};
    static final int[] blockHeight = new int[]{1, 8, 8, 4, 4, 2, 2, 1};
    static final int[] blockWidth = new int[]{1, 8, 4, 4, 2, 2, 1, 1};
    static final int CT_PALETTE = 1;
    static final int CT_COLOR = 2;
    static final int CT_ALPHA = 4;
    static final int IT_GRAYSCALE = 0;
    static final int IT_RGB = 2;
    static final int IT_PALETTE = 3;
    static final int IT_GRAYALPHA = 4;
    static final int IT_RGBA = 6;
    private int f1;
    private int f2;
    private int f3 = -1;
    private int f4 = -1;
    private int f5 = 65535;
    private ColorModel f6;
    private int[] f7;
    private byte[] f8;
    private boolean f9;
    private boolean f10;
    private boolean f11;
    InputStream underlyingStream_;
    DataInputStream inputStream;
    private boolean f12 = false;
    private boolean f13 = false;
    private int f14 = 750;
    private boolean f15 = false;
    private int f16 = -1;
    private int f17 = -1;
    private int f18 = -1;
    private int f19 = -1;
    private int f20 = -1;
    private int f21;
    private byte[] f22;
    private boolean f23;
    int chunkLength;
    int chunkType;
    boolean needChunkInfo = true;
    AdaptiveRasterImage ji_;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void decodeImage() throws JimiException {
        try {
            this.m1();
            while (!this.f10) {
                if (this.f11) {
                    return;
                }
                this.m2();
            }
            return;
        }
        catch (IOException iOException) {
            throw new JimiException("IO Error");
        }
    }

    private void m1() throws JimiException, IOException {
        if (this.inputStream.read() != 137 || this.inputStream.read() != 80 || this.inputStream.read() != 78 || this.inputStream.read() != 71 || this.inputStream.read() != 13 || this.inputStream.read() != 10 || this.inputStream.read() != 26 || this.inputStream.read() != 10) {
            throw new JimiException("Not a PNG File");
        }
    }

    private void m2() throws JimiException, IOException {
        if (this.needChunkInfo) {
            this.chunkLength = this.inputStream.readInt();
            this.chunkType = this.inputStream.readInt();
            this.needChunkInfo = false;
        }
        switch (this.chunkType) {
            case 1649100612: {
                this.m7();
                break;
            }
            case 1665684045: {
                this.m8();
                break;
            }
            case 1732332865: {
                this.m9();
                break;
            }
            case 1749635924: {
                this.m10();
                break;
            }
            case 1229209940: {
                this.m16();
                break;
            }
            case 1229278788: {
                this.m11();
                break;
            }
            case 1229472850: {
                this.m3();
                break;
            }
            case 1883789683: {
                this.m12();
                break;
            }
            case 1347179589: {
                this.m4();
                break;
            }
            case 1933723988: {
                this.m13();
                break;
            }
            case 1950701684: {
                this.m14();
                break;
            }
            case 1950960965: {
                this.m15();
                break;
            }
            case 1951551059: {
                this.m5();
                break;
            }
            case 2052348020: {
                this.m6();
                break;
            }
            default: {
                this.inputStream.skip(this.chunkLength);
            }
        }
        this.inputStream.readInt();
        this.needChunkInfo = true;
    }

    private void m3() throws JimiException, IOException {
        if (this.f15) {
            throw new JimiException("Extraneous IHDR chunk encountered.");
        }
        if (this.chunkLength != 13) {
            throw new JimiException("IHDR chunk length wrong: " + this.chunkLength);
        }
        this.f1 = this.inputStream.readInt();
        this.f2 = this.inputStream.readInt();
        this.f17 = this.inputStream.read();
        this.f18 = this.inputStream.read();
        this.f16 = this.inputStream.read();
        this.f19 = this.inputStream.read();
        this.f20 = this.inputStream.read();
        this.f15 = true;
    }

    private void m4() throws IOException {
        if (this.f18 == 3) {
            this.f22 = new byte[this.chunkLength];
            this.inputStream.readFully(this.f22);
            return;
        }
        this.inputStream.skip(this.chunkLength);
    }

    private void m5() throws JimiException, IOException {
        switch (this.f18) {
            case 3: {
                if (this.f22 == null) {
                    throw new JimiException("tRNS chunk encountered before pLTE");
                }
                int n = this.f22.length;
                this.f23 = true;
                int n2 = n / 3;
                byte[] byArray = new byte[n2];
                this.inputStream.readFully(byArray, 0, this.chunkLength);
                int n3 = this.chunkLength;
                while (n3 < n2) {
                    byArray[n3] = -1;
                    ++n3;
                }
                byte[] byArray2 = new byte[n + n2];
                int n4 = byArray2.length;
                while (n4 > 0) {
                    byArray2[--n4] = byArray[--n2];
                    byArray2[--n4] = this.f22[--n];
                    byArray2[--n4] = this.f22[--n];
                    byArray2[--n4] = this.f22[--n];
                }
                this.f22 = byArray2;
                return;
            }
        }
        this.inputStream.skip(this.chunkLength);
    }

    private void m6() throws IOException {
        this.inputStream.skip(this.chunkLength);
    }

    private void m7() throws IOException {
        this.inputStream.skip(this.chunkLength);
    }

    private void m8() throws IOException {
        this.inputStream.skip(this.chunkLength);
    }

    private void m9() throws IOException {
        this.inputStream.skip(this.chunkLength);
    }

    private void m10() throws IOException {
        this.inputStream.skip(this.chunkLength);
    }

    private void m11() throws IOException {
        this.f10 = true;
    }

    private void m12() throws IOException {
        this.inputStream.skip(this.chunkLength);
    }

    private void m13() throws IOException {
        this.inputStream.skip(this.chunkLength);
    }

    private void m14() throws IOException {
        this.inputStream.skip(this.chunkLength);
    }

    private void m15() throws IOException {
        this.inputStream.skip(this.chunkLength);
    }

    private void m16() throws JimiException, IOException {
        if (!this.f12) {
            if (this.f4 != -1 && this.f3 != -1) {
                throw new JimiException("IDAT before IHDR");
            }
            this.f3 = this.f1;
            this.f4 = this.f2;
            this.m23();
            this.ji_.setSize(this.f3, this.f4);
            this.ji_.setColorModel(this.f6);
            this.ji_.setPixels();
            if (this.f20 != 0) {
                this.f9 = true;
            }
            this.f12 = true;
        }
        this.m17();
    }

    private void m17() throws JimiException, IOException {
        SequenceInputStream sequenceInputStream = new SequenceInputStream(new IDATEnumeration(this));
        DataInputStream dataInputStream = new DataInputStream(new InflaterInputStream(sequenceInputStream, new Inflater()));
        int n = 0;
        switch (this.f18) {
            case 0: 
            case 3: {
                n = this.f17;
                break;
            }
            case 2: {
                n = 3 * this.f17;
                break;
            }
            case 4: {
                n = this.f17 << 1;
                break;
            }
            case 6: {
                n = this.f17 << 2;
            }
        }
        int n2 = n + 7 >> 3;
        this.f21 = this.f9 ? 1 : 0;
        while (this.f21 < 8) {
            int n3 = this.f21;
            int n4 = rowInc[n3];
            int n5 = colInc[n3];
            int n6 = startingCol[n3];
            int n7 = (this.f1 - n6 + n5 - 1) / n5;
            int n8 = n7 * n2;
            int n9 = n7 * n + 7 >> 3;
            int n10 = startingRow[n3];
            if (this.f2 > n10 && n9 != 0) {
                byte[] byArray = new byte[n9];
                int[] nArray = new int[n9];
                int[] nArray2 = null;
                int[] nArray3 = new int[n9];
                int n11 = n10;
                while (n11 < this.f2) {
                    int n12 = dataInputStream.read();
                    dataInputStream.readFully(byArray);
                    if (!this.m22(byArray, nArray, nArray2, n12, n2)) {
                        throw new JimiException("Unknown filter type: " + n12);
                    }
                    this.m18(nArray, n8, n6, n11);
                    nArray2 = nArray;
                    nArray = nArray3;
                    nArray3 = nArray2;
                    n11 += n4;
                }
                if (!this.f9) break;
            }
            ++this.f21;
        }
        while (dataInputStream.read() != -1) {
        }
    }

    private void m18(int[] nArray, int n, int n2, int n3) throws JimiException {
        if (startingCol[this.f21] == 0 && colInc[this.f21] == 1) {
            switch (this.f18) {
                case 0: {
                    if (this.f17 == 16) {
                        byte[] byArray = new byte[this.f3];
                        int n4 = nArray.length;
                        int n5 = this.f3;
                        while (--n5 >= 0) {
                            byArray[n5] = (byte)nArray[n4 -= 2];
                        }
                        this.ji_.setChannel(3, n3, byArray);
                        return;
                    }
                    byte[] byArray = new byte[nArray.length];
                    int n6 = nArray.length;
                    while (--n6 >= 0) {
                        byArray[n6] = (byte)nArray[n6];
                    }
                    if (this.f17 == 8) {
                        this.ji_.setChannel(3, n3, byArray);
                        return;
                    }
                    byte[] byArray2 = new byte[this.f3];
                    JimiUtil.expandPixels(this.f17, byArray, byArray2, byArray2.length);
                    this.ji_.setChannel(3, n3, byArray2);
                    return;
                }
                case 4: {
                    int[] nArray2 = new int[this.f3];
                    if (this.f17 == 16) {
                        int n7 = nArray.length;
                        int n8 = this.f3;
                        while (--n8 >= 0) {
                            nArray2[n8] = nArray[n7 -= 2] | nArray[n7 -= 2] << 8;
                        }
                        this.ji_.setChannel(n3, nArray2);
                        return;
                    }
                    int n9 = nArray.length;
                    int n10 = this.f3;
                    while (--n10 >= 0) {
                        nArray2[n10] = nArray[--n9] | nArray[--n9] << 8;
                    }
                    this.ji_.setChannel(n3, nArray2);
                    return;
                }
                case 2: {
                    int[] nArray3 = new int[this.f3];
                    if (this.f17 == 8) {
                        int n11 = nArray.length;
                        int n12 = this.f3;
                        while (--n12 >= 0) {
                            nArray3[n12] = nArray[--n11] | nArray[--n11] << 8 | nArray[--n11] << 16;
                        }
                        this.ji_.setChannel(n3, nArray3);
                        return;
                    }
                    int n13 = nArray.length;
                    int n14 = this.f3;
                    while (--n14 >= 0) {
                        nArray3[n14] = nArray[n13 -= 2] | nArray[n13 -= 2] << 8 | nArray[n13 -= 2] << 16;
                    }
                    this.ji_.setChannel(n3, nArray3);
                    return;
                }
                case 3: {
                    byte[] byArray = new byte[nArray.length];
                    int n15 = nArray.length;
                    while (--n15 >= 0) {
                        byArray[n15] = (byte)nArray[n15];
                    }
                    if (this.f17 == 8) {
                        this.ji_.setChannel(0, n3, byArray);
                        return;
                    }
                    byte[] byArray3 = new byte[this.f3];
                    JimiUtil.expandPixels(this.f17, byArray, byArray3, byArray3.length);
                    this.ji_.setChannel(0, n3, byArray3);
                    return;
                }
                case 6: {
                    if (this.f17 == 8) {
                        int[] nArray4 = new int[this.f3];
                        int n16 = nArray.length;
                        int n17 = this.f3;
                        while (--n17 >= 0) {
                            nArray4[n17] = nArray[--n16] << 24 | nArray[--n16] | nArray[--n16] << 8 | nArray[--n16] << 16;
                        }
                        this.ji_.setChannel(n3, nArray4);
                        return;
                    }
                    int[] nArray5 = new int[this.f3];
                    int n18 = nArray.length;
                    int n19 = this.f3;
                    while (--n19 >= 0) {
                        nArray5[n19] = nArray[n18 -= 2] << 24 | nArray[n18 -= 2] | nArray[n18 -= 2] << 8 | nArray[n18 -= 2] << 16;
                    }
                    this.ji_.setChannel(n3, nArray5);
                    return;
                }
                default: {
                    return;
                }
            }
        }
        this.m19(nArray, n, n2, n3);
    }

    private void m19(int[] nArray, int n, int n2, int n3) throws JimiException {
        switch (this.f18) {
            case 0: 
            case 4: {
                this.m20(nArray, n, n2, n3);
                return;
            }
            case 2: {
                int n4 = colInc[this.f21];
                if (this.f17 == 8) {
                    int n5 = 0;
                    while (n5 < n) {
                        this.ji_.setChannel(n2, n3, nArray[n5++] << 16 | nArray[n5++] << 8 | nArray[n5++]);
                        n2 += n4;
                    }
                    return;
                }
                int n6 = 0;
                while (n6 < n) {
                    this.ji_.setChannel(n2, n3, nArray[n6] << 16 | nArray[n6 += 2] << 8 | nArray[n6 += 2]);
                    n6 += 2;
                    n2 += n4;
                }
                return;
            }
            case 3: {
                this.m21(nArray, n, n2, n3);
                return;
            }
            case 6: {
                int n7 = colInc[this.f21];
                if (this.f17 == 8) {
                    int n8 = 0;
                    while (n8 < n) {
                        this.ji_.setChannel(n2, n3, nArray[n8++] << 16 | nArray[n8++] << 8 | nArray[n8++] | nArray[n8++] << 24);
                        n2 += n7;
                    }
                    return;
                }
                int n9 = 0;
                while (n9 < n) {
                    this.ji_.setChannel(n2, n3, nArray[n9] << 16 | nArray[n9 += 2] << 8 | nArray[n9 += 2] | nArray[n9 += 2] << 24);
                    n9 += 2;
                    n2 += n7;
                }
                break;
            }
        }
    }

    private void m20(int[] nArray, int n, int n2, int n3) throws JimiException {
        int n4 = nArray[0];
        int n5 = colInc[this.f21];
        int n6 = 0;
        switch (this.f18) {
            case 0: {
                switch (this.f17) {
                    case 1: {
                        int n7 = 0;
                        while (n7 < n) {
                            if (n6 != 0) {
                                --n6;
                            } else {
                                n6 = 7;
                                n4 = nArray[n7 >> 3];
                            }
                            this.ji_.setChannel(n2, n3, n4 >> n6 & 1);
                            ++n7;
                            n2 += n5;
                        }
                        return;
                    }
                    case 2: {
                        int n8 = 0;
                        while (n8 < n) {
                            if (n6 != 0) {
                                n6 -= 2;
                            } else {
                                n6 = 6;
                                n4 = nArray[n8 >> 2];
                            }
                            this.ji_.setChannel(n2, n3, n4 >> n6 & 3);
                            ++n8;
                            n2 += n5;
                        }
                        return;
                    }
                    case 4: {
                        int n9 = 0;
                        while (n9 < n) {
                            if (n6 != 0) {
                                n6 = 0;
                            } else {
                                n6 = 4;
                                n4 = nArray[n9 >> 1];
                            }
                            this.ji_.setChannel(n2, n3, n4 >> n6 & 0xF);
                            ++n9;
                            n2 += n5;
                        }
                        return;
                    }
                    case 8: {
                        int n10 = 0;
                        while (n10 < n) {
                            this.ji_.setChannel(n2, n3, nArray[n10]);
                            ++n10;
                            n2 += n5;
                        }
                        return;
                    }
                    case 16: {
                        int n11 = 0;
                        while (n11 < n) {
                            this.ji_.setChannel(n2, n3, nArray[n11]);
                            n11 += 2;
                            n2 += n5;
                        }
                        break;
                    }
                }
                return;
            }
            case 4: {
                if (this.f17 == 8) {
                    int n12 = 0;
                    while (n12 < n) {
                        this.ji_.setChannel(n2, n3, nArray[n12++] << 8 | nArray[n12++]);
                        n2 += n5;
                    }
                    return;
                }
                int n13 = 0;
                while (n13 < n) {
                    this.ji_.setChannel(n2, n3, nArray[n13] << 8 | nArray[n13 += 2]);
                    n13 += 2;
                    n2 += n5;
                }
                break;
            }
        }
    }

    private void m21(int[] nArray, int n, int n2, int n3) throws JimiException {
        int n4 = 0;
        int n5 = nArray[0];
        int n6 = colInc[this.f21];
        switch (this.f17) {
            case 1: {
                int n7 = 0;
                while (n7 < n) {
                    if (n4 != 0) {
                        --n4;
                    } else {
                        n4 = 7;
                        n5 = nArray[n7 >> 3];
                    }
                    this.ji_.setChannel(n2, n3, n5 >> n4 & 1);
                    ++n7;
                    n2 += n6;
                }
                return;
            }
            case 2: {
                int n8 = 0;
                while (n8 < n) {
                    if (n4 != 0) {
                        n4 -= 2;
                    } else {
                        n4 = 6;
                        n5 = nArray[n8 >> 2];
                    }
                    this.ji_.setChannel(n2, n3, n5 >> n4 & 3);
                    ++n8;
                    n2 += n6;
                }
                return;
            }
            case 4: {
                int n9 = 0;
                while (n9 < n) {
                    if (n4 != 0) {
                        n4 = 0;
                    } else {
                        n4 = 4;
                        n5 = nArray[n9 >> 1];
                    }
                    this.ji_.setChannel(n2, n3, n5 >> n4 & 0xF);
                    ++n9;
                    n2 += n6;
                }
                return;
            }
            case 8: {
                int n10 = 0;
                while (n10 < n) {
                    this.ji_.setChannel(n2, n3, nArray[n10]);
                    ++n10;
                    n2 += n6;
                }
                break;
            }
        }
    }

    private boolean m22(byte[] byArray, int[] nArray, int[] nArray2, int n, int n2) {
        int n3 = nArray.length;
        switch (n) {
            case 0: {
                int n4 = 0;
                while (n4 < n3) {
                    nArray[n4] = 0xFF & byArray[n4];
                    ++n4;
                }
                break;
            }
            case 1: {
                int n5 = 0;
                while (n5 < n2) {
                    nArray[n5] = 0xFF & byArray[n5];
                    ++n5;
                }
                while (n5 < n3) {
                    nArray[n5] = 0xFF & byArray[n5] + nArray[n5 - n2];
                    ++n5;
                }
                break;
            }
            case 2: {
                if (nArray2 != null) {
                    int n6 = 0;
                    while (n6 < n3) {
                        nArray[n6] = 0xFF & nArray2[n6] + byArray[n6];
                        ++n6;
                    }
                } else {
                    int n7 = 0;
                    while (n7 < n3) {
                        nArray[n7] = 0xFF & byArray[n7];
                        ++n7;
                    }
                }
                break;
            }
            case 3: {
                if (nArray2 != null) {
                    int n8;
                    int n9 = 0;
                    while (n9 < n2) {
                        n8 = nArray2[n9];
                        nArray[n9] = 0xFF & (n8 >> 1) + byArray[n9];
                        ++n9;
                    }
                    while (n9 < n3) {
                        n8 = nArray2[n9] + nArray[n9 - n2];
                        nArray[n9] = 0xFF & (n8 >> 1) + byArray[n9];
                        ++n9;
                    }
                } else {
                    int n10 = 0;
                    while (n10 < n2) {
                        nArray[n10] = 0xFF & byArray[n10];
                        ++n10;
                    }
                    while (n10 < n3) {
                        int n11 = nArray[n10 - n2];
                        nArray[n10] = 0xFF & (n11 >> 1) + byArray[n10];
                        ++n10;
                    }
                }
                break;
            }
            case 4: {
                if (nArray2 != null) {
                    int n12 = 0;
                    while (n12 < n2) {
                        nArray[n12] = 0xFF & nArray2[n12] + byArray[n12];
                        ++n12;
                    }
                    while (n12 < n3) {
                        int n13;
                        int n14 = nArray[n12 - n2];
                        int n15 = nArray2[n12];
                        int n16 = nArray2[n12 - n2];
                        int n17 = n14 + n15 - n16;
                        int n18 = n17 > n14 ? n17 - n14 : n14 - n17;
                        int n19 = n17 > n15 ? n17 - n15 : n15 - n17;
                        int n20 = n13 = n17 > n16 ? n17 - n16 : n16 - n17;
                        int n21 = n18 <= n19 && n18 <= n13 ? n14 : (n19 <= n13 ? n15 : n16);
                        nArray[n12] = 0xFF & n21 + byArray[n12];
                        ++n12;
                    }
                } else {
                    int n22 = 0;
                    while (n22 < n2) {
                        nArray[n22] = 0xFF & byArray[n22];
                        ++n22;
                    }
                    while (n22 < n3) {
                        int n23 = nArray[n22 - n2];
                        nArray[n22] = 0xFF & n23 + byArray[n22];
                        ++n22;
                    }
                }
                break;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    private void m23() throws JimiException, IOException {
        int n = this.f17 == 16 ? 255 : (1 << this.f17) - 1;
        switch (this.f18) {
            case 3: {
                if (this.f22 == null) {
                    throw new JimiException("No palette located");
                }
                if (this.f23) {
                    this.f6 = new IndexColorModel(8, this.f22.length >> 2, this.f22, 0, true);
                    return;
                }
                this.f6 = new IndexColorModel(8, this.f22.length / 3, this.f22, 0, false);
                return;
            }
            case 0: {
                if (this.f17 == 16) {
                    int n2 = n;
                    this.f6 = new DirectColorModel(8, n2, n2, n2);
                    return;
                }
                int n3 = n;
                this.f6 = new DirectColorModel(this.f17, n3, n3, n3);
                return;
            }
            case 2: {
                this.f6 = new DirectColorModel(24, 0xFF0000, 65280, 255);
                return;
            }
            case 4: {
                int n4;
                int n5 = n4 = n << 8;
                this.f6 = new DirectColorModel(16, n5, n5, n5, n);
                return;
            }
            case 6: {
                this.f6 = new DirectColorModel(32, 0xFF0000, 65280, 255, -16777216);
                return;
            }
        }
        throw new JimiException("Image has unknown color type " + this.f18);
    }

    PNGReader(DataInputStream dataInputStream, AdaptiveRasterImage adaptiveRasterImage) {
        this.underlyingStream_ = dataInputStream;
        this.inputStream = dataInputStream;
        this.ji_ = adaptiveRasterImage;
    }
}

