/*
 * Decompiled with CFR 0.152.
 */
package org.greenstone.gsdl3.util;

import au.com.pharos.gdbm.GdbmException;
import au.com.pharos.gdbm.GdbmFile;
import au.com.pharos.packing.Packing;
import au.com.pharos.packing.StringPacking;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Enumeration;
import org.apache.log4j.Logger;
import org.greenstone.gsdl3.util.FlatDatabaseWrapper;
import org.greenstone.gsdl3.util.Processing;

public class GDBMWrapper
implements FlatDatabaseWrapper {
    static Logger logger = Logger.getLogger((String)GDBMWrapper.class.getName());
    protected GdbmFile db_ = null;

    public boolean openDatabase(String filename, int mode) {
        if (mode == 0) {
            mode = 0;
        } else if (mode == 1) {
            mode = 1;
        } else {
            logger.error((Object)("invalid mode, " + mode + ", opening db for reading only"));
            mode = 0;
        }
        try {
            if (this.db_ != null) {
                this.db_.close();
            }
            if (mode == 0 && !new File(filename).exists()) {
                logger.warn((Object)("Database file " + filename + " does not exist. Looking for ldb/bdb version"));
                int extension = filename.lastIndexOf(46);
                String filename_head = filename.substring(0, extension);
                filename = filename_head + ".ldb";
                if (!new File(filename).exists() && !new File(filename = filename_head + ".bdb").exists()) {
                    logger.warn((Object)("ldb/bdb version of database file " + filename + " does not exist. Looking for txtgz version of db file."));
                    filename = filename_head + ".gdb";
                    String txtgzFilename = filename_head + ".txt.gz";
                    if (new File(txtgzFilename).exists()) {
                        String cmd;
                        String cmdTest = "perl -v 2>&1";
                        int returnValue = Processing.runProcess(cmdTest);
                        if (returnValue != 0) {
                            logger.error((Object)("Tried to find Perl. Return exit value of running " + cmdTest + ": " + returnValue + ", (expected this to be 0)"));
                            logger.error((Object)"Check that Perl is set in your PATH environment variable.");
                        }
                        if ((returnValue = Processing.runProcess(cmd = "perl -S txtgz-to-gdbm.pl \"" + txtgzFilename + "\" \"" + filename + "\"")) != 0) {
                            logger.warn((Object)("Warning, non-zero return value on running command \"" + cmd + "\": " + returnValue));
                            if (!new File(filename).exists()) {
                                logger.error((Object)("Tried to run command \"" + cmd + "\", but it failed"));
                            }
                        }
                    }
                }
            }
            this.db_ = new GdbmFile(filename, mode);
        }
        catch (GdbmException e) {
            logger.error((Object)("couldn't open database " + filename));
            return false;
        }
        this.db_.setKeyPacking((Packing)new StringPacking());
        this.db_.setValuePacking((Packing)new StringPacking());
        return true;
    }

    public void closeDatabase() {
        try {
            if (this.db_ != null) {
                this.db_.close();
                this.db_ = null;
            }
        }
        catch (GdbmException e) {
            logger.error((Object)"error on close()");
        }
    }

    public String getValue(String key) {
        String s_info;
        if (this.db_ == null) {
            return null;
        }
        try {
            try {
                s_info = (String)this.db_.fetch((Object)key.getBytes("UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                logger.warn((Object)("utf8 key for " + key + " unrecognised. Retrying with default encoding."));
                s_info = (String)this.db_.fetch((Object)key);
            }
        }
        catch (GdbmException e) {
            logger.error((Object)"couldn't get record");
            return null;
        }
        if (s_info == null) {
            logger.error((Object)("key " + key + " not present in db"));
            return null;
        }
        return s_info;
    }

    public boolean setValue(String key, String value) {
        if (this.db_ == null) {
            return false;
        }
        return false;
    }

    public boolean deleteKey(String key) {
        if (this.db_ == null) {
            return false;
        }
        return false;
    }

    public String displayAllEntries() {
        StringBuffer output = new StringBuffer();
        try {
            Enumeration e = this.db_.keys();
            while (e.hasMoreElements()) {
                Object key = e.nextElement();
                Object value = this.db_.fetch(key);
                output.append("key href: ");
                output.append((String)key);
                output.append("\tvalue ID: ");
                output.append((String)value);
                output.append("\n");
                String urlkey = URLEncoder.encode((String)key, "UTF8");
                output.append("URL encoded key: " + urlkey);
            }
        }
        catch (UnsupportedEncodingException e) {
            logger.warn((Object)"Trouble converting key to UTF-8.");
        }
        catch (Exception e) {
            logger.warn((Object)("Exception encountered when trying to displayAllEntries():" + e));
        }
        return output.toString();
    }
}

