/*
 * Decompiled with CFR 0.152.
 */
package org.greenstone.gsdl3.service;

import java.io.File;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.greenstone.gsdl3.service.AbstractGS2FieldSearch;
import org.greenstone.gsdl3.util.GSFile;
import org.greenstone.mgpp.MGPPDocInfo;
import org.greenstone.mgpp.MGPPQueryResult;
import org.greenstone.mgpp.MGPPSearchWrapper;
import org.greenstone.mgpp.MGPPTermInfo;
import org.w3c.dom.Element;

public class GS2MGPPSearch
extends AbstractGS2FieldSearch {
    private static MGPPSearchWrapper mgpp_src = null;
    private String physical_index_name = "idx";
    static Logger logger = Logger.getLogger((String)GS2MGPPSearch.class.getName());

    public GS2MGPPSearch() {
        if (mgpp_src == null) {
            mgpp_src = new MGPPSearchWrapper();
        }
    }

    public void cleanUp() {
        super.cleanUp();
        mgpp_src.unloadIndexData();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Element processAnyQuery(Element request, int query_type) {
        MGPPSearchWrapper mGPPSearchWrapper = mgpp_src;
        synchronized (mGPPSearchWrapper) {
            return super.processAnyQuery(request, query_type);
        }
    }

    public boolean configure(Element info, Element extra_info) {
        if (!super.configure(info, extra_info)) {
            return false;
        }
        mgpp_src.setReturnLevel(this.default_db_level);
        mgpp_src.setReturnTerms(true);
        mgpp_src.setQueryLevel(this.default_level);
        mgpp_src.setMaxNumeric(this.maxnumeric);
        return true;
    }

    protected void addCustomQueryParams(Element param_list, String lang) {
        super.addCustomQueryParams(param_list, lang);
        this.createParameter("sortBy", param_list, lang);
    }

    protected boolean setUpQueryer(HashMap params) {
        Set entries = params.entrySet();
        Iterator i = entries.iterator();
        String physical_sub_index_name = this.default_index_subcollection;
        String physical_index_language_name = this.default_index_language;
        while (i.hasNext()) {
            boolean val;
            Map.Entry m = i.next();
            String name = (String)m.getKey();
            String value = (String)m.getValue();
            if (name.equals("case")) {
                val = value.equals("1");
                mgpp_src.setCase(val);
                continue;
            }
            if (name.equals("stem")) {
                val = value.equals("1");
                mgpp_src.setStem(val);
                continue;
            }
            if (name.equals("accent")) {
                val = value.equals("1");
                mgpp_src.setAccentFold(val);
                continue;
            }
            if (name.equals("maxDocs") && !value.equals("")) {
                int docs = Integer.parseInt(value);
                mgpp_src.setMaxDocs(docs);
                continue;
            }
            if (name.equals("level")) {
                mgpp_src.setQueryLevel(value);
                continue;
            }
            if (name.equals("matchMode")) {
                int mode = value.equals("all") ? 1 : 0;
                mgpp_src.setMatchMode(mode);
                continue;
            }
            if (name.equals("sortBy")) {
                if (value.equals("1")) {
                    mgpp_src.setSortByRank(true);
                    continue;
                }
                if (!value.equals("0")) continue;
                mgpp_src.setSortByRank(false);
                continue;
            }
            if (name.equals("indexSubcollection")) {
                physical_sub_index_name = value;
                continue;
            }
            if (!name.equals("indexLanguage")) continue;
            physical_index_language_name = value;
        }
        if (this.physical_index_name.equals("idx")) {
            if (physical_sub_index_name != null) {
                this.physical_index_name = this.physical_index_name + physical_sub_index_name;
            }
            if (physical_index_language_name != null) {
                this.physical_index_name = this.physical_index_name + physical_index_language_name;
            }
        }
        String indexdir = GSFile.collectionBaseDir(this.site_home, this.cluster_name) + File.separatorChar + GSFile.collectionIndexPath(this.index_stem, this.physical_index_name);
        mgpp_src.loadIndexData(indexdir);
        return true;
    }

    protected Object runQuery(String query) {
        mgpp_src.runQuery(query);
        MGPPQueryResult mqr = mgpp_src.getQueryResult();
        return mqr;
    }

    protected long numDocsMatched(Object query_result) {
        return ((MGPPQueryResult)query_result).getTotalDocs();
    }

    protected String[] getDocIDs(Object query_result) {
        Vector docs = ((MGPPQueryResult)query_result).getDocs();
        String[] doc_nums = new String[docs.size()];
        for (int d = 0; d < docs.size(); ++d) {
            doc_nums[d] = Long.toString(((MGPPDocInfo)docs.elementAt((int)d)).num_);
        }
        return doc_nums;
    }

    protected String[] getDocRanks(Object query_result) {
        Vector docs = ((MGPPQueryResult)query_result).getDocs();
        String[] doc_ranks = new String[docs.size()];
        for (int d = 0; d < docs.size(); ++d) {
            doc_ranks[d] = Float.toString(((MGPPDocInfo)docs.elementAt((int)d)).rank_);
        }
        return doc_ranks;
    }

    protected boolean addTermInfo(Element term_list, HashMap params, Object query_result) {
        String query_level = (String)params.get("level");
        Vector terms = ((MGPPQueryResult)query_result).getTerms();
        for (int t = 0; t < terms.size(); ++t) {
            MGPPTermInfo term_info = (MGPPTermInfo)terms.get(t);
            Element term_elem = this.doc.createElement("term");
            term_elem.setAttribute("name", term_info.term_);
            term_elem.setAttribute("stem", "" + term_info.stem_method_);
            term_elem.setAttribute("freq", "" + term_info.term_freq_);
            term_elem.setAttribute("numDocsMatch", "" + term_info.match_docs_);
            String field = term_info.tag_;
            if (field.equals(query_level)) {
                field = "";
            }
            term_elem.setAttribute("field", field);
            Vector equiv_terms = term_info.equiv_terms_;
            Element equiv_term_list = this.doc.createElement("equivTermList");
            term_elem.appendChild(equiv_term_list);
            for (int et = 0; et < equiv_terms.size(); ++et) {
                String equiv_term = (String)equiv_terms.get(et);
                Element equiv_term_elem = this.doc.createElement("term");
                equiv_term_elem.setAttribute("name", equiv_term);
                equiv_term_elem.setAttribute("numDocsMatch", "");
                equiv_term_elem.setAttribute("freq", "");
                equiv_term_list.appendChild(equiv_term_elem);
            }
            term_list.appendChild(term_elem);
        }
        return true;
    }

    protected String addFieldInfo(String query, String field) {
        if (field.equals("") || field.equals("ZZ")) {
            return query;
        }
        return "[" + query + "]:" + field;
    }

    protected void addQueryElem(StringBuffer final_query, String query, String field, String combine) {
        String comb = "";
        if (final_query.length() > 0) {
            comb = " " + combine + " ";
        }
        final_query.append(comb + this.addFieldInfo(query, field));
    }

    protected String addStemOptions(String query, String stem, String casef, String accent) {
        String mods = "#";
        if (casef != null) {
            mods = casef.equals("1") ? mods + "i" : mods + "c";
        }
        if (stem != null) {
            mods = stem.equals("1") ? mods + "s" : mods + "u";
        }
        if (accent != null) {
            mods = accent.equals("1") ? mods + "f" : mods + "a";
        }
        StringBuffer temp = new StringBuffer();
        String[] terms = query.split(" ");
        for (int i = 0; i < terms.length; ++i) {
            String t = terms[i].trim();
            if (t.equals("") || t.equals("TX")) continue;
            temp.append(" " + t + mods);
        }
        return temp.toString();
    }
}

