/*
 * Decompiled with CFR 0.152.
 */
package org.greenstone.gsdl3.service;

import java.util.ArrayList;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.greenstone.gsdl3.core.GSException;
import org.greenstone.gsdl3.service.AbstractDocumentRetrieve;
import org.greenstone.gsdl3.util.DBInfo;
import org.greenstone.gsdl3.util.GS2MacroResolver;
import org.greenstone.gsdl3.util.GSFile;
import org.greenstone.gsdl3.util.GSXML;
import org.greenstone.gsdl3.util.OID;
import org.greenstone.gsdl3.util.SimpleCollectionDatabase;
import org.w3c.dom.Element;

public abstract class AbstractGS2DocumentRetrieve
extends AbstractDocumentRetrieve {
    static Logger logger = Logger.getLogger((String)AbstractGS2DocumentRetrieve.class.getName());
    protected String index_stem = null;
    protected SimpleCollectionDatabase coll_db = null;

    protected AbstractGS2DocumentRetrieve() {
        this.macro_resolver = new GS2MacroResolver();
    }

    public void cleanUp() {
        super.cleanUp();
        this.coll_db.closeDatabase();
    }

    public boolean configure(Element info, Element extra_info) {
        if (!super.configure(info, extra_info)) {
            return false;
        }
        logger.info((Object)"Configuring AbstractGS2DocumentRetrieve...");
        Element index_stem_elem = (Element)GSXML.getChildByTagName(info, "indexStem");
        if (index_stem_elem != null) {
            this.index_stem = index_stem_elem.getAttribute("name");
        }
        if (this.index_stem == null || this.index_stem.equals("")) {
            logger.error((Object)"AbstractGS2DocumentRetrieve.configure(): indexStem element not found, stem will default to collection name");
            this.index_stem = this.cluster_name;
        }
        Element database_type_elem = (Element)GSXML.getChildByTagName(info, "databaseType");
        String database_type = null;
        if (database_type_elem != null) {
            database_type = database_type_elem.getAttribute("name");
        }
        if (database_type == null || database_type.equals("")) {
            database_type = "gdbm";
        }
        this.coll_db = new SimpleCollectionDatabase(database_type);
        if (this.coll_db == null) {
            logger.error((Object)("Couldn't create the collection database of type " + database_type));
            return false;
        }
        String coll_db_file = GSFile.collectionDatabaseFile(this.site_home, this.cluster_name, this.index_stem, database_type);
        if (!this.coll_db.openDatabase(coll_db_file, 0)) {
            logger.error((Object)"Could not open collection database!");
            return false;
        }
        GS2MacroResolver gs2_macro_resolver = (GS2MacroResolver)this.macro_resolver;
        gs2_macro_resolver.setDB(this.coll_db);
        return true;
    }

    protected String translateId(String node_id) {
        return this.coll_db.translateOID(node_id);
    }

    protected String translateExternalId(String node_id) {
        return this.coll_db.externalId2OID(node_id);
    }

    protected String getRootId(String node_id) {
        return OID.getTop(node_id);
    }

    protected ArrayList getChildrenIds(String node_id) {
        DBInfo info = this.coll_db.getInfo(node_id);
        if (info == null) {
            return null;
        }
        String contains = info.getInfo("contains");
        if (contains.equals("")) {
            return null;
        }
        ArrayList<String> children = new ArrayList<String>();
        StringTokenizer st = new StringTokenizer(contains, ";");
        while (st.hasMoreTokens()) {
            String child_id = st.nextToken().replaceAll("\"", node_id);
            children.add(child_id);
        }
        return children;
    }

    protected String getParentId(String node_id) {
        String parent = OID.getParent(node_id);
        if (parent.equals(node_id)) {
            return null;
        }
        return parent;
    }

    protected Element getMetadataList(String node_id, boolean all_metadata, ArrayList metadata_names) throws GSException {
        Element metadata_list = this.doc.createElement("metadataList");
        DBInfo info = this.coll_db.getInfo(node_id);
        if (info == null) {
            return null;
        }
        String lang = "en";
        if (all_metadata) {
            Set keys = info.getKeys();
            for (String key : keys) {
                Vector values = info.getMultiInfo(key);
                for (int i = 0; i < values.size(); ++i) {
                    GSXML.addMetadata(this.doc, metadata_list, key, this.macro_resolver.resolve((String)values.elementAt(i), lang, "metadata", node_id));
                }
            }
        } else {
            for (int i = 0; i < metadata_names.size(); ++i) {
                String meta_name = (String)metadata_names.get(i);
                String value = this.getMetadata(node_id, info, meta_name, lang);
                GSXML.addMetadata(this.doc, metadata_list, meta_name, value);
            }
        }
        return metadata_list;
    }

    protected String getStructureInfo(String doc_id, String info_type) {
        String value = "";
        if (info_type.equals("numSiblings")) {
            String parent_id = OID.getParent(doc_id);
            value = parent_id.equals(doc_id) ? "0" : String.valueOf(this.getNumChildren(parent_id));
            return value;
        }
        if (info_type.equals("numChildren")) {
            return String.valueOf(this.getNumChildren(doc_id));
        }
        if (info_type.equals("siblingPosition")) {
            String parent_id = OID.getParent(doc_id);
            if (parent_id.equals(doc_id)) {
                return "-1";
            }
            DBInfo info = this.coll_db.getInfo(parent_id);
            if (info == null) {
                return "-1";
            }
            String contains = info.getInfo("contains");
            contains = contains.replaceAll("\"", parent_id);
            String[] children = contains.split(";");
            for (int i = 0; i < children.length; ++i) {
                String child_id = children[i];
                if (!child_id.equals(doc_id)) continue;
                return String.valueOf(i + 1);
            }
            return "-1";
        }
        return null;
    }

    protected int getNumChildren(String node_id) {
        DBInfo info = this.coll_db.getInfo(node_id);
        if (info == null) {
            return 0;
        }
        String contains = info.getInfo("contains");
        if (contains.equals("")) {
            return 0;
        }
        String[] children = contains.split(";");
        return children.length;
    }

    protected String getDocType(String node_id) {
        boolean is_leaf;
        DBInfo info = this.coll_db.getInfo(node_id);
        if (info == null) {
            return "simple";
        }
        String doc_type = info.getInfo("doctype");
        if (!doc_type.equals("") && !doc_type.equals("doc")) {
            return doc_type;
        }
        String top_id = OID.getTop(node_id);
        boolean is_top = top_id.equals(node_id);
        String children = info.getInfo("contains");
        boolean bl = is_leaf = children.equals("");
        if (is_top && is_leaf) {
            return "simple";
        }
        if (!is_top) {
            info = this.coll_db.getInfo(top_id);
        }
        if (info == null) {
            return "hierarchy";
        }
        String childtype = info.getInfo("childtype");
        if (childtype.equals("Paged")) {
            return "paged";
        }
        return "hierarchy";
    }

    protected abstract Element getNodeContent(String var1, String var2) throws GSException;

    protected String getMetadata(String node_id, DBInfo info, String metadata, String lang) {
        int i;
        DBInfo relation_info;
        boolean multiple = false;
        String relation = "";
        String separator = ", ";
        int pos = metadata.indexOf("_");
        if (pos == -1) {
            Vector values = info.getMultiInfo(metadata);
            if (values != null) {
                StringBuffer result = new StringBuffer();
                boolean first = true;
                for (int i2 = 0; i2 < values.size(); ++i2) {
                    if (first) {
                        first = false;
                    } else {
                        result.append(separator);
                    }
                    result.append(this.macro_resolver.resolve((String)values.elementAt(i2), lang, "metadata", node_id));
                }
                return result.toString();
            }
            String result = info.getInfo(metadata);
            return this.macro_resolver.resolve(result, lang, "metadata", node_id);
        }
        String temp = metadata.substring(0, pos);
        metadata = metadata.substring(pos + 1);
        if (temp.equals("all")) {
            multiple = true;
            pos = metadata.indexOf("_");
            if (pos == -1) {
                temp = "";
            } else {
                temp = metadata.substring(0, pos);
                metadata = metadata.substring(pos + 1);
            }
        }
        if (temp.equals("parent") || temp.equals("root") || temp.equals("ancestors")) {
            relation = temp;
            pos = metadata.indexOf("_");
            if (pos == -1) {
                temp = "";
            } else {
                temp = metadata.substring(0, pos);
                metadata = metadata.substring(pos + 1);
            }
        }
        if (temp.startsWith("*") && temp.endsWith("*")) {
            separator = temp.substring(1, temp.length() - 1);
        }
        String relation_id = node_id;
        if (relation.equals("parent") || relation.equals("ancestors")) {
            relation_id = OID.getParent(node_id);
            if (relation_id.equals(node_id)) {
                return "";
            }
        } else if (relation.equals("root")) {
            relation_id = OID.getTop(node_id);
        }
        if ((relation_info = relation_id.equals(node_id) ? info : this.coll_db.getInfo(relation_id)) == null) {
            return "";
        }
        StringBuffer result = new StringBuffer();
        if (!multiple) {
            result.append(this.macro_resolver.resolve(relation_info.getInfo(metadata), lang, "metadata", relation_id));
        } else {
            Vector values = relation_info.getMultiInfo(metadata);
            if (values != null) {
                boolean first = true;
                for (i = 0; i < values.size(); ++i) {
                    if (first) {
                        first = false;
                    } else {
                        result.append(separator);
                    }
                    result.append(this.macro_resolver.resolve((String)values.elementAt(i), lang, "metadata", relation_id));
                }
            }
            logger.info((Object)result);
        }
        if (!relation.equals("ancestors")) {
            return result.toString();
        }
        String current_id = relation_id;
        relation_id = OID.getParent(current_id);
        while (!relation_id.equals(current_id)) {
            relation_info = this.coll_db.getInfo(relation_id);
            if (relation_info == null) {
                return result.toString();
            }
            if (!multiple) {
                result.insert(0, separator);
                result.insert(0, this.macro_resolver.resolve(relation_info.getInfo(metadata), lang, "metadata", relation_id));
            } else {
                Vector values = relation_info.getMultiInfo(metadata);
                if (values != null) {
                    for (i = values.size() - 1; i >= 0; --i) {
                        result.insert(0, separator);
                        result.insert(0, this.macro_resolver.resolve((String)values.elementAt(i), lang, "metadata", relation_id));
                    }
                }
            }
            current_id = relation_id;
            relation_id = OID.getParent(current_id);
        }
        return result.toString();
    }

    protected String resolveTextMacros(String doc_content, String doc_id, String lang) {
        doc_content = this.macro_resolver.resolve(doc_content, lang, "text", doc_id);
        return doc_content;
    }

    protected Element getInfo(String doc_id, String info_type) {
        String parent_id;
        String value = "";
        if (info_type.equals("numSiblings")) {
            parent_id = OID.getParent(doc_id);
            value = parent_id.equals(doc_id) ? "0" : String.valueOf(this.getNumChildren(parent_id));
        } else if (info_type.equals("numChildren")) {
            value = String.valueOf(this.getNumChildren(doc_id));
        } else if (info_type.equals("siblingPosition")) {
            parent_id = OID.getParent(doc_id);
            if (parent_id.equals(doc_id)) {
                value = "-1";
            } else {
                DBInfo info = this.coll_db.getInfo(parent_id);
                if (info == null) {
                    value = "-1";
                } else {
                    String contains = info.getInfo("contains");
                    contains = contains.replaceAll("\"", parent_id);
                    String[] children = contains.split(";");
                    for (int i = 0; i < children.length; ++i) {
                        String child_id = children[i];
                        if (!child_id.equals(doc_id)) continue;
                        value = String.valueOf(i + 1);
                        break;
                    }
                }
            }
        } else {
            return null;
        }
        Element info_elem = this.doc.createElement("info");
        info_elem.setAttribute("name", info_type);
        info_elem.setAttribute("value", value);
        return info_elem;
    }

    protected String getHrefOID(String href_url) {
        return this.coll_db.docnum2OID(href_url);
    }
}

