/*
 * Decompiled with CFR 0.152.
 */
package org.greenstone.gsdl3.service;

import java.util.ArrayList;
import org.apache.log4j.Logger;
import org.greenstone.gsdl3.core.GSException;
import org.greenstone.gsdl3.service.ServiceRack;
import org.greenstone.gsdl3.util.GSPath;
import org.greenstone.gsdl3.util.GSXML;
import org.greenstone.gsdl3.util.MacroResolver;
import org.greenstone.gsdl3.util.OID;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public abstract class AbstractDocumentRetrieve
extends ServiceRack {
    static Logger logger = Logger.getLogger((String)AbstractDocumentRetrieve.class.getName());
    protected static final String DOCUMENT_STRUCTURE_RETRIEVE_SERVICE = "DocumentStructureRetrieve";
    protected static final String DOCUMENT_METADATA_RETRIEVE_SERVICE = "DocumentMetadataRetrieve";
    protected static final String DOCUMENT_CONTENT_RETRIEVE_SERVICE = "DocumentContentRetrieve";
    protected static final String STRUCT_PARAM = "structure";
    protected static final String INFO_PARAM = "info";
    protected static final String STRUCT_ANCESTORS = "ancestors";
    protected static final String STRUCT_PARENT = "parent";
    protected static final String STRUCT_SIBS = "siblings";
    protected static final String STRUCT_CHILDREN = "children";
    protected static final String STRUCT_DESCENDS = "descendants";
    protected static final String STRUCT_ENTIRE = "entire";
    protected static final String INFO_NUM_SIBS = "numSiblings";
    protected static final String INFO_NUM_CHILDREN = "numChildren";
    protected static final String INFO_SIB_POS = "siblingPosition";
    protected static final String EXTID_PARAM = "ext";
    protected Element config_info = null;
    protected String default_document_type = null;
    protected MacroResolver macro_resolver = null;
    protected boolean does_metadata = true;
    protected boolean does_content = true;
    protected boolean does_structure = true;

    public boolean configure(Element info, Element extra_info) {
        String path;
        Element display_format;
        if (!super.configure(info, extra_info)) {
            return false;
        }
        logger.info((Object)"Configuring AbstractDocumentRetrieve...");
        this.config_info = info;
        if (this.does_structure) {
            Element dsr_service = this.doc.createElement("service");
            dsr_service.setAttribute("type", "retrieve");
            dsr_service.setAttribute("name", DOCUMENT_STRUCTURE_RETRIEVE_SERVICE);
            this.short_service_info.appendChild(dsr_service);
        }
        if (this.does_metadata) {
            Element dmr_service = this.doc.createElement("service");
            dmr_service.setAttribute("type", "retrieve");
            dmr_service.setAttribute("name", DOCUMENT_METADATA_RETRIEVE_SERVICE);
            this.short_service_info.appendChild(dmr_service);
        }
        if (this.does_content) {
            Element dcr_service = this.doc.createElement("service");
            dcr_service.setAttribute("type", "retrieve");
            dcr_service.setAttribute("name", DOCUMENT_CONTENT_RETRIEVE_SERVICE);
            this.short_service_info.appendChild(dcr_service);
        }
        if ((display_format = (Element)GSXML.getNodeByPath(extra_info, path = GSPath.appendLink("display", "format"))) != null) {
            String value;
            this.format_info_map.put(DOCUMENT_CONTENT_RETRIEVE_SERVICE, this.doc.importNode(display_format, true));
            Element doc_type_opt = GSXML.getNamedElement(display_format, "gsf:option", "name", "documentType");
            if (doc_type_opt != null && !(value = doc_type_opt.getAttribute("value")).equals("")) {
                this.default_document_type = value;
            }
        }
        if (this.macro_resolver != null) {
            this.macro_resolver.setSiteDetails(this.site_http_address, this.cluster_name, this.getLibraryName());
            Element replacement_elem = (Element)GSXML.getChildByTagName(extra_info, "replaceList");
            if (replacement_elem != null) {
                this.macro_resolver.addMacros(replacement_elem);
            }
            NodeList replace_refs_elems = extra_info.getElementsByTagName("replaceListRef");
            for (int i = 0; i < replace_refs_elems.getLength(); ++i) {
                Element replace_list;
                String id = ((Element)replace_refs_elems.item(i)).getAttribute("id");
                if (id.equals("") || (replace_list = GSXML.getNamedElement(this.router.config_info, "replaceList", "id", id)) == null) continue;
                this.macro_resolver.addMacros(replace_list);
            }
        }
        return true;
    }

    protected Element getServiceDescription(String service_id, String lang, String subset) {
        Element service_elem = this.doc.createElement("service");
        service_elem.setAttribute("type", "retrieve");
        service_elem.setAttribute("name", service_id);
        return service_elem;
    }

    protected Element processDocumentMetadataRetrieve(Element request) {
        Element result = this.doc.createElement("response");
        String lang = request.getAttribute("lang");
        result.setAttribute("from", DOCUMENT_METADATA_RETRIEVE_SERVICE);
        result.setAttribute("type", "process");
        if (!this.does_metadata) {
            return result;
        }
        Element param_list = (Element)GSXML.getChildByTagName(request, "paramList");
        if (param_list == null) {
            GSXML.addError(this.doc, result, "DocumentMetadataRetrieve: missing paramList", "syntax");
            return result;
        }
        boolean external_id = false;
        ArrayList<String> metadata_names_list = new ArrayList<String>();
        boolean all_metadata = false;
        for (Element param = GSXML.getFirstElementChild(param_list); param != null; param = (Element)param.getNextSibling()) {
            if (param.getAttribute("name").equals("metadata")) {
                String metadata = GSXML.getValue(param);
                if (metadata.equals("all")) {
                    all_metadata = true;
                    break;
                }
                metadata_names_list.add(metadata);
                continue;
            }
            if (!param.getAttribute("name").equals(EXTID_PARAM) || !GSXML.getValue(param).equals("1")) continue;
            external_id = true;
        }
        if (!all_metadata && metadata_names_list.size() == 0) {
            GSXML.addError(this.doc, result, "DocumentMetadataRetrieve: no metadata names found in the paramList", "syntax");
            return result;
        }
        Element request_node_list = (Element)GSXML.getChildByTagName(request, "documentNodeList");
        if (request_node_list == null) {
            GSXML.addError(this.doc, result, "DocumentMetadataRetrieve: missing documentNodeList", "syntax");
            return result;
        }
        Element response_node_list = (Element)this.doc.importNode(request_node_list, true);
        result.appendChild(response_node_list);
        NodeList request_nodes = GSXML.getChildrenByTagName(response_node_list, "documentNode");
        if (request_nodes.getLength() == 0) {
            GSXML.addError(this.doc, result, "DocumentMetadataRetrieve: no documentNode found in the documentNodeList", "syntax");
            return result;
        }
        for (int i = 0; i < request_nodes.getLength(); ++i) {
            Element request_node = (Element)request_nodes.item(i);
            String node_id = request_node.getAttribute("nodeID");
            boolean is_external_link = false;
            if (!node_id.startsWith("HASH")) {
                if (node_id.endsWith(".rt")) {
                    if ((node_id = this.getHrefOID(node_id.substring(0, node_id.length() - 3))) != null) {
                        node_id = node_id + ".rt";
                    } else {
                        is_external_link = true;
                    }
                } else if ((node_id = this.getHrefOID(node_id)) == null) {
                    is_external_link = true;
                }
            }
            if (!is_external_link) {
                if (external_id) {
                    node_id = this.translateExternalId(node_id);
                } else if (this.idNeedsTranslating(node_id)) {
                    node_id = this.translateId(node_id);
                }
            }
            if (node_id == null) continue;
            if (!is_external_link) {
                try {
                    Element metadata_list = this.getMetadataList(node_id, all_metadata, metadata_names_list);
                    request_node.appendChild(metadata_list);
                    continue;
                }
                catch (GSException e) {
                    GSXML.addError(this.doc, result, e.getMessage(), e.getType());
                    if (!e.getType().equals("system")) continue;
                    return result;
                }
            }
            request_node.setAttribute("external_link", request_node.getAttribute("nodeID"));
        }
        return result;
    }

    protected Element processDocumentStructureRetrieve(Element request) {
        int i;
        Element result = this.doc.createElement("response");
        result.setAttribute("from", DOCUMENT_STRUCTURE_RETRIEVE_SERVICE);
        result.setAttribute("type", "process");
        if (!this.does_structure) {
            return result;
        }
        String lang = request.getAttribute("lang");
        Element param_list = (Element)GSXML.getChildByTagName(request, "paramList");
        if (param_list == null) {
            GSXML.addError(this.doc, result, "DocumentStructureRetrieve: missing paramList", "syntax");
            return result;
        }
        Element query_doc_list = (Element)GSXML.getChildByTagName(request, "documentNodeList");
        if (query_doc_list == null) {
            GSXML.addError(this.doc, result, "DocumentStructureRetrieve: missing documentNodeList", "syntax");
            return result;
        }
        Element response_node_list = (Element)this.doc.importNode(query_doc_list, true);
        result.appendChild(response_node_list);
        NodeList node_list = GSXML.getChildrenByTagName(response_node_list, "documentNode");
        if (node_list.getLength() == 0) {
            GSXML.addError(this.doc, result, "DocumentStructureRetrieve: no documentNode found in the documentNodeList", "syntax");
            return result;
        }
        Element extid_param = GSXML.getNamedElement(param_list, "param", "name", EXTID_PARAM);
        boolean external_id = false;
        if (extid_param != null && GSXML.getValue(extid_param).equals("1")) {
            external_id = true;
        }
        boolean want_structure = false;
        boolean want_info = false;
        ArrayList<String> info_types = new ArrayList<String>();
        boolean want_ancestors = false;
        boolean want_parent = false;
        boolean want_siblings = false;
        boolean want_children = false;
        boolean want_descendants = false;
        boolean want_entire_structure = false;
        NodeList params = param_list.getElementsByTagName("param");
        for (i = 0; i < params.getLength(); ++i) {
            Element param = (Element)params.item(i);
            String p_name = param.getAttribute("name");
            String p_value = GSXML.getValue(param);
            if (p_name.equals(STRUCT_PARAM)) {
                want_structure = true;
                if (p_value.equals(STRUCT_ANCESTORS)) {
                    want_ancestors = true;
                    continue;
                }
                if (p_value.equals(STRUCT_PARENT)) {
                    want_parent = true;
                    continue;
                }
                if (p_value.equals(STRUCT_SIBS)) {
                    want_siblings = true;
                    continue;
                }
                if (p_value.equals(STRUCT_CHILDREN)) {
                    want_children = true;
                    continue;
                }
                if (p_value.equals(STRUCT_DESCENDS)) {
                    want_descendants = true;
                    continue;
                }
                if (p_value.equals(STRUCT_ENTIRE)) {
                    want_entire_structure = true;
                    continue;
                }
                logger.error((Object)("AbstractDocumentRetrieve Warning: Unknown value \"" + p_value + "\"."));
                continue;
            }
            if (!p_name.equals(INFO_PARAM)) continue;
            want_info = true;
            info_types.add(p_value);
        }
        if (want_ancestors) {
            want_parent = false;
        }
        if (want_descendants) {
            want_children = false;
        }
        for (i = 0; i < node_list.getLength(); ++i) {
            Element doc = (Element)node_list.item(i);
            String doc_id = doc.getAttribute("nodeID");
            String is_external = doc.getAttribute("externalURL");
            boolean is_external_link = false;
            if (is_external.equals("0")) {
                is_external_link = true;
            }
            if (is_external.equals("1") && !doc_id.startsWith("HASH") && !is_external_link) {
                if (doc_id.endsWith(".rt")) {
                    if ((doc_id = this.getHrefOID(doc_id.substring(0, doc_id.length() - 3))) != null) {
                        doc_id = doc_id + ".rt";
                    } else {
                        is_external_link = true;
                    }
                } else if ((doc_id = this.getHrefOID(doc_id)) == null) {
                    is_external_link = true;
                }
            }
            if (!is_external_link) {
                Element parent_node;
                String parent_id;
                Element base_node;
                if (external_id) {
                    doc_id = this.translateExternalId(doc_id);
                    doc.setAttribute("nodeID", doc_id);
                } else if (this.idNeedsTranslating(doc_id)) {
                    doc_id = this.translateId(doc_id);
                    doc.setAttribute("nodeID", doc_id);
                }
                if (doc_id == null) continue;
                if (want_info) {
                    Element node_info_elem = this.doc.createElement("nodeStructureInfo");
                    doc.appendChild(node_info_elem);
                    for (int j = 0; j < info_types.size(); ++j) {
                        String info_type = (String)info_types.get(j);
                        String info_value = this.getStructureInfo(doc_id, info_type);
                        if (info_value == null) continue;
                        Element info_elem = this.doc.createElement(INFO_PARAM);
                        info_elem.setAttribute("name", info_type);
                        info_elem.setAttribute("value", info_value);
                        node_info_elem.appendChild(info_elem);
                    }
                }
                if (!want_structure) continue;
                Element structure_elem = this.doc.createElement("nodeStructure");
                doc.appendChild(structure_elem);
                if (want_entire_structure) {
                    String root_id = this.getRootId(doc_id);
                    Element root_node = this.createDocNode(root_id);
                    this.addDescendants(root_node, root_id, true);
                    structure_elem.appendChild(root_node);
                    continue;
                }
                Element top_node = base_node = this.createDocNode(doc_id);
                if (want_ancestors) {
                    String parent_id2;
                    String current_id = doc_id;
                    while ((parent_id2 = this.getParentId(current_id)) != null) {
                        Element parent_node2 = this.createDocNode(parent_id2);
                        parent_node2.appendChild(top_node);
                        current_id = parent_id2;
                        top_node = parent_node2;
                    }
                } else if (want_parent && (parent_id = this.getParentId(doc_id)) != null) {
                    parent_node = this.createDocNode(parent_id);
                    parent_node.appendChild(base_node);
                    top_node = parent_node;
                }
                structure_elem.appendChild(top_node);
                if (want_siblings && (parent_id = this.getParentId(doc_id)) != null) {
                    parent_node = (Element)base_node.getParentNode();
                    base_node = this.addSiblings(parent_node, parent_id, doc_id);
                }
                if (want_children) {
                    this.addDescendants(base_node, doc_id, false);
                    continue;
                }
                if (!want_descendants) continue;
                this.addDescendants(base_node, doc_id, true);
                continue;
            }
            Element external_link_elem = this.doc.createElement("external");
            external_link_elem.setAttribute("external_link", doc.getAttribute("nodeID"));
            doc.appendChild(external_link_elem);
        }
        return result;
    }

    protected Element processDocumentContentRetrieve(Element request) {
        Element query_doc_list;
        Element result = this.doc.createElement("response");
        result.setAttribute("from", DOCUMENT_CONTENT_RETRIEVE_SERVICE);
        result.setAttribute("type", "process");
        if (!this.does_content) {
            return result;
        }
        Element param_list = (Element)GSXML.getChildByTagName(request, "paramList");
        Element extid_param = GSXML.getNamedElement(param_list, "param", "name", EXTID_PARAM);
        boolean external_id = false;
        if (extid_param != null && GSXML.getValue(extid_param).equals("1")) {
            external_id = true;
        }
        if ((query_doc_list = (Element)GSXML.getChildByTagName(request, "documentNodeList")) == null) {
            logger.error((Object)"Error: DocumentContentRetrieve request specified no doc nodes.\n");
            return result;
        }
        String lang = request.getAttribute("lang");
        Element doc_list = this.doc.createElement("documentNodeList");
        result.appendChild(doc_list);
        String[] doc_ids = GSXML.getAttributeValuesFromList(query_doc_list, "nodeID");
        String[] is_externals = GSXML.getAttributeValuesFromList(query_doc_list, "externalURL");
        for (int i = 0; i < doc_ids.length; ++i) {
            Element doc;
            String doc_id = doc_ids[i];
            String is_external = is_externals[i];
            boolean is_external_link = false;
            if (is_external.equals("0")) {
                is_external_link = true;
            }
            if (is_external.equals("1") && !doc_id.startsWith("HASH") && !is_external_link) {
                String find_doc_id;
                if (doc_id.endsWith(".rt")) {
                    find_doc_id = this.getHrefOID(doc_id.substring(0, doc_id.length() - 3));
                    if (find_doc_id != null) {
                        doc_id = doc_id + ".rt";
                    } else {
                        is_external_link = true;
                    }
                } else {
                    find_doc_id = this.getHrefOID(doc_id);
                    if (find_doc_id == null) {
                        is_external_link = true;
                    } else {
                        doc_id = find_doc_id;
                    }
                }
            }
            if (!is_external_link) {
                doc = this.doc.createElement("documentNode");
                doc.setAttribute("nodeID", doc_id);
                doc_list.appendChild(doc);
                if (external_id) {
                    doc_id = this.translateExternalId(doc_id);
                    doc.setAttribute("nodeID", doc_id);
                } else if (this.idNeedsTranslating(doc_id)) {
                    doc_id = this.translateId(doc_id);
                    doc.setAttribute("nodeID", doc_id);
                }
                if (doc_id == null) continue;
                try {
                    Element node_content = this.getNodeContent(doc_id, lang);
                    doc.appendChild(node_content);
                    continue;
                }
                catch (GSException e) {
                    GSXML.addError(this.doc, result, e.getMessage());
                    return result;
                }
            }
            doc = this.doc.createElement("documentNode");
            doc.setAttribute("nodeID", doc_id);
            Element external_link_elem = this.doc.createElement("external");
            external_link_elem.setAttribute("external_link", doc_id);
            doc.appendChild(external_link_elem);
            doc_list.appendChild(doc);
        }
        return result;
    }

    protected Element createDocNode(String node_id) {
        Element node = this.doc.createElement("documentNode");
        node.setAttribute("nodeID", node_id);
        String doc_type = null;
        doc_type = this.default_document_type != null ? this.default_document_type : this.getDocType(node_id);
        node.setAttribute("docType", doc_type);
        String node_type = this.getNodeType(node_id, doc_type);
        node.setAttribute("nodeType", node_type);
        return node;
    }

    protected void addDescendants(Element doc, String doc_id, boolean recursive) {
        ArrayList child_ids = this.getChildrenIds(doc_id);
        if (child_ids == null) {
            return;
        }
        for (int i = 0; i < child_ids.size(); ++i) {
            String child_id = (String)child_ids.get(i);
            Element child_elem = this.createDocNode(child_id);
            doc.appendChild(child_elem);
            if (!recursive || child_elem.getAttribute("nodeType").equals("leaf")) continue;
            this.addDescendants(child_elem, child_id, recursive);
        }
    }

    protected Element addSiblings(Element parent_node, String parent_id, String current_id) {
        Element current_node = GSXML.getFirstElementChild(parent_node);
        if (current_node == null) {
            logger.error((Object)" there should be a first child.");
            return null;
        }
        parent_node.removeChild(current_node);
        this.addDescendants(parent_node, parent_id, false);
        Element new_current = GSXML.getNamedElement(parent_node, current_node.getNodeName(), "nodeID", current_id);
        return new_current;
    }

    protected boolean idNeedsTranslating(String id) {
        return OID.needsTranslating(id);
    }

    protected ArrayList getSiblingIds(String node_id) {
        String parent_id = this.getParentId(node_id);
        if (parent_id == null) {
            return null;
        }
        return this.getChildrenIds(parent_id);
    }

    protected String getNodeType(String node_id, String doc_type) {
        if (doc_type.equals("simple")) {
            return "leaf";
        }
        if (this.getParentId(node_id) == null) {
            return "root";
        }
        if (doc_type.equals("paged")) {
            return "leaf";
        }
        if (this.getChildrenIds(node_id) == null) {
            return "leaf";
        }
        return "internal";
    }

    protected String translateId(String id) {
        return id.substring(0, id.length());
    }

    protected String translateExternalId(String id) {
        return id;
    }

    protected String getDocType(String node_id) {
        return "simple";
    }

    protected String getRootId(String node_id) {
        return node_id;
    }

    protected ArrayList getChildrenIds(String node_id) {
        return null;
    }

    protected String getParentId(String node_id) {
        return null;
    }

    protected abstract Element getMetadataList(String var1, boolean var2, ArrayList var3) throws GSException;

    protected abstract Element getNodeContent(String var1, String var2) throws GSException;

    protected abstract String getStructureInfo(String var1, String var2);

    protected String getHrefOID(String href_url) {
        return null;
    }
}

