/*
 * Decompiled with CFR 0.152.
 */
package org.greenstone.gsdl3.core;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import org.apache.log4j.Logger;
import org.greenstone.gsdl3.core.ModuleInterface;
import org.greenstone.gsdl3.util.GSXML;
import org.greenstone.gsdl3.util.OAIXML;
import org.greenstone.gsdl3.util.XMLConverter;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class OAIReceptionist
implements ModuleInterface {
    static Logger logger = Logger.getLogger((String)OAIReceptionist.class.getName());
    protected String site_name = null;
    protected Document doc = null;
    protected XMLConverter converter = new XMLConverter();
    protected Element oai_config = null;
    protected int resume_after = -1;
    protected ModuleInterface mr = null;

    public OAIReceptionist() {
        OAIReceptionist oAIReceptionist = this;
        this.doc = oAIReceptionist.converter.newDOM();
    }

    public void cleanUp() {
    }

    public void setSiteName(String site_name) {
        this.site_name = site_name;
    }

    public void setMessageRouter(ModuleInterface mr) {
        this.mr = mr;
    }

    public boolean configure(Element config) {
        if (this.mr == null) {
            logger.error((Object)" message routers must be set  before calling oai configure");
            return false;
        }
        if (config == null) {
            logger.error((Object)" oai configure file is null");
            return false;
        }
        this.oai_config = config;
        this.resume_after = this.getResumeAfter();
        OAIXML.init();
        OAIXML.clearExpiredTokens();
        return true;
    }

    public String process(String xml_in) {
        Document message_node = this.converter.getDOM(xml_in);
        Node page = this.process(message_node);
        return XMLConverter.getString(page);
    }

    private Element getMessage(Element e) {
        Element msg = OAIXML.createElement("message");
        msg.appendChild(OAIXML.getResponse(e));
        return msg;
    }

    public Node process(Node message_node) {
        logger.error((Object)"OAIReceptionist received request");
        Element message = XMLConverter.nodeToElement(message_node);
        logger.error((Object)XMLConverter.getString(message));
        if (!message.getTagName().equals("message")) {
            logger.error((Object)(" Invalid message. GSDL message should start with <message>, instead it starts with:" + message.getTagName() + "."));
            return this.getMessage(OAIXML.createErrorElement("badArgument", ""));
        }
        Element request = (Element)GSXML.getChildByTagName(message, "request");
        if (request == null) {
            logger.error((Object)" message had no request!");
            return this.getMessage(OAIXML.createErrorElement("badArgument", ""));
        }
        String verb = request.getAttribute("to");
        if (verb.equals("Identify")) {
            return this.doIdentify();
        }
        if (verb.equals("ListMetadataFormats")) {
            return this.doListMetadataFormats(message);
        }
        if (verb.equals("ListSets")) {
            return this.doListSets(message);
        }
        if (verb.equals("GetRecord")) {
            return this.doGetRecord(message);
        }
        if (verb.equals("ListIdentifiers")) {
            return this.doListIdentifiers(message);
        }
        if (verb.equals("ListRecords")) {
            return this.doListRecords(message);
        }
        return this.getMessage(OAIXML.createErrorElement("Unexpected things happened", ""));
    }

    private NodeList getOAICollectionList() {
        Element message = this.doc.createElement("message");
        Element request = this.doc.createElement("request");
        message.appendChild(request);
        request.setAttribute("type", "oaiSetList");
        request.setAttribute("to", "");
        Node msg_node = this.mr.process(message);
        if (msg_node == null) {
            logger.error((Object)"returned msg_node from mr is null");
            return null;
        }
        Element resp = (Element)GSXML.getChildByTagName(msg_node, "response");
        Element coll_list = (Element)GSXML.getChildByTagName(resp, "collectionList");
        if (coll_list == null) {
            logger.error((Object)"coll_list is null");
            return null;
        }
        NodeList list = coll_list.getElementsByTagName("collection");
        int length = list.getLength();
        if (length == 0) {
            logger.error((Object)"length is 0");
            return null;
        }
        return list;
    }

    private void getSets(Element list_sets_elem, NodeList oai_coll, int start_point, int end_point) {
        for (int i = start_point; i < end_point; ++i) {
            String coll_spec = ((Element)oai_coll.item(i)).getAttribute("name");
            String coll_name = coll_spec.substring(coll_spec.indexOf(":") + 1);
            Element set = OAIXML.createElement("set");
            Element set_spec = OAIXML.createElement("setSpec");
            GSXML.setNodeText(set_spec, coll_spec);
            set.appendChild(set_spec);
            Element set_name = OAIXML.createElement("setName");
            GSXML.setNodeText(set_name, coll_name);
            set.appendChild(set_name);
            list_sets_elem.appendChild(set);
        }
    }

    private int getResumeAfter() {
        Element resume_after = (Element)GSXML.getChildByTagName(this.oai_config, "resumeAfter");
        if (resume_after != null) {
            return Integer.parseInt(GSXML.getNodeText(resume_after));
        }
        return -1;
    }

    private Element doListSets(Element msg) {
        int smaller;
        logger.info((Object)"");
        Element list_sets_elem = OAIXML.createElement("ListSets");
        NodeList oai_coll = this.getOAICollectionList();
        int oai_coll_size = oai_coll.getLength();
        if (oai_coll_size == 0) {
            return this.getMessage(list_sets_elem);
        }
        Element req = (Element)GSXML.getChildByTagName(msg, "request");
        if (req == null) {
            logger.error((Object)"req is null");
            return null;
        }
        NodeList params = GSXML.getChildrenByTagName(req, "param");
        Element param = null;
        int n = smaller = oai_coll_size > this.resume_after ? this.resume_after : oai_coll_size;
        if (params.getLength() > 1) {
            return this.getMessage(OAIXML.createErrorElement("badArgument", ""));
        }
        if (params.getLength() == 0) {
            if (this.resume_after < 0 || oai_coll_size <= this.resume_after) {
                this.getSets(list_sets_elem, oai_coll, 0, oai_coll_size);
                return this.getMessage(list_sets_elem);
            }
            this.getSets(list_sets_elem, oai_coll, 0, smaller);
            if (oai_coll_size > this.resume_after) {
                Element token = this.createResumptionTokenElement(oai_coll_size, 0, this.resume_after, true);
                OAIXML.addToken(token);
                list_sets_elem.appendChild(token);
            }
            return this.getMessage(list_sets_elem);
        }
        param = (Element)params.item(0);
        String param_name = param.getAttribute("name");
        if (!param_name.equals("resumptionToken")) {
            return this.getMessage(OAIXML.createErrorElement("badArgument", ""));
        }
        String token = param.getAttribute("value");
        if (!OAIXML.containsToken(token)) {
            return this.getMessage(OAIXML.createErrorElement("badResumptionToken", ""));
        }
        int index = token.indexOf(":");
        int cursor = Integer.parseInt(token.substring(index + 1));
        Element token_elem = null;
        if (cursor + this.resume_after >= oai_coll_size) {
            this.getSets(list_sets_elem, oai_coll, cursor, oai_coll_size);
            token_elem = this.createResumptionTokenElement(oai_coll_size, cursor, -1, false);
            list_sets_elem.appendChild(token_elem);
        } else {
            this.getSets(list_sets_elem, oai_coll, cursor, cursor + this.resume_after);
            token_elem = this.createResumptionTokenElement(oai_coll_size, cursor, cursor + this.resume_after, true);
            OAIXML.addToken(token_elem);
            list_sets_elem.appendChild(token_elem);
        }
        return this.getMessage(list_sets_elem);
    }

    private Element createResumptionTokenElement(int total_size, int cursor, int so_far_sent, boolean set_expiration) {
        Element token = OAIXML.createElement("resumptionToken");
        token.setAttribute("completeListSize", "" + total_size);
        token.setAttribute("cursor", "" + cursor);
        if (set_expiration) {
            String expiration_date = OAIXML.getTime(System.currentTimeMillis() + OAIXML.getTokenExpiration());
            token.setAttribute("expirationDate", expiration_date);
        }
        if (so_far_sent > 0) {
            GSXML.setNodeText(token, "GS3OAI" + System.currentTimeMillis() + ":" + so_far_sent);
        }
        return token;
    }

    private boolean isValidParam(HashMap param_map, HashSet valid_strs) {
        ArrayList param_list = new ArrayList(param_map.keySet());
        for (int i = 0; i < param_list.size(); ++i) {
            if (valid_strs.contains((String)param_list.get(i))) continue;
            return false;
        }
        return true;
    }

    private Element doListIdentifiers(Element msg) {
        HashSet<String> valid_strs = new HashSet<String>();
        valid_strs.add("from");
        valid_strs.add("until");
        valid_strs.add("set");
        valid_strs.add("metadataPrefix");
        valid_strs.add("resumptionToken");
        Element list_identifiers = OAIXML.createElement("ListIdentifiers");
        Element req = (Element)GSXML.getChildByTagName(msg, "request");
        if (req == null) {
            logger.error((Object)"req is null");
            return null;
        }
        NodeList params = GSXML.getChildrenByTagName(req, "param");
        String coll_name = "";
        String token = "";
        HashMap param_map = OAIXML.getParamMap(params);
        if (!this.isValidParam(param_map, valid_strs) || !param_map.containsKey("metadataPrefix")) {
            logger.error((Object)"contains invalid params or no metadataPrefix");
            return this.getMessage(OAIXML.createErrorElement("badArgument", ""));
        }
        NodeList oai_coll = this.getOAICollectionList();
        int oai_coll_size = oai_coll.getLength();
        if (oai_coll_size == 0) {
            logger.info((Object)"returned oai collection list is empty");
            return this.getMessage(OAIXML.createErrorElement("noRecordsMatch", ""));
        }
        String prefix_value = (String)param_map.get("metadataPrefix");
        if (!this.containsMetadataPrefix(prefix_value)) {
            logger.error((Object)"requested prefix is not found in OAIConfig.xml");
            return this.getMessage(OAIXML.createErrorElement("cannotDisseminateFormat", ""));
        }
        boolean request_set = param_map.containsKey("set");
        if (request_set) {
            boolean set_supported = false;
            String set_spec_str = (String)param_map.get("set");
            String[] strs = this.splitSetSpec(set_spec_str);
            coll_name = strs[1];
            for (int i = 0; i < oai_coll_size; ++i) {
                if (!set_spec_str.equals(((Element)oai_coll.item(i)).getAttribute("name"))) continue;
                set_supported = true;
            }
            if (!set_supported) {
                logger.error((Object)"requested set is not found in this repository");
                return this.getMessage(OAIXML.createErrorElement("badArgument", ""));
            }
        }
        if (param_map.containsKey("resumptionToken")) {
            token = (String)param_map.get("resumptionToken");
            logger.info((Object)("has resumptionToken" + token));
            if (!OAIXML.containsToken(token)) {
                return this.getMessage(OAIXML.createErrorElement("badResumptionToken", ""));
            }
        }
        Element result = null;
        String verb = req.getAttribute("to");
        NodeList param_list = req.getElementsByTagName("param");
        ArrayList<Element> retain_param_list = new ArrayList<Element>();
        for (int j = 0; j < param_list.getLength(); ++j) {
            Element e = OAIXML.duplicateElement(msg.getOwnerDocument(), (Element)param_list.item(j), true);
            retain_param_list.add(e);
        }
        if (!request_set) {
            logger.info((Object)"requesting identifiers of all collections");
            for (int i = 0; i < oai_coll_size; ++i) {
                if (req == null) {
                    req = msg.getOwnerDocument().createElement("request");
                    msg.appendChild(req);
                    for (int j = 0; j < retain_param_list.size(); ++j) {
                        req.appendChild((Element)retain_param_list.get(j));
                    }
                }
                String full_name = ((Element)oai_coll.item(i)).getAttribute("name");
                coll_name = full_name.substring(full_name.indexOf(":") + 1);
                req.setAttribute("to", coll_name + "/" + verb);
                Node n = this.mr.process(msg);
                Element e = XMLConverter.nodeToElement(n);
                result = this.collectAll(result, e, verb, "header");
                msg.removeChild(req);
                req = null;
            }
        } else {
            req.setAttribute("to", coll_name + "/" + verb);
            Node result_node = this.mr.process(msg);
            result = XMLConverter.nodeToElement(result_node);
        }
        if (result == null) {
            logger.info((Object)"message router returns null");
            return this.getMessage(OAIXML.createErrorElement("Internal service returns null", ""));
        }
        Element res = (Element)GSXML.getChildByTagName(result, "response");
        if (res == null) {
            logger.info((Object)"response element in xml_result is null");
            return this.getMessage(OAIXML.createErrorElement("Internal service returns null", ""));
        }
        NodeList header_list = res.getElementsByTagName("header");
        int num_headers = header_list.getLength();
        if (num_headers == 0) {
            logger.info((Object)"message router returns 0 headers.");
            return this.getMessage(OAIXML.createErrorElement("noRecordsMatch", ""));
        }
        if (token.equals("")) {
            if (this.resume_after < 0 || num_headers <= this.resume_after) {
                return result;
            }
            this.getRecords(list_identifiers, header_list, 0, this.resume_after);
            Element token_elem = this.createResumptionTokenElement(num_headers, 0, this.resume_after, true);
            OAIXML.addToken(token_elem);
            list_identifiers.appendChild(token_elem);
            return this.getMessage(list_identifiers);
        }
        if (!token.equals("")) {
            int index = token.indexOf(":");
            int cursor = Integer.parseInt(token.substring(index + 1));
            Element token_elem = null;
            if (cursor + this.resume_after >= num_headers) {
                this.getRecords(list_identifiers, header_list, cursor, num_headers);
                token_elem = this.createResumptionTokenElement(num_headers, cursor, -1, false);
                list_identifiers.appendChild(token_elem);
            } else {
                this.getRecords(list_identifiers, header_list, cursor, cursor + this.resume_after);
                token_elem = this.createResumptionTokenElement(num_headers, cursor, cursor + this.resume_after, true);
                OAIXML.addToken(token_elem);
                list_identifiers.appendChild(token_elem);
            }
            return this.getMessage(list_identifiers);
        }
        return result;
    }

    private Element doListRecords(Element msg) {
        logger.info((Object)"");
        HashSet<String> valid_strs = new HashSet<String>();
        valid_strs.add("from");
        valid_strs.add("until");
        valid_strs.add("set");
        valid_strs.add("metadataPrefix");
        valid_strs.add("resumptionToken");
        Element list_records = OAIXML.createElement("ListRecords");
        Element req = (Element)GSXML.getChildByTagName(msg, "request");
        if (req == null) {
            logger.error((Object)"req is null");
            return null;
        }
        NodeList params = GSXML.getChildrenByTagName(req, "param");
        String coll_name = "";
        String token = "";
        if (params.getLength() == 0) {
            logger.error((Object)"must at least have the metadataPrefix parameter, can't be none");
            return this.getMessage(OAIXML.createErrorElement("badArgument", ""));
        }
        HashMap param_map = OAIXML.getParamMap(params);
        if (!this.isValidParam(param_map, valid_strs) || !param_map.containsKey("metadataPrefix")) {
            logger.error((Object)"no metadataPrefix");
            return this.getMessage(OAIXML.createErrorElement("badArgument", ""));
        }
        NodeList oai_coll = this.getOAICollectionList();
        int oai_coll_size = oai_coll.getLength();
        if (oai_coll_size == 0) {
            logger.info((Object)"returned oai collection list is empty");
            return this.getMessage(OAIXML.createErrorElement("noRecordsMatch", ""));
        }
        String prefix_value = (String)param_map.get("metadataPrefix");
        if (!this.containsMetadataPrefix(prefix_value)) {
            logger.error((Object)"requested prefix is not found in OAIConfig.xml");
            return this.getMessage(OAIXML.createErrorElement("cannotDisseminateFormat", ""));
        }
        boolean request_set = param_map.containsKey("set");
        if (request_set) {
            boolean set_supported = false;
            String set_spec_str = (String)param_map.get("set");
            String[] strs = this.splitSetSpec(set_spec_str);
            coll_name = strs[1];
            for (int i = 0; i < oai_coll_size; ++i) {
                if (!set_spec_str.equals(((Element)oai_coll.item(i)).getAttribute("name"))) continue;
                set_supported = true;
            }
            if (!set_supported) {
                logger.error((Object)"requested set is not found in this repository");
                return this.getMessage(OAIXML.createErrorElement("badArgument", ""));
            }
        }
        if (param_map.containsKey("resumptionToken")) {
            token = (String)param_map.get("resumptionToken");
            logger.info((Object)("has resumptionToken" + token));
            if (!OAIXML.containsToken(token)) {
                return this.getMessage(OAIXML.createErrorElement("badResumptionToken", ""));
            }
        }
        Element result = null;
        String verb = req.getAttribute("to");
        NodeList param_list = req.getElementsByTagName("param");
        ArrayList<Element> retain_param_list = new ArrayList<Element>();
        for (int j = 0; j < param_list.getLength(); ++j) {
            Element e = OAIXML.duplicateElement(msg.getOwnerDocument(), (Element)param_list.item(j), true);
            retain_param_list.add(e);
        }
        if (!request_set) {
            for (int i = 0; i < oai_coll_size; ++i) {
                if (req == null) {
                    req = msg.getOwnerDocument().createElement("request");
                    msg.appendChild(req);
                    for (int j = 0; j < retain_param_list.size(); ++j) {
                        req.appendChild((Element)retain_param_list.get(j));
                    }
                }
                String full_name = ((Element)oai_coll.item(i)).getAttribute("name");
                coll_name = full_name.substring(full_name.indexOf(":") + 1);
                req.setAttribute("to", coll_name + "/" + verb);
                Node n = this.mr.process(msg);
                Element e = XMLConverter.nodeToElement(n);
                result = this.collectAll(result, e, verb, "record");
                msg.removeChild(req);
                req = null;
            }
        } else {
            req.setAttribute("to", coll_name + "/" + verb);
            Node result_node = this.mr.process(msg);
            result = XMLConverter.nodeToElement(result_node);
        }
        if (result == null) {
            logger.info((Object)"message router returns null");
            return this.getMessage(OAIXML.createErrorElement("Internal service returns null", ""));
        }
        Element res = (Element)GSXML.getChildByTagName(result, "response");
        if (res == null) {
            logger.info((Object)"response element in xml_result is null");
            return this.getMessage(OAIXML.createErrorElement("Internal service returns null", ""));
        }
        NodeList record_list = res.getElementsByTagName("record");
        int num_records = record_list.getLength();
        if (num_records == 0) {
            logger.info((Object)"message router returns 0 records.");
            return this.getMessage(OAIXML.createErrorElement("noRecordsMatch", ""));
        }
        if (token.equals("")) {
            if (this.resume_after < 0 || num_records <= this.resume_after) {
                return result;
            }
            this.getRecords(list_records, record_list, 0, this.resume_after);
            Element token_elem = this.createResumptionTokenElement(num_records, 0, this.resume_after, true);
            OAIXML.addToken(token_elem);
            list_records.appendChild(token_elem);
            return this.getMessage(list_records);
        }
        if (!token.equals("")) {
            int index = token.indexOf(":");
            int cursor = Integer.parseInt(token.substring(index + 1));
            Element token_elem = null;
            if (cursor + this.resume_after >= num_records) {
                this.getRecords(list_records, record_list, cursor, num_records);
                token_elem = this.createResumptionTokenElement(num_records, cursor, -1, false);
                list_records.appendChild(token_elem);
            } else {
                this.getRecords(list_records, record_list, cursor, cursor + this.resume_after);
                token_elem = this.createResumptionTokenElement(num_records, cursor, cursor + this.resume_after, true);
                OAIXML.addToken(token_elem);
                list_records.appendChild(token_elem);
            }
            return this.getMessage(list_records);
        }
        return result;
    }

    private void getRecords(Element verb_elem, NodeList list, int start_point, int end_point) {
        for (int i = start_point; i < end_point; ++i) {
            verb_elem.appendChild(verb_elem.getOwnerDocument().importNode(list.item(i), true));
        }
    }

    private Element collectAll(Element result, Element msg, String verb, String elem_name) {
        if (result == null) {
            return msg;
        }
        Element res_in_result = (Element)GSXML.getChildByTagName(result, "response");
        Element verb_elem = (Element)GSXML.getChildByTagName(res_in_result, verb);
        if (msg == null) {
            return result;
        }
        NodeList elem_list = msg.getElementsByTagName(elem_name);
        for (int i = 0; i < elem_list.getLength(); ++i) {
            verb_elem.appendChild(res_in_result.getOwnerDocument().importNode(elem_list.item(i), true));
        }
        return result;
    }

    private Element doListMetadataFormats(Element msg) {
        Element list_metadata_formats = OAIXML.createElement("ListMetadataFormats");
        Element req = (Element)GSXML.getChildByTagName(msg, "request");
        if (req == null) {
            logger.error((Object)"");
            return null;
        }
        NodeList params = GSXML.getChildrenByTagName(req, "param");
        Element param = null;
        if (params.getLength() == 0) {
            Element oai_config = OAIXML.getOAIConfigXML();
            if (oai_config == null) {
                return this.getMessage(OAIXML.createErrorElement("error", "service unavailable"));
            }
            Element format_list = (Element)GSXML.getChildByTagName(oai_config, "ListMetadataFormats");
            if (format_list == null) {
                logger.error((Object)"OAIConfig.xml must contain the supported metadata formats");
                return this.getMessage(list_metadata_formats);
            }
            NodeList formats = format_list.getElementsByTagName("metadataFormat");
            for (int i = 0; i < formats.getLength(); ++i) {
                Element meta_fmt = OAIXML.createElement("metadataFormat");
                Element first_meta_format = (Element)formats.item(i);
                meta_fmt.appendChild(meta_fmt.getOwnerDocument().importNode(GSXML.getChildByTagName(first_meta_format, "metadataPrefix"), true));
                meta_fmt.appendChild(meta_fmt.getOwnerDocument().importNode(GSXML.getChildByTagName(first_meta_format, "schema"), true));
                meta_fmt.appendChild(meta_fmt.getOwnerDocument().importNode(GSXML.getChildByTagName(first_meta_format, "metadataNamespace"), true));
                list_metadata_formats.appendChild(meta_fmt);
            }
            return this.getMessage(list_metadata_formats);
        }
        if (params.getLength() > 1) {
            return this.getMessage(OAIXML.createErrorElement("badArgument", ""));
        }
        param = (Element)params.item(0);
        String param_name = param.getAttribute("name");
        String identifier = "";
        if (!param_name.equals("identifier")) {
            return this.getMessage(OAIXML.createErrorElement("badArgument", ""));
        }
        identifier = param.getAttribute("value");
        String[] strs = identifier.split(":");
        if (strs == null || strs.length < 3) {
            logger.error((Object)("identifier is not in the form site:coll:id" + identifier));
            return this.getMessage(OAIXML.createErrorElement("idDoesNotExist", ""));
        }
        strs = this.splitNames(identifier);
        String name_of_site = strs[0];
        String coll_name = strs[1];
        String oid = strs[2];
        String verb = req.getAttribute("to");
        req.setAttribute("to", coll_name + "/" + verb);
        param.setAttribute("name", "OID");
        param.setAttribute("value", oid);
        Node result_node = this.mr.process(msg);
        return XMLConverter.nodeToElement(result_node);
    }

    private void appendParam(Element req, String name, String value) {
        Element param = req.getOwnerDocument().createElement("param");
        param.setAttribute("name", name);
        param.setAttribute("value", value);
        req.appendChild(param);
    }

    private void copyElement(Element identify, String tag_name) {
        Element from_repository_name = (Element)GSXML.getChildByTagName(this.oai_config, tag_name);
        if (from_repository_name != null) {
            Element this_repository_name = OAIXML.createElement(tag_name);
            GSXML.setNodeText(this_repository_name, GSXML.getNodeText(from_repository_name));
            identify.appendChild(this_repository_name);
        }
    }

    private Element doIdentify() {
        logger.info((Object)"");
        Element identify = OAIXML.createElement("Identify");
        this.copyElement(identify, "repositoryName");
        this.copyElement(identify, "baseURL");
        this.copyElement(identify, "protocolVersion");
        this.copyElement(identify, "deletedRecord");
        this.copyElement(identify, "granularity");
        NodeList admin_emails = GSXML.getChildrenByTagName(this.oai_config, "adminEmail");
        int num_admin = 0;
        Object from_admin_email = null;
        if (admin_emails != null) {
            num_admin = admin_emails.getLength();
        }
        for (int i = 0; i < num_admin; ++i) {
            this.copyElement(identify, "adminEmail");
        }
        long lastmodified = System.currentTimeMillis();
        NodeList oai_coll = this.getOAICollectionList();
        int oai_coll_size = oai_coll.getLength();
        if (oai_coll_size == 0) {
            logger.info((Object)"returned oai collection list is empty. Set repository earliestDatestamp to be 1970-01-01.");
            lastmodified = 0L;
        }
        for (int i = 0; i < oai_coll_size; ++i) {
            long coll_build_time = Long.parseLong(((Element)oai_coll.item(i)).getAttribute("lastmodified"));
            lastmodified = lastmodified > coll_build_time ? coll_build_time : lastmodified;
        }
        String earliestDatestamp_str = OAIXML.getTime(lastmodified);
        Element earliestDatestamp_elem = OAIXML.createElement("earliestDatestamp");
        GSXML.setNodeText(earliestDatestamp_elem, earliestDatestamp_str);
        identify.appendChild(earliestDatestamp_elem);
        return this.getMessage(identify);
    }

    private String[] splitSetSpec(String set_spec) {
        logger.info((Object)set_spec);
        String[] strs = new String[2];
        int colon_index = set_spec.indexOf(":");
        strs[0] = set_spec.substring(0, colon_index);
        strs[1] = set_spec.substring(colon_index + 1);
        return strs;
    }

    private String[] splitNames(String identifier) {
        logger.info((Object)identifier);
        String[] strs = new String[3];
        int first_colon = identifier.indexOf(":");
        strs[0] = identifier.substring(0, first_colon);
        String sr = identifier.substring(first_colon + 1);
        int second_colon = sr.indexOf(":");
        strs[1] = sr.substring(0, second_colon);
        strs[2] = sr.substring(second_colon + 1);
        return strs;
    }

    private boolean containsMetadataPrefix(String prefix_value) {
        NodeList prefix_list = this.oai_config.getElementsByTagName("metadataPrefix");
        for (int i = 0; i < prefix_list.getLength(); ++i) {
            if (!prefix_value.equals(GSXML.getNodeText((Element)prefix_list.item(i)).trim())) continue;
            return true;
        }
        return false;
    }

    private Element doGetRecord(Element msg) {
        logger.info((Object)"");
        Element get_record = OAIXML.createElement("GetRecord");
        HashSet<String> valid_strs = new HashSet<String>();
        valid_strs.add("identifier");
        valid_strs.add("metadataPrefix");
        Element req = (Element)GSXML.getChildByTagName(msg, "request");
        NodeList params = GSXML.getChildrenByTagName(req, "param");
        HashMap param_map = OAIXML.getParamMap(params);
        if (!(this.isValidParam(param_map, valid_strs) && params.getLength() != 0 && param_map.containsKey("identifier") && param_map.containsKey("metadataPrefix"))) {
            logger.error((Object)"must have the metadataPrefix/identifier parameter.");
            return this.getMessage(OAIXML.createErrorElement("badArgument", ""));
        }
        String prefix = (String)param_map.get("metadataPrefix");
        String identifier = (String)param_map.get("identifier");
        if (!this.containsMetadataPrefix(prefix)) {
            logger.error((Object)"requested prefix is not found in OAIConfig.xml");
            return this.getMessage(OAIXML.createErrorElement("cannotDisseminateFormat", ""));
        }
        String[] strs = this.splitNames(identifier);
        if (strs == null || strs.length < 3) {
            logger.error((Object)("identifier is not in the form site:coll:id" + identifier));
            return this.getMessage(OAIXML.createErrorElement("idDoesNotExist", ""));
        }
        String name_of_site = strs[0];
        String coll_name = strs[1];
        String oid = strs[2];
        String verb = req.getAttribute("to");
        req.setAttribute("to", coll_name + "/" + verb);
        Element param = GSXML.getNamedElement(req, "param", "name", "identifier");
        if (param != null) {
            param.setAttribute("name", "OID");
            param.setAttribute("value", oid);
        }
        Node result_node = this.mr.process(msg);
        return XMLConverter.nodeToElement(result_node);
    }
}

