/*
 * Decompiled with CFR 0.152.
 */
package org.greenstone.gsdl3.build;

import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.util.Vector;
import org.greenstone.gsdl3.build.CollectionConstructor;
import org.greenstone.gsdl3.build.ConstructionEvent;
import org.greenstone.gsdl3.util.GSFile;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class GS2PerlConstructor
extends CollectionConstructor {
    public static final int NEW = 0;
    public static final int IMPORT = 1;
    public static final int BUILD = 2;
    public static final int ACTIVATE = 3;
    protected String gsdl2home = null;
    protected String gsdl3home = null;
    protected String gsdlos = null;
    protected String path = null;

    public GS2PerlConstructor(String name) {
        super(name);
    }

    public boolean configure() {
        this.gsdl2home = System.getProperty("GSDLHOME");
        this.gsdl3home = System.getProperty("GSDL3HOME");
        this.gsdlos = System.getProperty("GSDLOS");
        this.path = System.getProperty("PATH");
        if (this.gsdl2home == null) {
            System.err.println("You must have greenstone2 installed, and GSDLHOME set for GS2Perl building to work!!");
            return false;
        }
        if (this.gsdl3home == null || this.gsdlos == null) {
            System.err.println("You must have GSDL3HOME and GSDLOS set for GS2Perl building to work!!");
            return false;
        }
        if (this.path == null) {
            System.err.println("You must have the PATH set for GS2Perl building to work!!");
            return false;
        }
        return true;
    }

    public void run() {
        if (this.process_type == -1) {
            String msg = "Error: you must set the action type";
            ConstructionEvent evt = new ConstructionEvent(this, 3, msg);
            this.sendMessage(evt);
            return;
        }
        if (this.site_home == null) {
            String msg = "Error: you must set site_home";
            ConstructionEvent evt = new ConstructionEvent(this, 3, msg);
            this.sendMessage(evt);
            return;
        }
        if (this.process_type != 0 && this.collection_name == null) {
            String msg = "Error: you must set collection_name";
            ConstructionEvent evt = new ConstructionEvent(this, 3, msg);
            this.sendMessage(evt);
            return;
        }
        switch (this.process_type) {
            case 0: {
                this.newCollection();
                break;
            }
            case 1: {
                this.importCollection();
                break;
            }
            case 2: {
                this.buildCollection();
                break;
            }
            case 3: {
                this.activateCollection();
                break;
            }
            default: {
                String msg = "wrong type of action specified!";
                ConstructionEvent evt = new ConstructionEvent(this, 3, msg);
                this.sendMessage(evt);
            }
        }
    }

    protected void newCollection() {
        this.sendMessage(new ConstructionEvent(this, 20, "Collection construction: new collection."));
        Vector<String> command = new Vector<String>();
        command.add("gs2_mkcol.pl");
        command.add("-site");
        command.add(this.site_home);
        command.add("-collectdir");
        command.add(GSFile.collectDir(this.site_home));
        command.addAll(this.extractParameters(this.process_params));
        command.add(this.collection_name);
        String[] command_str = new String[]{};
        command_str = command.toArray(command_str);
        if (this.runPerlCommand(command_str)) {
            this.sendProcessComplete(new ConstructionEvent(this, 11, ""));
        }
    }

    protected void importCollection() {
        this.sendMessage(new ConstructionEvent(this, 20, "Collection construction: import collection."));
        Vector<String> command = new Vector<String>();
        command.add("import.pl");
        command.add("-collectdir");
        command.add(GSFile.collectDir(this.site_home));
        command.addAll(this.extractParameters(this.process_params));
        command.add(this.collection_name);
        String[] command_str = new String[]{};
        command_str = command.toArray(command_str);
        if (this.runPerlCommand(command_str)) {
            this.sendProcessComplete(new ConstructionEvent(this, 11, ""));
        }
    }

    protected void buildCollection() {
        this.sendMessage(new ConstructionEvent(this, 20, "Collection construction: build collection."));
        Vector<String> command = new Vector<String>();
        command.add("buildcol.pl");
        command.add("-collectdir");
        command.add(GSFile.collectDir(this.site_home));
        command.addAll(this.extractParameters(this.process_params));
        command.add(this.collection_name);
        String[] command_str = new String[]{};
        command_str = command.toArray(command_str);
        if (this.runPerlCommand(command_str)) {
            this.sendProcessComplete(new ConstructionEvent(this, 11, ""));
        }
    }

    protected void activateCollection() {
        this.sendMessage(new ConstructionEvent(this, 20, "Collection construction: activate collection."));
        File build_dir = new File(GSFile.collectionBuildDir(this.site_home, this.collection_name));
        if (!build_dir.exists()) {
            this.sendMessage(new ConstructionEvent(this, 3, "build dir doesn't exist!"));
            return;
        }
        File index_dir = new File(GSFile.collectionIndexDir(this.site_home, this.collection_name));
        if (index_dir.exists()) {
            this.sendMessage(new ConstructionEvent(this, 20, "deleting index directory"));
            index_dir.delete();
            if (index_dir.exists()) {
                this.sendMessage(new ConstructionEvent(this, 20, "index directory still exists!"));
            }
        }
        GSFile.moveDirectory(build_dir, index_dir);
        if (!index_dir.exists()) {
            this.sendMessage(new ConstructionEvent(this, 3, "index dir wasn't created!"));
        }
        Vector<String> command = new Vector<String>();
        command.add("convert_coll_from_gs2.pl");
        command.add("-collectdir");
        command.add(GSFile.collectDir(this.site_home));
        command.addAll(this.extractParameters(this.process_params));
        command.add(this.collection_name);
        String[] command_str = new String[]{};
        command_str = command.toArray(command_str);
        if (!this.runPerlCommand(command_str)) {
            return;
        }
        this.sendProcessComplete(new ConstructionEvent(this, 11, ""));
    }

    protected Vector extractParameters(Element param_list) {
        Vector<String> args = new Vector<String>();
        if (param_list == null) {
            return args;
        }
        NodeList params = param_list.getElementsByTagName("param");
        for (int i = 0; i < params.getLength(); ++i) {
            Element p = (Element)params.item(i);
            String name = p.getAttribute("name");
            String value = p.getAttribute("value");
            if (name.equals("")) continue;
            args.add("-" + name);
            if (value.equals("")) continue;
            args.add(value);
        }
        return args;
    }

    protected boolean runPerlCommand(String[] command) {
        String[] args = new String[]{"GSDLHOME=" + this.gsdl2home, "GSDL3HOME=" + this.gsdl3home, "GSDLOS=" + this.gsdlos, "PATH=" + this.path};
        String command_str = "";
        for (int i = 0; i < command.length; ++i) {
            command_str = command_str + command[i] + " ";
        }
        this.sendMessage(new ConstructionEvent(this, 20, "command = " + command_str));
        try {
            Runtime rt = Runtime.getRuntime();
            this.sendProcessBegun(new ConstructionEvent(this, 2, "starting"));
            Process prcs = rt.exec(command, args);
            InputStreamReader eisr = new InputStreamReader(prcs.getErrorStream());
            InputStreamReader stdinisr = new InputStreamReader(prcs.getInputStream());
            BufferedReader ebr = new BufferedReader(eisr);
            BufferedReader stdinbr = new BufferedReader(stdinisr);
            String eline = null;
            String stdinline = null;
            while (!((eline = ebr.readLine()) == null && (stdinline = stdinbr.readLine()) == null || this.cancel)) {
                if (eline != null) {
                    this.sendProcessStatus(new ConstructionEvent(this, 10, eline));
                }
                if (stdinline == null) continue;
                this.sendProcessStatus(new ConstructionEvent(this, 10, stdinline));
            }
            if (!this.cancel) {
                prcs.waitFor();
                if (prcs.exitValue() != 0) {
                    this.sendProcessStatus(new ConstructionEvent(this, 3, "Failure"));
                    return false;
                }
            } else {
                this.sendProcessStatus(new ConstructionEvent(this, 12, "killing the process"));
                prcs.getOutputStream().close();
                prcs.destroy();
                return false;
            }
            this.sendProcessStatus(new ConstructionEvent(this, 10, "Success"));
        }
        catch (Exception e) {
            this.sendProcessStatus(new ConstructionEvent(this, 3, "Exception occurred " + e.toString()));
        }
        return true;
    }
}

