/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.lib.config;

import de.qfs.lib.config.Configurable;
import de.qfs.lib.config.ConfigurationEvent;
import de.qfs.lib.config.ConfigurationListener;
import de.qfs.lib.log.Logger;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;

public class Configuration {
    private static Logger logger = new Logger(class$de$qfs$lib$config$Configuration == null ? (class$de$qfs$lib$config$Configuration = Configuration.class$("de.qfs.lib.config.Configuration")) : class$de$qfs$lib$config$Configuration);
    private static Configuration theInstance = new Configuration();
    private static final String LINESEP = System.getProperty("line.separator");
    protected Hashtable configurables = new Hashtable();
    protected Hashtable nameMap = new Hashtable();
    protected Hashtable states = new Hashtable();
    protected Vector names = new Vector();
    private String comment;
    private Hashtable comments = new Hashtable();
    private Vector listeners = new Vector();
    private Vector silenced = new Vector();
    static /* synthetic */ Class class$de$qfs$lib$config$Configuration;

    protected Configuration() {
    }

    public static Configuration instance() {
        return theInstance;
    }

    public void register(Configurable configurable) {
        if (Configuration.logger.level >= 7) {
            logger.log(7, "register(Configurable)", Configuration.logger.level < 8 ? "" : "configurable: " + configurable);
        }
        this.registerAs(configurable, configurable.getConfigurableName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerAs(Configurable configurable, String string) {
        Properties properties;
        if (Configuration.logger.level >= 7) {
            logger.log(7, "registerAs(Configurable,String)", Configuration.logger.level < 8 ? "" : "configurable: " + configurable + ", " + "name: " + string);
        }
        boolean bl = false;
        Configuration configuration = this;
        synchronized (configuration) {
            Object object;
            Object v = this.configurables.get(string);
            if (v != null) {
                if (v instanceof Vector) {
                    object = v;
                    properties = ((Configurable)((Vector)v).elementAt(0)).getConfigurableState();
                } else {
                    object = new Vector();
                    ((Vector)object).insertElementAt(v, 0);
                    properties = ((Configurable)v).getConfigurableState();
                }
                ((Vector)object).insertElementAt(configurable, 0);
                bl = true;
            } else {
                object = configurable;
                properties = (Properties)this.states.get(string);
                if (properties == null) {
                    properties = configurable.getConfigurableState();
                    this.states.put(string, properties);
                } else {
                    bl = true;
                }
            }
            this.configurables.put(string, object);
            this.nameMap.put(configurable, string);
            if (!this.names.contains(string)) {
                this.names.addElement(string);
            }
            configurable.registrationChanged(this, string, true, false);
        }
        if (properties != null && bl) {
            try {
                this.silenced.addElement(Thread.currentThread());
                configurable.setConfigurableState(properties);
                Object var10_9 = null;
                this.silenced.removeElement(Thread.currentThread());
            }
            catch (Throwable throwable) {
                Object var10_10 = null;
                this.silenced.removeElement(Thread.currentThread());
                throw throwable;
            }
            {
            }
        }
    }

    public void unregister(Configurable configurable, boolean bl) {
        if (Configuration.logger.level >= 7) {
            logger.log(7, "unregister(Configurable,boolean)", Configuration.logger.level < 8 ? "" : "configurable: " + configurable + ", " + "keepValues: " + bl);
        }
        this.unregisterAs(configurable, configurable.getConfigurableName(), bl);
    }

    public synchronized void unregisterAs(Configurable configurable, String string, boolean bl) {
        Object v;
        if (Configuration.logger.level >= 7) {
            logger.log(7, "unregisterAs(Configurable,String,boolean)", Configuration.logger.level < 8 ? "" : "configurable: " + configurable + ", " + "name: " + string + ", " + "keepValues: " + bl);
        }
        if ((v = this.configurables.get(string)) == null) {
            if (Configuration.logger.level >= 1) {
                logger.log(1, "unregisterAs(Configurable,String,boolean)", "Trying to unregister unknown Configurable " + string);
            }
        } else if (v instanceof Vector) {
            ((Vector)v).removeElement(configurable);
            if (((Vector)v).size() == 0) {
                if (bl) {
                    Properties properties = configurable.getConfigurableState();
                    if (Configuration.logger.level >= 9) {
                        logger.log(9, "unregisterAs(Configurable,String,boolean)", "Keeping state: " + properties);
                    }
                    this.states.put(string, properties);
                } else {
                    this.names.removeElement(string);
                }
                this.configurables.remove(string);
            }
        } else if (v != configurable) {
            if (Configuration.logger.level >= 1) {
                logger.log(1, "unregisterAs(Configurable,String,boolean)", "Trying to unregister different Configurable under name " + string);
            }
        } else {
            if (bl) {
                Properties properties = configurable.getConfigurableState();
                if (Configuration.logger.level >= 9) {
                    logger.log(9, "unregisterAs(Configurable,String,boolean)", "Keeping state: " + properties);
                }
                this.states.put(string, properties);
            } else {
                this.names.removeElement(string);
            }
            this.configurables.remove(string);
        }
        this.nameMap.remove(configurable);
        configurable.registrationChanged(this, string, false, bl);
    }

    public void unregisterAll(String string, boolean bl) {
        Object object;
        if (Configuration.logger.level >= 7) {
            logger.log(7, "unregisterAll(String,boolean)", Configuration.logger.level < 8 ? "" : "name: " + string + ", " + "keepValues: " + bl);
        }
        if ((object = this.configurables.get(string)) == null) {
            return;
        }
        if (object instanceof Vector) {
            int n = 0;
            while (n < ((Vector)object).size()) {
                Configurable configurable = (Configurable)((Vector)object).elementAt(n);
                this.nameMap.remove(configurable);
                configurable.registrationChanged(this, string, false, bl);
                ++n;
            }
            object = ((Vector)object).elementAt(((Vector)object).size() - 1);
        } else {
            this.nameMap.remove(object);
            ((Configurable)object).registrationChanged(this, string, false, bl);
        }
        this.configurables.remove(string);
        if (bl) {
            Properties properties = ((Configurable)object).getConfigurableState();
            if (Configuration.logger.level >= 9) {
                logger.log(9, "unregisterAll(String,boolean)", "Keeping state: " + properties);
            }
            this.states.put(string, properties);
        }
    }

    public String getRegistrationName(Configurable configurable) {
        return (String)this.nameMap.get(configurable);
    }

    public void save(OutputStream outputStream) {
        if (Configuration.logger.level >= 7) {
            logger.log(7, "save(OutputStream)", Configuration.logger.level < 8 ? "" : "out: " + outputStream);
        }
        PrintWriter printWriter = new PrintWriter(new OutputStreamWriter(outputStream));
        if (this.comment != null) {
            this.printComment(printWriter, this.comment);
        }
        int n = 0;
        while (n < this.names.size()) {
            String string = (String)this.names.elementAt(n);
            Object v = this.configurables.get(string);
            Properties properties = null;
            properties = v instanceof Vector ? ((Configurable)((Vector)v).elementAt(0)).getConfigurableState() : (v instanceof Configurable ? ((Configurable)v).getConfigurableState() : (Properties)this.states.get(string));
            if (properties == null) {
                logger.log(3, "save(OutputStream)", "No state for " + string);
            } else {
                if (n > 0) {
                    printWriter.println();
                }
                printWriter.print("[");
                printWriter.print(string);
                printWriter.println("]");
                String string2 = (String)this.comments.get(string);
                if (string2 != null) {
                    this.printComment(printWriter, string2);
                }
                printWriter.print(this.writeProps(properties));
                printWriter.flush();
            }
            ++n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void restore(InputStream inputStream) throws IOException {
        if (Configuration.logger.level >= 7) {
            logger.log(7, "restore(InputStream)", Configuration.logger.level < 8 ? "" : "in: " + inputStream);
        }
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        StringBuffer stringBuffer = new StringBuffer();
        String string = this.fetchLine(bufferedReader);
        string = this.fetchComment(string, bufferedReader, stringBuffer);
        this.comment = stringBuffer.toString();
        try {
            this.silenced.addElement(Thread.currentThread());
            while (string != null) {
                if (string.startsWith("[") && string.endsWith("]")) {
                    String string2 = string.substring(1, string.length() - 1);
                    stringBuffer = new StringBuffer();
                    string = this.fetchComment(this.fetchLine(bufferedReader), bufferedReader, stringBuffer);
                    String string3 = stringBuffer.toString();
                    if (string3.length() > 0) {
                        this.comments.put(string2, string3);
                    }
                    stringBuffer = new StringBuffer();
                    string = this.fetchContent(string, bufferedReader, stringBuffer);
                    Properties properties = this.readProps(stringBuffer.toString());
                    Object v = this.configurables.get(string2);
                    if (properties != null) {
                        this.states.put(string2, properties);
                    }
                    if (v instanceof Vector) {
                        int n = 0;
                        while (n < ((Vector)v).size()) {
                            ((Configurable)((Vector)v).elementAt(n)).setConfigurableState(properties);
                            ++n;
                        }
                    } else if (v != null) {
                        ((Configurable)v).setConfigurableState(properties);
                    }
                    if (this.names.contains(string2)) continue;
                    this.names.addElement(string2);
                    continue;
                }
                throw new IOException("Malformed Configuration InputStream");
            }
            Object var11_10 = null;
            this.silenced.removeElement(Thread.currentThread());
        }
        catch (Throwable throwable) {
            Object var11_11 = null;
            this.silenced.removeElement(Thread.currentThread());
            throw throwable;
        }
    }

    public void setComment(String string) {
        if (Configuration.logger.level >= 7) {
            logger.log(7, "setComment(String)", Configuration.logger.level < 8 ? "" : "comment: " + string);
        }
        this.comment = string;
    }

    public void setComment(String string, String string2) {
        if (Configuration.logger.level >= 7) {
            logger.log(7, "setComment(String,String)", Configuration.logger.level < 8 ? "" : "name: " + string + ", " + "comment: " + string2);
        }
        this.comments.put(string, string2);
    }

    public String getComment() {
        if (Configuration.logger.level >= 7) {
            logger.log(7, "getComment()", "");
        }
        return this.comment;
    }

    public String getComment(String string) {
        if (Configuration.logger.level >= 7) {
            logger.log(7, "setComment(String,String)", Configuration.logger.level < 8 ? "" : "name: " + string + ", " + "comment: " + this.comment);
        }
        return (String)this.comments.get(string);
    }

    public void addConfigurationListener(ConfigurationListener configurationListener) {
        if (Configuration.logger.level >= 7) {
            logger.log(7, "addConfigurationListener(ConfigurationListener)", Configuration.logger.level < 8 ? "" : "listener: " + configurationListener);
        }
        this.listeners.addElement(configurationListener);
    }

    public void removeConfigurationListener(ConfigurationListener configurationListener) {
        if (Configuration.logger.level >= 7) {
            logger.log(7, "removeConfigurationListener(ConfigurationListener)", Configuration.logger.level < 8 ? "" : "listener: " + configurationListener);
        }
        this.listeners.removeElement(configurationListener);
    }

    public void stateChanged(Configurable configurable) {
        Object object;
        if (Configuration.logger.level >= 7) {
            logger.log(7, "stateChanged(Configurable)", Configuration.logger.level < 8 ? "" : "configurable: " + configurable);
        }
        if (this.silenced.contains(Thread.currentThread())) {
            return;
        }
        String string = (String)this.nameMap.get(configurable);
        if (string == null) {
            logger.log(3, "stateChanged(Configurable)", "unregistered Configurable: " + configurable);
            return;
        }
        Properties properties = configurable.getConfigurableState();
        Properties properties2 = (Properties)this.states.get(string);
        this.states.put(string, properties);
        if (this.listeners.size() == 0) {
            return;
        }
        if (properties2 != null) {
            boolean bl;
            boolean bl2 = bl = properties.size() == properties2.size();
            if (bl) {
                object = properties2.keys();
                while (object.hasMoreElements()) {
                    String string2 = (String)object.nextElement();
                    if (properties2.get(string2).equals(properties.get(string2))) continue;
                    bl = false;
                    break;
                }
            }
            if (bl) {
                return;
            }
        }
        ConfigurationEvent configurationEvent = new ConfigurationEvent(configurable, string, properties);
        object = (Vector)this.listeners.clone();
        int n = 0;
        while (n < ((Vector)object).size()) {
            ((ConfigurationListener)((Vector)object).elementAt(n)).stateChanged(configurationEvent);
            ++n;
        }
    }

    private String writeProps(Properties properties) {
        if (Configuration.logger.level >= 7) {
            logger.log(7, "writeProps(Properties)", "");
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            properties.store(byteArrayOutputStream, "");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        String string = byteArrayOutputStream.toString();
        while (string.length() > 0 && string.charAt(0) == '#' && string.indexOf(LINESEP) > 0) {
            string = string.substring(string.indexOf(LINESEP) + LINESEP.length());
        }
        return string;
    }

    private Properties readProps(String string) {
        if (Configuration.logger.level >= 7) {
            logger.log(7, "readProps(String)", Configuration.logger.level < 8 ? "" : "input: " + string);
        }
        Properties properties = new Properties();
        try {
            properties.load(new ByteArrayInputStream(string.getBytes()));
        }
        catch (IOException iOException) {
            logger.log("fetch(String)", iOException);
        }
        return properties;
    }

    private void printComment(PrintWriter printWriter, String string) {
        if (Configuration.logger.level >= 7) {
            logger.log(7, "printComment(PrintStream,String)", Configuration.logger.level < 8 ? "" : "comment: " + string);
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, LINESEP, true);
        boolean bl = false;
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            char c = string2.charAt(0);
            if (c == '\n' || c == '\r') {
                bl = false;
            } else {
                bl = true;
                if (!this.isComment(string2)) {
                    printWriter.print("# ");
                }
            }
            printWriter.print(string2);
        }
        if (bl) {
            printWriter.println();
        }
    }

    private boolean isComment(String string) {
        if (Configuration.logger.level >= 7) {
            logger.log(7, "isComment(String)", Configuration.logger.level < 8 ? "" : "line: " + string);
        }
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            if (c == '#') {
                return true;
            }
            if (!Character.isWhitespace(c)) {
                return false;
            }
            ++n;
        }
        return true;
    }

    private String fetchLine(BufferedReader bufferedReader) {
        try {
            String string = bufferedReader.readLine();
            return string;
        }
        catch (IOException iOException) {
            logger.log("fetchComment(String,BufferedReader,StringBuffer)", iOException);
            return null;
        }
    }

    private String fetchComment(String string, BufferedReader bufferedReader, StringBuffer stringBuffer) {
        if (Configuration.logger.level >= 7) {
            logger.log(7, "fetchComment(String,BufferedReader,StringBuffer)", "");
        }
        while (string != null) {
            if (!this.isComment(string)) break;
            stringBuffer.append(string);
            stringBuffer.append(LINESEP);
            string = this.fetchLine(bufferedReader);
        }
        return string;
    }

    private String fetchContent(String string, BufferedReader bufferedReader, StringBuffer stringBuffer) {
        if (Configuration.logger.level >= 7) {
            logger.log(7, "fetchContent(String,BufferedReader,StringBuffer)", "");
        }
        while (string != null) {
            if (string.startsWith("[")) break;
            if (!this.isComment(string)) {
                stringBuffer.append(string);
                stringBuffer.append(LINESEP);
            }
            string = this.fetchLine(bufferedReader);
        }
        return string;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

