/**********************************************************************
 *
 * z3950_to_gsdl.h --
 * Copyright (C) 2000  The New Zealand Digital Library Project
 *
 * A component of the Greenstone digital library software
 * from the New Zealand Digital Library Project at the
 * University of Waikato, New Zealand.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *********************************************************************/

#ifndef Z3950_TO_GSDL_H
#define Z3950_TO_GSDL_H


void toUpperString(char *&text);

class gsdlCollection
{
 public:
  gsdlCollection(); 
  gsdlCollection(text_t collectionName, text_t gsdlhome);
  ~gsdlCollection(void);

  bool z3950Capeable() const;

  // converts a Bib1 field number to a short index name,
  // returns true if a mapping existed, false otherwise
  bool getFieldArg(int Bib1, text_t &Short);

  text_t getName(); // returns the name of the collection in short form
  
 protected:


  bool bib1_to_dc_mapping(text_t& filename);
  bool dc_to_short_mapping(text_t& filename, text_t& collectionName);

 protected:
  text_t name;
  map<int, text_t>    Bib1_to_DCES;  // Bib-1 to DC metadata names
  map<text_t, text_t> DCES_to_Short; // DC to short (2-3 letter) internal name

  bool z3950ready; // is the collection Z39.50-ready ?
                   // (i.e. does it have the cfg files for mappings)


};

class z3950Server 
{
protected:
  text_tarray collections;
  nullproto *protocol;
  text_t      gsdlhome;

  // save particular YAZ variables ...

  void openLogfile(text_t extension, ofstream &out);


public:
  z3950Server(nullproto *protocol, text_t home);
  
  bool initialise();

  void configure(const text_t &key, const text_tarray &cfgline, comerror_t &err);

  int run_z3950( int argc, char **argv );

};

#endif
