/**********************************************************************
 *
 * queryaction.h -- 
 * Copyright (C) 1999  The New Zealand Digital Library Project
 *
 * A component of the Greenstone digital library software
 * from the New Zealand Digital Library Project at the
 * University of Waikato, New Zealand.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *********************************************************************/


#ifndef QUERYACTION_H
#define QUERYACTION_H

#include "gsdlconf.h"
#include "basequeryaction.h"
#include "userdb.h"
#include "receptionist.h"


class queryaction : public basequeryaction {

protected:
  text_t m_strUseInterfaceLanguageForQuery;
  text_t formatstring;
  text_tmap reqfields; // required fields
  int num_phrases;

  userdbclass *user_database; // for checking user groups in ccs
  virtual text_t query_filter_name () {return "QueryFilter";}

  virtual void define_query_macros (cgiargsclass &args, displayclass &disp, 
				    int numDocs, isapprox isApprox); 

  virtual void get_formatted_query_string (text_t &formattedstring, 
					   bool segment, 
					   cgiargsclass &args, 
					   displayclass &disp, 
					   ostream &logout);

  void define_query_interface(displayclass &disp, cgiargsclass &args, 
			      recptprotolistclass *protos, ostream &logout);
  
  virtual void define_form_macros (displayclass &disp, cgiargsclass &args, 
				   recptprotolistclass *protos, 
				   ostream &logout);

  void set_gformselection_macro (text_t current_value,
				 const FilterOption_t &option,
				 displayclass &disp);
  void set_sfselection_macro (text_t current_value, 
			      const FilterOption_t &option, 
			      displayclass &disp);

  void output_ccp (cgiargsclass &args, recptprotolistclass *protos,
		   displayclass &disp, outconvertclass &outconvert,
		   ostream &textout, ostream &logout);

  virtual void set_queryfilter_options (FilterRequest_t &request, 
					const text_t &querystring,
					cgiargsclass &args);

  virtual void set_queryfilter_options (FilterRequest_t &request, 
					const text_t &querystring1,
					const text_t &querystring2, 
					cgiargsclass &args);


  
  bool search_multiple_collections (cgiargsclass &args, 
				    recptprotolistclass *protos,
				    browsermapclass *browsers, 
				    displayclass &disp,
				    outconvertclass &outconvert, 
				    ostream &textout,
				    ostream &logout);
  
  virtual bool save_search_history(cgiargsclass &args, int numdocs, 
				   isapprox isApprox);
  bool user_groups_match(const text_t &collection_groups, const text_t &user_groups);
  void validate_ccs_collection_list(cgiargsclass &args, recptprotolistclass *protos, ostream &logout);
public:
  queryaction ();
  virtual ~queryaction ();

  void configure (const text_t &key, const text_tarray &cfgline);
  bool init (ostream &logout);
  
  void set_userdb(userdbclass *udb) {user_database = udb;}
  virtual text_t get_action_name () {return "q";}
  
  virtual bool check_cgiargs (cgiargsinfoclass &argsinfo, cgiargsclass &args, 
			      recptprotolistclass *protos, ostream &logout);
  virtual void define_internal_macros (displayclass &disp, cgiargsclass &args, 
			       recptprotolistclass *protos, ostream &logout);

  virtual void define_external_macros (displayclass &disp, cgiargsclass &args, 
			       recptprotolistclass *protos, ostream &logout);
  
  virtual bool do_action (cgiargsclass &args, recptprotolistclass *protos, 
		  browsermapclass *browsers, displayclass &disp, 
		  outconvertclass &outconvert, ostream &textout, 
		  ostream &logout);

};

#endif
