/**********************************************************************
 *
 * extlinkaction.h -- 
 * Copyright (C) 1999  The New Zealand Digital Library Project
 *
 * A component of the Greenstone digital library software
 * from the New Zealand Digital Library Project at the
 * University of Waikato, New Zealand.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *********************************************************************/

#include "gsdl_modules_cfg.h"
#ifdef GSDL_USE_EXTLINK_ACTION

#ifndef EXTLINKACTION_H
#define EXTLINKACTION_H

#include "action.h"
#include "receptionist.h"

class extlinkaction : public action {


public:
  extlinkaction ();
  virtual ~extlinkaction ();

  void set_receptionist (receptionist *therecpt) {recpt=therecpt;}

  text_t get_action_name () {return "extlink";}
  void get_cgihead_info (cgiargsclass &args, recptprotolistclass *protos,
			 response_t &response, text_t &response_data, 
			 ostream &logout);

  void define_internal_macros (displayclass &disp, cgiargsclass &args, 
			       recptprotolistclass *protos, 
			       ostream &logout);

  bool do_action (cgiargsclass &args, recptprotolistclass *protos, 
		  browsermapclass *browsers, displayclass &disp,
		  outconvertclass &outconvert, ostream &textout,
		  ostream &logout);


protected:
  
  receptionist *recpt;
  
  bool get_link (cgiargsclass &args, recptprotolistclass *protos,
		 text_t &link, ostream &logout);

};

#endif //!EXTLINKACTION_H
#endif //GSDL_USE_EXTLINK_ACTION
