/**********************************************************************
 *
 * recordaction.h --
 *
 * Copyright (C) 2004-2010  The New Zealand Digital Library Project
 *
 * A component of the Greenstone digital library software
 * from the New Zealand Digital Library Project at the
 * University of Waikato, New Zealand.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *********************************************************************/

#ifndef _RECORDACTION_H_
#define _RECORDACTION_H_
#include "oaiaction.h"

#include <map>

#include "comtypes.h"

#include "metaformat.h"

class recordaction : public oaiaction
{
 private:
  metaformat_map formatMap;
  FilterResponse_t gsdlResponse;
  
 public:
  recordaction(text_tset &metadataset);
  ~recordaction();
  
  virtual bool validateAction(recptproto *protocol, oaiargs &params);
  bool output_content(ostream &output, recptproto *protocol, oaiargs &params);
  bool output_record(ostream &output, const text_t &collection, const text_t &OID, 
		     const text_t &metadataPrefix);
  bool output_record(ostream &output, recptproto *protocol, const text_t &collection, const text_t &OID, 
		     const text_t &metadataPrefix);
  metaformat_map *get_formats() { return &this->formatMap; }
};
#endif
