/**********************************************************************
 *
 * abstractlistaction.h --
 *
 * Copyright (C) 2004-2010  The New Zealand Digital Library Project
 *
 * A component of the Greenstone digital library software
 * from the New Zealand Digital Library Project at the
 * University of Waikato, New Zealand.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *********************************************************************/

#ifndef _ABSTRACTLISTACTION_H_
#define _ABSTRACTLISTACTION_H_

#include "oaiaction.h"
#include "resumptiontoken.h"

class abstractlistaction : public oaiaction
{ 
 public:
  abstractlistaction(const text_t &name) : oaiaction(name) { }

  virtual bool output_document(ostream &output, recptproto *protocol, const text_t &collection, 
			       const text_t &OID, const text_t &metadataPrefix) = 0;

  virtual bool output_content(ostream &output, recptproto *protocol, oaiargs &params);

  virtual bool output_content_for_set(ostream &output, recptproto *protocol, oaiargs &params, text_t collection_name, text_t gsdl_classifier_OID, text_t set_name);


 protected:
  int output_docs;

  bool check_classifier(recptproto *protocol, const text_t &collection, const text_t &set_name);

  bool in_date_range(ostream &output, recptproto *protocol, oaiargs &params,
		     text_t& collection, text_t oai_OID, text_t from, text_t until);
};

#endif
