/**********************************************************************
 *
 * search.h -- abstract search class for mg systems
 * Copyright (C) 1999  The New Zealand Digital Library Project
 *
 * A component of the Greenstone digital library software
 * from the New Zealand Digital Library Project at the
 * University of Waikato, New Zealand.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *********************************************************************/


#ifndef SEARCH_H
#define SEARCH_H

#include "text_t.h"
#include "querycache.h"

#define RESULTCACHESIZE 10
#define MAXNUMDOCS      1000000
#define MAXNUMTERMS     100

class searchclass {
public:
  searchclass ();
  virtual ~searchclass ();

  // in subclass, should be over-rided to return "mg" or "mgpp"
  virtual text_t get_textindex_type()=0;
  // the index directory must be set before any searching
  // is done
  virtual void setcollectdir (const text_t &thecollectdir);
  
  // the search results are returned in queryresults
  // search returns 'true' if it was able to do a search
   virtual bool search(const queryparamclass &queryparams, 
	      queryresultsclass &queryresults)=0;
  
  // the document text for 'docnum' is placed in 'output'
  // docTargetDocument returns 'true' if it was able to
  // try to get a document
  // collection is needed to see if an index from the 
  // collection is loaded. If no index has been loaded
  // defaultindex is needed to load one
  virtual bool docTargetDocument(const text_t &defaultindex,
			 const text_t &defaultsubcollection,
			 const text_t &defaultlanguage,
			 const text_t &collection,
			 int docnum,
			 text_t &output)=0;

  // unload_database clears any cached databases - 
  // this is useful when attempting to
  // completely remove all trace of a collectionserver at runtime (when
  // using a persistent version of Greenstone like the windows local
  // library)
  virtual void unload_database ()=0;

protected:
  querycache *cache;
  text_t collectdir; // the collection directory

};


#endif
