/**********************************************************************
 *
 * mgq.h -- 
 * Copyright (C) 1999  The New Zealand Digital Library Project
 *
 * A component of the Greenstone digital library software
 * from the New Zealand Digital Library Project at the
 * University of Waikato, New Zealand.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *********************************************************************/


#ifndef MGQ_H
#define MGQ_H

#ifdef __cplusplus
extern "C" {
#endif

  
enum result_kinds {
  result_docs,      /* Return the documents found in last search */
  result_docnums,   /* Return document id numbers and weights */
  result_termfreqs, /* Return terms and frequencies */
  result_terms      /* Return matching query terms */
};

int mgq_ask(char *line);
int mgq_results(enum result_kinds kind, int skip, int howmany,
		int (*sender)(char *, int, int, float, void *), void *ptr);
int mgq_numdocs(void);
int mgq_numterms(void);

/* get all the terms that match wordstem using the current stemmer and */
/* stemming method. The callback is the same style used by mgq_results */
int mgq_equivterms (unsigned char *wordstem, int (*sender)(char *, int, int, float, void *),
		    void *ptr);

/* gets the total number of documents retrieved. If this is not available */
/* it will set total_retrieved to 0 (even when it obviously isn't) */
int mgq_docsretrieved (int *total_retrieved, int *is_approx);
  
/* use mgq_getmaxstemlen to determine the length of the word stems to pass */
/* to mgq_stemword */
int mgq_getmaxstemlen ();

/* note: the stemming method and the stemmer come from the last query */
/* "word" should be at least maxstemlen+1 long and it is a string that */
/* starts with the string length */
void mgq_stemword (unsigned char *word);

  
int is_dbcache_full (void);
int load_database (char *collection, char *mgdir, char *gensuffix, char *textsuffix);
int load_text_database (char *collection);
void close_all_databases (void);


#ifdef __cplusplus
}
#endif


#endif
