##########################################################################
#
# CSVFieldSeparator -- helper plugin that 'auto' works out what the 
#                      comma-separated field character is
#
# A component of the Greenstone digital library software
# from the New Zealand Digital Library Project at the 
# University of Waikato, New Zealand.
#
# Copyright (C) 2019 New Zealand Digital Library Project
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#
###########################################################################

package CSVFieldSeparator;

use PrintInfo;

use strict;
no strict 'refs'; # make an exception so we can use variables as filehandles

BEGIN {
    @CSVFieldSeparator::ISA = ('PrintInfo');
}

my $arguments = 
    [ 
      { 'name' => "csv_field_separator",
	'desc' => "{CSVFieldSeparator.csv_field_separator}",
	'type' => "string",
	'deft' => "auto",
	'reqd' => "no" },
      { 'name' => "metadata_value_separator",
	'desc' => "{CSVFieldSeparator.metadata_value_separator}",
	'type' => "string",
	'deft' => "",
	    'reqd' => "no" },
      { 'name' => "metadata_separate_fields",
	'desc' => "{CSVFieldSeparator.metadata_separate_fields}",
	'type' => "string",
	'deft' => "",
	'reqd' => "no" }
    ];

my $options = { 'name' => "CSVFieldSeparator",
		'desc' => "{CSVFieldSeparator.desc}",
		'abstract' => "yes",
		'inherits' => "yes",
		'args' => $arguments };

sub new {
    my ($class) = shift (@_);
    my ($pluginlist,$inputargs,$hashArgOptLists) = @_;
    push(@$pluginlist, $class);

    push(@{$hashArgOptLists->{"ArgList"}},@{$arguments});
    push(@{$hashArgOptLists->{"OptList"}},$options);

    my $self = new PrintInfo($pluginlist, $inputargs, $hashArgOptLists, 1);
  
    return bless $self, $class;

}


sub resolve_auto
{
    my ($self) = shift @_;
    my ($line,$plugin_name) = @_;
 
    my $outhandle = $self->{'outhandle'};
    my $verbosity = $self->{'verbosity'};

    # count number of char matches for common separates such as ',' ';' '\t' and '|'
    my $comma_count = () = ($line =~ m/,/g);
    my $separate_char = ",";
    my $max_count = $comma_count; 
    
    my $semicolon_count = () = ($line =~ m/\;/g);
    if ($semicolon_count > $max_count) {
	$separate_char = ";";
	$max_count = $semicolon_count;
    }

    my $tab_count       = () = ($line =~ m/\t/g);
    if ($tab_count > $max_count) {
	$separate_char = "\t";
	$max_count = $tab_count;
    }

    my $pipe_count      = () = ($line =~ m/\|/g);
    if ($pipe_count > $max_count) {
	$separate_char = "|";
	$max_count = $pipe_count;
    }
    
    if ($outhandle) {
	print $outhandle "$plugin_name: Auto selecting '$separate_char' as -separate_char\n" if ($verbosity) > 1;
    }

    return $separate_char;
}

1;
