###########################################################################
#
# win32 makefile -- lib
# A component of the Greenstone digital library software
# from the New Zealand Digital Library Project at the
# University of Waikato, New Zealand.
#
# Copyright (C) 1999-2008  The New Zealand Digital Library Project
#
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#
###########################################################################

COMMON_DIR = ..\..

INDEXERS_DIR = $(COMMON_DIR)\indexers
COMMON_PACKAGES_DIR = $(COMMON_DIR)\packages


GSDL_VC4 = 0
LOCAL_LIBRARY = 0
DEBUG = 0
DLL = 0
DLLDEBUG = 0
USE_GDBM = 1
USE_JDBM = 1
USE_SQLITE = 1
USE_MSSQL = 0

!IF $(DEBUG)
CXXFLAGS = -DEBUG -Z7 /errorReport:prompt
!ELSE
CXXFLAGS =
!ENDIF


!IF $(GSDL_VC4)
CXXFLAGS = $(CXXFLAGS) -GX
!ELSE
CXXFLAGS = $(CXXFLAGS) -EHsc
!ENDIF

!IF $(DLL)
CXXFLAGS = $(CXXFLAGS) -MD
!ELSE
!IF ($(DLLDEBUG))
CXXFLAGS = $(CXXFLAGS) -MDd
!ENDIF
!ENDIF

!IF $(USE_MSSQL)
MSSQL_OBJECTS = mssqldbclass.obj
MSSQL_SOURCES = mssqldbclass.cpp
MSSQL_DEFINES = -DUSE_MSSQL
!ELSE
MSSQL_OBJECTS = 
MSSQL_SOURCES =
MSSQL_DEFINES =
!ENDIF

!IF $(USE_SQLITE)
SQLITE_INCLUDES = -I"$(COMMON_PACKAGES_DIR)\sqlite\include"
SQLITE_OBJECTS = sqlitedbclass.obj
SQLITE_SOURCES = sqlitedbclass.cpp
SQLITE_DEFINES = -DUSE_SQLITE
!ELSE
SQLITE_INCLUDES = 
SQLITE_OBJECTS = 
SQLITE_SOURCES = 
SQLITE_DEFINES =
!ENDIF

!IF $(USE_GDBM)
GDBM_LIBS =
GDBM_SOURCES = gdbmclass.cpp
GDBM_OBJECTS = gdbmclass.obj
GDBM_INCLUDES = -I"$(COMMON_PACKAGES_DIR)\gdbm\gdbm-1.8.3" \
	-I"$(COMMON_PACKAGES_DIR)\gdbm\gdbm-1.8.3\windows"
GDBM_DEFINES = -DUSE_GDBM
!ELSE
GDBM_LIBS = 
GDBM_SOURCES =
GDBM_OBJECTS =
GDBM_INCLUDES = 
GDBM_DEFINES = 
!ENDIF

!IF $(USE_JDBM)
JDBM_SOURCES = jdbmnaiveclass.cpp 
JDBM_OBJECTS = jdbmnaiveclass.obj
JDBM_DEFINES = -DUSE_JDBM
!ELSE
JDBM_SOURCES =
JDBM_OBJECTS =
JDBM_DEFINES =
!ENDIF

AR = lib
CC = cl
DEFS = -D__WIN32__ -DHAVE_CONFIG_H -DPARADOCNUM -D_LITTLE_ENDIAN -DSHORT_SUFFIX -D_CRT_SECURE_NO_DEPRECATE \
	$(GDBM_DEFINES) $(JDBM_DEFINES) $(SQLITE_DEFINES) $(MSSQL_DEFINES)
INCLUDES = -I"$(COMMON_DIR)" \
	$(GDBM_INCLUDES) \
	$(SQLITE_INCLUDES)

!IF $(GSDL_VC4)
DEFS = $(DEFS) -DGSDL_NAMESPACE_BROKEN -DGSDL_USE_IOS_H -D__STL_NO_NEW_IOSTREAMS
INCLUDES = $(INCLUDES) -I"$(COMMON_PACKAGES_DIR)\windows\stlport\stlport"
!ENDIF
!IF $(LOCAL_LIBRARY)
DEFS = $(DEFS) -DGSDL_LOCAL_LIBRARY
!ENDIF


COMPILE = $(CC) -nologo -c $(CXXFLAGS) $(DEFS) $(INCLUDES)


.SUFFIXES:
.SUFFIXES: .cpp .obj
.cpp.obj:
	$(COMPILE) $< 


SOURCES = \
	cfgread.cpp \
	cnfgable.cpp \
	cnfgator.cpp \
	dbclass.cpp \
	display.cpp \
	fileutil.cpp \
	$(GDBM_SOURCES) \
	gsdlsitecfg.cpp \
	gsdltimes.cpp \
	gsdltools.cpp \
	gsdlunicode.cpp \
	infodbclass.cpp \
	$(JDBM_SOURCES) \
	OIDtools.cpp \
	phrases.cpp \
	sqldbclass.cpp \
	text_t.cpp \
	unitool.cpp \
	$(SQLITE_SOURCES) \
	$(MSSQL_SOURCES)

OBJECTS = \
	cfgread.obj \
	cnfgable.obj \
	cnfgator.obj \
	dbclass.obj \
	display.obj \
	fileutil.obj \
	$(GDBM_OBJECTS) \
	gsdlsitecfg.obj \
	gsdltimes.obj \
	gsdltools.obj \
	gsdlunicode.obj \
	infodbclass.obj \
	$(JDBM_OBJECTS) \
	OIDtools.obj \
	phrases.obj \
	sqldbclass.obj \
	text_t.obj \
	unitool.obj \
	$(SQLITE_OBJECTS) \
        $(MSSQL_OBJECTS)

LIBRARY = gsdllib.lib	


# Default target: make gsdllib.lib
all: $(LIBRARY)

gsdllib.lib : $(OBJECTS)
	if EXIST $(LIBRARY) del $(LIBRARY)
	$(AR) -nologo /out:$(LIBRARY) $(OBJECTS)

install:

clean:
	del *.obj 
	del $(LIBRARY)


# Always recompile gsdltools in case GSDL_LOCAL_LIBRARY has changed
gsdltools.obj: FORCE

FORCE:
