/**********************************************************************
 *
 * gdbmclass.h -- 
 * Copyright (C) 1999-2008  The New Zealand Digital Library Project
 *
 * A component of the Greenstone digital library software
 * from the New Zealand Digital Library Project at the
 * University of Waikato, New Zealand.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *********************************************************************/

#ifndef GDBMCLASS_H
#define GDBMCLASS_H


#include "gsdlconf.h"
#include "dbclass.h"

#ifdef _MSC_VER

#ifdef __cplusplus
  extern "C" {
#endif
#include "autoconf.h"
#include "systems.h"
#include "gdbmconst.h"
#include "gdbm.h"
#ifdef __cplusplus
  }
#endif

#else
#include <gdbm.h>
#endif


class gdbmclass : public dbclass
{
public:
  gdbmclass(const text_t& gsdlhome);
  ~gdbmclass();

  // returns true if opened
  bool opendatabase (const text_t &filename, int mode, int num_retrys, bool need_filelock);

  void closedatabase ();

  void deletekey (const text_t &key);

  // returns file extension string
  text_t getfileextension ();

  // returns true on success
  bool getkeydata (const text_t& key, text_t &data);

  // returns array of keys
  text_tarray getkeys ();

  // returns true on success
  bool setkeydata (const text_t &key, const text_t &data);

protected:
  text_t openfile;
  GDBM_FILE gdbmfile;

  // getfirstkey and getnextkey are used for traversing the database
  // no insertions or deletions should be carried out while traversing
  // the database. when there are no keys left to visit in the database
  // an empty string is returned.
  text_t getfirstkey ();
  text_t getnextkey (const text_t &key);

  void generate_from_txtgz (text_t filename);
};


#endif
