/*
 * Decompiled with CFR 0.152.
 */
package org.greenstone.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Properties;
import org.apache.log4j.Logger;

public class GlobalProperties {
    static Logger logger = Logger.getLogger((String)GlobalProperties.class.getName());
    private static Properties properties = new Properties();
    private static String properties_filename = "global.properties";
    private static String gsdl3_home = null;
    private static String gsdl3_writablehome = null;
    private static String gsdl3_web_address = null;
    private static String full_gsdl3_web_address = null;
    private static String http_full_gsdl3_web_address = null;
    private static String https_full_gsdl3_web_address = null;
    private static String localhost_http_web_address = null;

    public static String getProperty(String key) {
        return properties.getProperty(key);
    }

    public static String getProperty(String key, String default_value) {
        return properties.getProperty(key, default_value);
    }

    public static String getGSDL3Home() {
        return gsdl3_home;
    }

    public static String getGSDL3WritableHome() {
        return gsdl3_writablehome;
    }

    public static String getGS2Build() {
        return gsdl3_home + File.separator + ".." + File.separator + "gs2build";
    }

    public static String getGSDL3WebAddress() {
        return gsdl3_web_address;
    }

    public static String getFullGSDL3WebAddress() {
        return full_gsdl3_web_address;
    }

    public static String getLocalHttpBaseAddress() {
        return localhost_http_web_address;
    }

    public static void loadGlobalProperties(String optionalGS3Home) {
        try {
            InputStream in = Class.forName("org.greenstone.util.GlobalProperties").getClassLoader().getResourceAsStream(properties_filename);
            if (in == null) {
                logger.info((Object)("Couldn't find '" + properties_filename + "' through ClassLoader"));
                logger.info((Object)"Trying alternative path through System property gsdl3.writablehome");
                gsdl3_writablehome = System.getProperty("gsdl3.writablehome");
                if (gsdl3_writablehome != null) {
                    String gp_full_filename = gsdl3_writablehome + File.separator + "WEB-INF" + File.separator + "classes" + File.separator + properties_filename;
                    try {
                        in = new FileInputStream(gp_full_filename);
                        logger.info((Object)("Found '" + properties_filename + "'"));
                    }
                    catch (Exception e) {
                        logger.info((Object)("Unable to locate '" + gp_full_filename + "'"));
                    }
                } else {
                    logger.info((Object)"Java property gsdl3.writablehome was not set");
                }
            }
            if (in != null) {
                logger.debug((Object)"Loading global properties");
                properties.load(in);
                in.close();
            } else {
                logger.error((Object)("Failed to find '" + properties_filename + "'"));
            }
            gsdl3_home = properties.getProperty("gsdl3.home");
            if ((gsdl3_home == null || gsdl3_home.length() == 0) && optionalGS3Home != null && optionalGS3Home.length() > 0) {
                gsdl3_home = optionalGS3Home;
            }
            if (gsdl3_home == null) {
                gsdl3_home = System.getenv("GSDL3SRCHOME") + File.separator + "web";
                logger.warn((Object)("** Note: falling back to using GSDL3SRCHOME to set gsdl3.home to: " + gsdl3_home));
            }
            if (gsdl3_home != null) {
                File gs3_file = new File(gsdl3_home);
                gsdl3_home = gs3_file.getPath();
            }
            if ((gsdl3_writablehome = properties.getProperty("gsdl3.writablehome")) == null) {
                gsdl3_writablehome = gsdl3_home;
            }
            String protocolSpecifier = null;
            String hostSpecifier = null;
            String portSpecifier = null;
            String contextSpecifier = null;
            protocolSpecifier = properties.getProperty("server.protocol");
            if (protocolSpecifier == null || protocolSpecifier.equals("")) {
                protocolSpecifier = "http://";
            } else if (!protocolSpecifier.endsWith("://")) {
                protocolSpecifier = protocolSpecifier + "://";
            }
            hostSpecifier = properties.getProperty("tomcat.server");
            if (hostSpecifier == null) {
                hostSpecifier = "localhost";
            } else {
                while (hostSpecifier.endsWith("/")) {
                    hostSpecifier = hostSpecifier.substring(0, hostSpecifier.length() - 1);
                }
            }
            portSpecifier = properties.getProperty("tomcat.port");
            portSpecifier = portSpecifier == null || portSpecifier.equals("") || protocolSpecifier.equals("http://") && portSpecifier.equals("80") || protocolSpecifier.equals("https://") && portSpecifier.equals("443") ? "" : ":" + portSpecifier;
            contextSpecifier = properties.getProperty("tomcat.context");
            if (contextSpecifier == null || contextSpecifier.equals("") || contextSpecifier.equals("/")) {
                contextSpecifier = "";
            } else if (!contextSpecifier.startsWith("/")) {
                contextSpecifier = "/" + contextSpecifier;
            }
            full_gsdl3_web_address = protocolSpecifier + hostSpecifier + portSpecifier + contextSpecifier;
            gsdl3_web_address = contextSpecifier;
            String httpPort = properties.getProperty("localhost.port.http");
            localhost_http_web_address = properties.getProperty("localhost.protocol.http") + "://" + properties.getProperty("localhost.server.http", "127.0.0.1");
            if (httpPort != null && !httpPort.equals("") && !httpPort.equals("80")) {
                localhost_http_web_address = localhost_http_web_address + ":" + httpPort;
            }
            String supportedProtocols = properties.getProperty("server.protocols", "http");
            String isHttpRestrictedToLocal = properties.getProperty("restrict.http.to.local", "true");
            if (protocolSpecifier.startsWith("https")) {
                https_full_gsdl3_web_address = full_gsdl3_web_address;
                if (isHttpRestrictedToLocal.equals("false")) {
                    http_full_gsdl3_web_address = "http://" + hostSpecifier + httpPort + contextSpecifier;
                }
            } else {
                http_full_gsdl3_web_address = full_gsdl3_web_address;
                if (supportedProtocols.contains("https")) {
                    String httpsPort = properties.getProperty("tomcat.port.https");
                    https_full_gsdl3_web_address = "https://" + hostSpecifier + httpsPort + contextSpecifier;
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)("Exception trying to reload global.properties: " + e));
            e.printStackTrace();
        }
    }
}

