/*
 * Decompiled with CFR 0.152.
 */
package org.greenstone.gsdl3.util;

import java.io.File;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.log4j.Logger;
import org.apache.xalan.processor.TransformerFactoryImpl;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class XMLTransformer {
    static Logger logger = Logger.getLogger((String)XMLTransformer.class.getName());
    TransformerFactory t_factory = null;

    public XMLTransformer() {
        System.setProperty("javax.xml.transform.TransformerFactory", "org.apache.xalan.processor.TransformerFactoryImpl");
        try {
            this.t_factory = TransformerFactoryImpl.newInstance();
        }
        catch (Exception e) {
            logger.error((Object)("exception " + e.getMessage()));
        }
    }

    public String transform(String stylesheet, String xml_in) {
        try {
            Transformer transformer = this.t_factory.newTransformer(new StreamSource(stylesheet));
            transformer.setErrorListener(new TransformErrorListener());
            StringWriter output = new StringWriter();
            transformer.transform(new StreamSource(new StringReader(xml_in)), new StreamResult(output));
            return output.toString();
        }
        catch (TransformerConfigurationException e) {
            logger.error((Object)("couldn't create transformer object: " + e.getMessageAndLocation()));
            logger.error((Object)e.getLocationAsString());
            return "";
        }
        catch (TransformerException e) {
            logger.error((Object)("couldn't transform the source: " + e.getMessageAndLocation()));
            return "";
        }
    }

    public String transformToString(Document stylesheet, Document source) {
        return this.transformToString(stylesheet, source, null);
    }

    public String transformToString(Document stylesheet, Document source, HashMap parameters) {
        try {
            Transformer transformer = this.t_factory.newTransformer(new DOMSource(stylesheet));
            transformer.setErrorListener(new TransformErrorListener());
            if (parameters != null) {
                Set params = parameters.entrySet();
                for (Map.Entry m : params) {
                    transformer.setParameter((String)m.getKey(), m.getValue());
                }
            }
            StringWriter output = new StringWriter();
            transformer.transform(new DOMSource(source), new StreamResult(output));
            return output.toString();
        }
        catch (TransformerConfigurationException e) {
            logger.error((Object)("couldn't create transformer object: " + e.getMessageAndLocation()));
            logger.error((Object)e.getLocationAsString());
            return "";
        }
        catch (TransformerException e) {
            logger.error((Object)("couldn't transform the source: " + e.getMessageAndLocation()));
            return "";
        }
    }

    public Node transform(Document stylesheet, Document source) {
        return this.transform(stylesheet, source, null, null);
    }

    public Node transform(Document stylesheet, Document source, HashMap parameters, Document docDocType) {
        try {
            Transformer transformer = this.t_factory.newTransformer(new DOMSource(stylesheet));
            transformer.setErrorListener(new TransformErrorListener());
            if (parameters != null) {
                Set params = parameters.entrySet();
                for (Map.Entry m : params) {
                    transformer.setParameter((String)m.getKey(), m.getValue());
                }
            }
            DOMResult result = docDocType == null ? new DOMResult() : new DOMResult(docDocType);
            transformer.transform(new DOMSource(source), result);
            return result.getNode();
        }
        catch (TransformerConfigurationException e) {
            return this.transformError("XMLTransformer.transform(Doc, Doc, HashMap, Doc)\ncouldn't create transformer object", e);
        }
        catch (TransformerException e) {
            return this.transformError("XMLTransformer.transform(Doc, Doc, HashMap, Doc)\ncouldn't transform the source", e);
        }
    }

    public Node transform(File stylesheet, File source) {
        try {
            Transformer transformer = this.t_factory.newTransformer(new StreamSource(stylesheet));
            transformer.setErrorListener(new TransformErrorListener());
            DOMResult result = new DOMResult();
            transformer.transform(new StreamSource(source), result);
            return result.getNode().getFirstChild();
        }
        catch (TransformerConfigurationException e) {
            return this.transformError("XMLTransformer.transform(File, File)\ncouldn't create transformer object for files\n" + stylesheet + "\n" + source, e);
        }
        catch (TransformerException e) {
            return this.transformError("XMLTransformer.transform(File, File)\ncouldn't transform the source for files\n" + stylesheet + "\n" + source, e);
        }
    }

    public Node transform(File stylesheet, File source, Document docDocType) {
        try {
            Transformer transformer = this.t_factory.newTransformer(new StreamSource(stylesheet));
            transformer.setErrorListener(new TransformErrorListener());
            DOMResult result = new DOMResult(docDocType);
            transformer.transform(new StreamSource(source), result);
            return result.getNode().getFirstChild();
        }
        catch (TransformerConfigurationException e) {
            return this.transformError("XMLTransformer.transform(File, File, Doc)\ncouldn't create transformer object for files\n" + stylesheet + "\n" + source, e);
        }
        catch (TransformerException e) {
            return this.transformError("XMLTransformer.transform(File, File, Doc)\ncouldn't transform the source for files\n" + stylesheet + "\n" + source, e);
        }
    }

    protected Node transformError(String heading, TransformerException e) {
        String message = heading + "\n" + e.getMessage();
        logger.error((Object)(heading + ": " + e.getMessage()));
        String location = e.getLocationAsString();
        if (location != null) {
            logger.error((Object)location);
            message = message + "\n" + location;
        }
        System.err.println("****\n" + message + "\n****");
        return XMLTransformer.constructErrorXHTMLPage(message);
    }

    public static Element constructErrorXHTMLPage(String message) {
        try {
            String[] lines = message.split("\n");
            Document xhtmlDoc = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
            Element htmlNode = xhtmlDoc.createElement("html");
            xhtmlDoc.appendChild(htmlNode);
            Element headNode = xhtmlDoc.createElement("head");
            htmlNode.appendChild(headNode);
            Element titleNode = xhtmlDoc.createElement("title");
            headNode.appendChild(titleNode);
            Text titleString = xhtmlDoc.createTextNode("Error occurred");
            titleNode.appendChild(titleString);
            Element bodyNode = xhtmlDoc.createElement("body");
            htmlNode.appendChild(bodyNode);
            Element h1Node = xhtmlDoc.createElement("h1");
            bodyNode.appendChild(h1Node);
            Text headingString = xhtmlDoc.createTextNode("The following error occurred:");
            h1Node.appendChild(headingString);
            for (int i = 0; i < lines.length; ++i) {
                Element pNode = xhtmlDoc.createElement("p");
                Text textNode = xhtmlDoc.createTextNode(lines[i]);
                pNode.appendChild(textNode);
                bodyNode.appendChild(pNode);
            }
            return xhtmlDoc.getDocumentElement();
        }
        catch (Exception e) {
            String errmsg = "Exception trying to construct error xhtml page from message: " + message + "\n" + e.getMessage();
            System.err.println(errmsg);
            logger.error((Object)errmsg);
            return null;
        }
    }

    public static class TransformErrorListener
    implements ErrorListener {
        protected String errorMessage = null;

        public void error(TransformerException exception) {
            this.handleError("Error:\n", exception);
        }

        public void fatalError(TransformerException exception) {
            this.handleError("Fatal Error:\n", exception);
        }

        public void warning(TransformerException exception) {
            this.handleError("Warning:\n", exception);
        }

        public String toString(TransformerException e) {
            String location = e.getLocationAsString();
            if (location == null) {
                return e.getMessage();
            }
            return e.getMessage() + "\n" + location;
        }

        public String getErrorMessage() {
            String errMsg = this.errorMessage;
            if (this.errorMessage != null) {
                this.errorMessage = null;
            }
            return errMsg;
        }

        protected void handleError(String errorType, TransformerException exception) {
            this.errorMessage = errorType + this.toString(exception);
            System.err.println("\n****Error transforming xml:\n" + this.errorMessage + "\n****\n");
            logger.error((Object)this.errorMessage);
        }
    }
}

