/*
 * Decompiled with CFR 0.152.
 */
package org.greenstone.gsdl3.util;

import org.apache.log4j.Logger;
import org.greenstone.gsdl3.util.DBInfo;
import org.greenstone.gsdl3.util.FlatDatabaseWrapper;
import org.greenstone.gsdl3.util.GDBMWrapper;
import org.greenstone.gsdl3.util.JDBMWrapper;
import org.greenstone.gsdl3.util.OID;

public class SimpleCollectionDatabase {
    static Logger logger = Logger.getLogger((String)SimpleCollectionDatabase.class.getName());
    public static final int READ = 0;
    public static final int WRITE = 1;
    protected FlatDatabaseWrapper coll_db = null;

    public SimpleCollectionDatabase(String db_type) {
        if (db_type.equalsIgnoreCase("gdbm")) {
            this.coll_db = new GDBMWrapper();
        } else if (db_type.equalsIgnoreCase("jdbm")) {
            this.coll_db = new JDBMWrapper();
        } else {
            logger.error((Object)("Couldn't create SimpleCollectionDatabase of type " + db_type));
        }
    }

    public boolean openDatabase(String filename, int mode) {
        return this.coll_db.openDatabase(filename, mode);
    }

    public void closeDatabase() {
        this.coll_db.closeDatabase();
    }

    public DBInfo getInfo(String main_key) {
        String key_info = this.coll_db.getValue(main_key);
        if (key_info == null || key_info.equals("")) {
            return null;
        }
        DBInfo info = new DBInfo();
        String[] lines = key_info.split("\n");
        for (int i = 0; i < lines.length; ++i) {
            logger.debug((Object)("line:" + lines[i]));
            int a = lines[i].indexOf(60);
            int b = lines[i].indexOf(62);
            if (a == -1 || b == -1) {
                logger.error((Object)"bad format in db");
                continue;
            }
            String key = lines[i].substring(a + 1, b);
            String value = lines[i].substring(b + 1);
            logger.debug((Object)("key=" + key + ", val=" + value));
            info.addInfo(key, value);
        }
        return info;
    }

    public String OID2Docnum(String OID2) {
        DBInfo info = this.getInfo(OID2);
        if (info != null) {
            return info.getInfo("docnum");
        }
        return null;
    }

    public long OID2DocnumLong(String OID2) {
        DBInfo info = this.getInfo(OID2);
        if (info != null) {
            long real_num = Long.parseLong(info.getInfo("docnum"));
            return real_num;
        }
        return -1L;
    }

    public String docnum2OID(String docnum) {
        DBInfo info = this.getInfo(docnum);
        if (info != null) {
            String oid = info.getInfo("section");
            return oid;
        }
        return null;
    }

    public String docnum2OID(long docnum) {
        return this.docnum2OID(Long.toString(docnum));
    }

    public String externalId2OID(String extid) {
        DBInfo info = this.getInfo(extid);
        if (info != null) {
            String oid = info.getInfo("section");
            return oid;
        }
        return null;
    }

    public String translateOID(String oid) {
        int i;
        int p = oid.lastIndexOf(46);
        if (p != oid.length() - 3) {
            logger.info((Object)"translateoid error: '.' is not the third to last char!!");
            return oid;
        }
        String top = oid.substring(0, p);
        String suff = oid.substring(p + 1);
        if (OID.needsTranslating(top)) {
            top = this.translateOID(top);
        }
        if (suff.equals("pr")) {
            return OID.getParent(top);
        }
        if (suff.equals("rt")) {
            return OID.getTop(top);
        }
        if (suff.equals("np")) {
            String node_id = this.translateOID(top + ".fc");
            if (!node_id.equals(top)) {
                return node_id;
            }
            node_id = this.translateOID(top + ".ns");
            if (!node_id.equals(top)) {
                return node_id;
            }
            String child_id = top;
            String parent_id = OID.getParent(child_id);
            while (!parent_id.equals(child_id)) {
                node_id = this.translateOID(parent_id + ".ns");
                if (!node_id.equals(parent_id)) {
                    return node_id;
                }
                child_id = parent_id;
                parent_id = OID.getParent(child_id);
            }
            return top;
        }
        if (suff.equals("pp")) {
            String prev_sib = this.translateOID(top + ".ps");
            if (prev_sib.equals(top)) {
                return OID.getParent(top);
            }
            String last_child = this.translateOID(prev_sib + ".lc");
            while (!last_child.equals(prev_sib)) {
                prev_sib = last_child;
                last_child = this.translateOID(prev_sib + ".lc");
            }
            return last_child;
        }
        int sibling_num = 0;
        if (suff.equals("ss")) {
            p = top.lastIndexOf(46);
            sibling_num = Integer.parseInt(top.substring(p + 1));
            top = top.substring(0, p);
        }
        String doc_id = top;
        if (suff.endsWith("s") && (doc_id = OID.getParent(top)).equals(top)) {
            return top;
        }
        DBInfo info = this.getInfo(doc_id);
        if (info == null) {
            logger.info((Object)"info is null!!");
            return top;
        }
        String contains = info.getInfo("contains");
        if (contains.equals("")) {
            return top;
        }
        contains = contains.replaceAll("\"", doc_id);
        String[] children = contains.split(";");
        if (suff.equals("fc")) {
            return children[0];
        }
        if (suff.equals("lc")) {
            return children[children.length - 1];
        }
        if (suff.equals("ss")) {
            return children[sibling_num - 1];
        }
        for (i = 0; i < children.length && !children[i].equals(top); ++i) {
        }
        if (suff.equals("ns")) {
            if (i == children.length - 1) {
                return children[i];
            }
            return children[i + 1];
        }
        if (suff.equals("ps")) {
            if (i == 0) {
                return children[i];
            }
            return children[i - 1];
        }
        return top;
    }
}

