/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jimi.core.raster;

import com.sun.jimi.core.ImageAccessException;
import com.sun.jimi.core.JimiException;
import com.sun.jimi.core.raster.MemoryByteRasterImage;
import com.sun.jimi.core.util.JimiUtil;
import com.sun.jimi.core.util.MulticastImageConsumer;
import java.awt.Rectangle;
import java.awt.image.ColorModel;
import java.awt.image.ImageConsumer;
import java.awt.image.IndexColorModel;

public class OneshotByteRasterImage
extends MemoryByteRasterImage {
    protected byte[] pixelBuffer = new byte[1];
    protected byte[] rowUnpackedBuffer;
    protected int rowByteWidth;

    protected void initStorage() throws JimiException {
        this.rowUnpackedBuffer = new byte[this.rowByteWidth << 3];
    }

    public void setRectangle(int n, int n2, int n3, int n4, byte[] byArray, int n5, int n6) throws ImageAccessException {
        this.setModified();
        this.sendRectangle(n, n2, n3, n4, byArray, n5, n6);
    }

    public void setPixel(int n, int n2, byte by) throws ImageAccessException {
        this.setModified();
        this.sendPixel(n, n2, by);
    }

    protected void sendRectangle(int n, int n2, int n3, int n4, byte[] byArray, int n5, int n6) {
        if (this.hasDirectConsumer()) {
            this.getDirectConsumer().setPixels(n, n2, n3, n4, this.getColorModel(), byArray, n5, n6);
        }
    }

    protected void sendRow(int n, byte[] byArray, int n2) {
        if (this.hasDirectConsumer()) {
            this.getDirectConsumer().setPixels(0, n, this.getWidth(), 1, this.getColorModel(), byArray, n2, 0);
        }
    }

    protected synchronized void sendPixel(int n, int n2, byte by) {
        if (this.hasDirectConsumer()) {
            MulticastImageConsumer multicastImageConsumer = this.getDirectConsumer();
            this.pixelBuffer[0] = by;
            multicastImageConsumer.setPixels(n, n2, 1, 1, this.getColorModel(), this.pixelBuffer, 0, 1);
        }
    }

    public void setRectanglePacked(int n, int n2, int n3, int n4, byte[] byArray, int n5, int n6) throws ImageAccessException {
        this.setModified();
        this.sendRectanglePacked(n, n2, n3, n4, byArray, n5, n6);
    }

    public void setRowPacked(int n, byte[] byArray, int n2) throws ImageAccessException {
        this.setRectanglePacked(0, n, this.getWidth(), 1, byArray, n2, this.getWidth());
    }

    public void getRectanglePacked(int n, int n2, int n3, int n4, byte[] byArray, int n5, int n6) throws ImageAccessException {
    }

    public void getRowPacked(int n, byte[] byArray, int n2) throws ImageAccessException {
    }

    protected void sendRectanglePacked(int n, int n2, int n3, int n4, byte[] byArray, int n5, int n6) throws ImageAccessException {
        if (this.hasDirectConsumer()) {
            MulticastImageConsumer multicastImageConsumer = this.getDirectConsumer();
            int n7 = 0;
            while (n7 < n4) {
                JimiUtil.expandOneBitPixels(byArray, this.rowUnpackedBuffer, n3, n7 * n3 << 3, 0);
                multicastImageConsumer.setPixels(n, n2 + n7, n3, 1, this.getColorModel(), this.rowUnpackedBuffer, 0, n3);
                ++n7;
            }
        }
    }

    protected void addWaitingConsumer(ImageConsumer imageConsumer) {
        imageConsumer.imageComplete(1);
    }

    protected void sendToConsumerFully(ImageConsumer imageConsumer) throws ImageAccessException {
        throw new ImageAccessException();
    }

    protected void sendRegionToConsumerFully(ImageConsumer imageConsumer, Rectangle rectangle) throws ImageAccessException {
        throw new ImageAccessException();
    }

    public OneshotByteRasterImage(int n, int n2, ColorModel colorModel, boolean bl) {
        super(n, n2, colorModel);
        this.rowByteWidth = n + 7 >> 3;
        if (bl && !(colorModel instanceof IndexColorModel)) {
            int n3 = colorModel.getRGB(0);
            int n4 = colorModel.getRGB(1);
            byte[] byArray = new byte[]{(byte)(n3 >> 24 & 0xFF), (byte)(n4 >> 24 & 0xFF)};
            byte[] byArray2 = new byte[]{(byte)(n3 >> 16 & 0xFF), (byte)(n4 >> 16 & 0xFF)};
            byte[] byArray3 = new byte[]{(byte)(n3 >> 8 & 0xFF), (byte)(n4 >> 8 & 0xFF)};
            byte[] byArray4 = new byte[]{(byte)(n3 & 0xFF), (byte)(n4 & 0xFF)};
            IndexColorModel indexColorModel = new IndexColorModel(1, 2, byArray2, byArray3, byArray4, byArray);
            this.setColorModel(indexColorModel);
        }
        try {
            this.initStorage();
            return;
        }
        catch (JimiException jimiException) {
            this.setError();
            return;
        }
    }
}

