package org.nzdl.gsdl.GsdlCollageApplet;

import java.awt.*;
import java.io.*;
import java.net.*;
import java.util.*;
import java.awt.image.*;
import java.awt.geom.*;

/** 
 *  @author Katrina Edgar
 *  @author David Bainbridge
 *
 *  Stores images that are downloaded but have not yet been displayed
 *  in the applet. Provides methods to add to and remove from this list
 *  and check it's size. It uses an inner class to store the data for these
 *  images, comprising of three parts: the image itself, it's source url
 *  and the name of the image */
public class DownloadImages {

    /** Data structure to store an image that has been downloaded and is
     *  waiting to be used. */
    public class ImageUrlTriple {

	Image image_;
	String urlString_;
	String name_;
        URL url_;

	/** Constructs a downloaded image structure from the given parameters
	 *  @param image the graphical image
	 *  @param url the source url for this image
	 *  @param name the name of the image file */
	public ImageUrlTriple (Image image, URL url, String urlString, String name)
	{
	    image_ = image;
	    url_ = url;
            urlString_ = urlString; 
	    name_ = name;
	}

	Image image() {
	    return image_;
	}

	String urlString() {
	    return urlString_;
	}

	String name() {
	    return name_;
	}

	URL url(){
	    return url_;
	}

    }

   
    ImageUrlTriple downloaded_image;
    CollageImage collage_image; 

    /** Refers to applet */
    GsdlCollageApplet app_ = null;
    boolean isJava2_;
    int num_of_downloads = 1;
    boolean stopDownload;

    MediaTracker tracker_;

    /** Initialises an empty vector to store downloaded images in and sets
     *  the verbosity for this class */
    public DownloadImages(GsdlCollageApplet app, int verbosity, boolean isJava2)
    {
	
        app_=app;
        isJava2_= isJava2;
    }

    /** Push a new image into the vector of downloaded images
     *  @param image the graphical image to add
     *  @param url the source url of the image
     *  @param name the name of the image to add */
    public  synchronized int downloadImage(MediaTracker tracker, URL url, String urlString, String name)
    {
	
	tracker_= tracker;

	while (downloaded_image != null ){
	    System.out.println(Thread.currentThread().getName() + " wait to download..."); 
	    try{
		wait();
	    }
	    catch(InterruptedException e){
		return 0;
	    }

	}
      
	Image image = Toolkit.getDefaultToolkit().getImage(url);
	tracker_.addImage(image,num_of_downloads);

	try{
	    tracker_.waitForID(num_of_downloads);
	}
	catch (InterruptedException e){
	    notify();
	    return num_of_downloads;
	}
	

	downloaded_image  = new ImageUrlTriple(image,url,urlString,name);

	notify();
       
	return num_of_downloads ;
    }
 
 
    /** Remove the image from the specified position in the array of downloaded images
     *  @return an ImageUrlTriple containing the image, url and image name */
    public synchronized CollageImage getCollageImage()
    {
	if (stopDownload)  return null;   

	while (downloaded_image == null){
	    System.out.println(Thread.currentThread().getName() + " wait to get Collage image...");
	    try{
		wait();
	    }
	    catch(InterruptedException e){
		//e.printStackTrace();
		downloaded_image = null;
		notify();
		return null;
	    }
	}
         
      	if (tracker_.statusID(num_of_downloads, false) == MediaTracker.COMPLETE){
	    collage_image = new CollageImage(app_,isJava2_,downloaded_image);
	    downloaded_image = null; 
	    num_of_downloads++;
	    notify();
	    return collage_image;
	}
	else{
	    if ((tracker_.statusAll(false) & MediaTracker.ERRORED) != 0){
		//System.out.println(downloaded_image.name_);
		downloaded_image = null;
		num_of_downloads++;
		notify();
		return null;
	    }
	}
	
	return null;

    }

    public void stopDownload(){
        stopDownload = true;
    }

 
}
