/**
 *#########################################################################
 *
 * A component of the Gatherer application, part of the Greenstone digital
 * library suite from the New Zealand Digital Library Project at the
 * University of Waikato, New Zealand.
 *
 * <BR><BR>
 *
 * Author: John Thompson, Greenstone Digital Library, University of Waikato
 *
 * <BR><BR>
 *
 * Copyright (C) 1999 New Zealand Digital Library Project
 *
 * <BR><BR>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * <BR><BR>
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * <BR><BR>
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *########################################################################
 */
package org.greenstone.gatherer.file;

import java.awt.event.*;
import java.io.*;
import javax.swing.*;
import javax.swing.event.*;
import javax.swing.tree.*;
import org.greenstone.gatherer.Gatherer;

/** This class listens for mouse clicks and responds to double-clicks (spawn a new application to view the selected file) and right mouse button clicks (popup menu). 
 * @author John Thompson, Greenstone Digital Library, University of Waikato
 * @version 2.3b
 */
public class FileOpenActionListener
    extends MouseAdapter 
    implements TreeExpansionListener {
    /** This flag gets toggled to <i>true</i> if the listener determines that the next mouse clicked event it will recieve is actually caused by the tree expanding or collapsing. */
    private boolean ignore = false;
    /** The constructor. */
    public FileOpenActionListener() {
    }
    /** Any subclass of MouseAdapter can override this method to respond to mouse click events. In this case we want to start an external application if someone double clicks on an appropriate file record. 
     * @param event A <strong>MouseEvent</strong> containing further information about the mouse click performed.
     * @see org.greenstone.gatherer.Gatherer
     * @see org.greenstone.gatherer.file.FileNode
     * @see org.greenstone.gatherer.gui.tree.DragTree
     */ 
    public void mouseClicked(MouseEvent event) {
	///ystem.err.println("Mouse clicked");
	if(!ignore) {
	    if(event.getClickCount() >= 2) {
		// Find the file we're clicking on.
		JTree tree = (JTree)event.getSource();
		TreePath path = tree.getClosestPathForLocation(event.getX(), event.getY());
		if(path != null) {
		    FileNode record = (FileNode)path.getLastPathComponent();
		    ///ystem.err.println("Double clicked on " + record);
		    File file = record.getFile();
		    if (file != null && file.isFile()) {
			///ystem.err.println("Running " + file);
			Gatherer.f_man.openFileInExternalApplication(file);
		    }
		}
	    }
	}
	else {
	    ///ystem.err.println("Caused by tree expansion / collapse. Ignoring.");
	    ignore = false;
	}
    }
    /** Any implementation of TreeExpansionListener must include this method so that we can be informed when a tree node has been collapsed, thus indicating that any mouse click events about to be recieved are most likely related to this event.
     * @param event A <strong>TreeExpansionEvent</strong> containing information about the node collapsed.
     */
    public void treeCollapsed(TreeExpansionEvent event) {
	///ystem.err.println("Tree Collapsed");
	ignore = true;
    }
    /** Any implementation of TreeExpansionListener must include this method so that we can be informed when a tree node has been expanded, thus indicating that any mouse click events about to be recieved are most likely related to this event.
     * @param event A <strong>TreeExpansionEvent</strong> containing information about the node expanded.
     */
    public void treeExpanded(TreeExpansionEvent event) {
	///ystem.err.println("Tree Expanded");
	ignore = true;
    }
}
