/**********************************************************************
 *
 * lucenesource.cpp -- 
 * Copyright (C) 1999  The New Zealand Digital Library Project
 *
 * A component of the Greenstone digital library software
 * from the New Zealand Digital Library Project at the
 * University of Waikato, New Zealand.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *********************************************************************/

#include "lucenesource.h"
#include "fileutil.h"
#include "OIDtools.h"
#include "expat_document.h"
#include "lucenesearch.h"

lucenesourceclass::lucenesourceclass () 
  : sourceclass()
{
  classname = "lucenesource";
}

lucenesourceclass::~lucenesourceclass () {
}

bool lucenesourceclass::get_document (const text_t &OID, text_t &doc, 
				      comerror_t &err, ostream &logout) {

  outconvertclass text_t2ascii;
  err = noError;
  if (db_ptr == NULL) {
    // most likely a configuration problem
    logout << text_t2ascii 
	   << "configuration error: lucenesource contains a null dbclass\n\n";
    err = configurationError;
    return true;
  }

  // open the database
  db_ptr->setlogout(&logout);
  if (!db_ptr->opendatabase (db_filename, DB_READER, 100, false)) {
    // most likely a system problem (we have already checked that the database exists)
    logout << text_t2ascii
	   << "system problem: open on database \"" << db_filename << "\" failed\n\n";
    err = systemProblem;
    return true;
  }

  text_t tOID = OID;
  if (needs_translating (OID)) 
    translate_OID (OID, tOID, err, logout);
  infodbclass info;
  if (!db_ptr->getinfo(tOID, info)) {
    db_ptr->closedatabase();  // Important that local library doesn't leave any files open
    return false;
  }

  if (info["hastxt"].getint() == 0) { // there is no text for this section
    return false; // true??
  }

  // get the parent id
  text_t parent_OID;
  get_top(tOID, parent_OID);
  
  if (!db_ptr->getinfo(parent_OID, info)) {
    db_ptr->closedatabase();  // Important that local library doesn't leave any files open
    return false;
  }

  text_t archive_dir = info["archivedir"];
  text_t full_path_to_doc = filename_cat(collectdir, "index", "text", archive_dir, "doc.xml");
  
  doc.clear();
  db_ptr->closedatabase();  // Important that local library doesn't leave any files open
  expat_document(full_path_to_doc, ((lucenesearchclass*)textsearchptr)->textlevel, tOID, doc);
  return true;
}
