/* ------------------------------------------------------------------- */
/* D2Mconv   : Converts metadata present in a file to MARC             */
/*             Writes MARC record in "line format"                     */
/*                                                                     */
/* Syntax    : Arguments:                                              */
/*                                                                     */
/*       char *dfile : input file                                      */
/*                     DC metadata must be present in HTML 2.0         */
/*                     or HTML 4.0 syntax                              */
/*       char *buffer: output record in line format                    */
/*                     Must be allocated in calling program!           */
/*       char *tfile : tracefile                                       */
/*                     No trace if NULL                                */
/*       char *url   : URL for use in case no URL in DC.Identifier     */
/*                                                                     */
/*       char *format: MARC format (see d2m.h)                         */
/*                                                                     */
/* Author    : Ole Husby, BIBSYS                                       */
/* Updated   : 1998-09-30                                              */
/* ------------------------------------------------------------------- */

#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <malloc.h>
#include <ctype.h>
#include <unistd.h>
#include <time.h>
#include "d2m.h"




/* ------------------------------------------------------------------- */
/* Checks a new line                                                   */
/* ------------------------------------------------------------------- */
/*
   This is where starting and ending of a meta tag is parsed.
   The whole metatag (resulting from one ore more lines) is put
   into the buffer.

   Note: This function is called recursively!
*/

int mline(char *l, char *buf, int *meta, 
          struct marcrec *mrec, FILE *tf, int format)
{
  char *p, *q, rc;
  int diff;

  struct metatag *mtag;
 
  if (!l || !*l) return 1;

  q = l;


/* Looks for the end of an already started metatag buffer              */
/* The end is normally '">'                                            */

  if (*meta)
  {
     p = strstr(l, "\">");

     if (p) 
     {
        if ( (char *) p != (char *) l)
        {
           diff = (int)(p - l);
           if (*buf)
             strcat(buf, " ");
           strncat(buf, l, diff);
        }

/* Parsing the buffer for metadata                                  */

        mtag = dc_parse(buf);

        if (mtag)
        {
          if (tf)
          {
            fprintf(tf, "Name  : %s\n", mtag->name   );
            fprintf(tf, "Type  : %s\n", mtag->type   );
            fprintf(tf, "Scheme: %s\n", mtag->scheme );
            fprintf(tf, "Value : %s\n", mtag->value  );
            fprintf(tf, "\n");
          }

/*        Convert to MARC                                           */

          MARCmake(mtag, mrec, format);
        }
        free(mtag);

        *buf = 0;
        *meta = FALSE;
        q = p + 2;
     }
     else
     {
        strcat(buf, l);
        q = NULL;
     }
  }


  if (!q) return 1;

  p = (char *) cstr(q, "<meta ");

  if (p)
  {
    *meta = TRUE;
    mline(p + 6, buf, meta, mrec, tf, format);
  }

  return 1;
}



int D2Mconv(char *dfile, char *buffer, char *tfile, char *url, int format)
{
  struct marcrec *mrec;
  struct metatag *mtag;
  char line[50000], today[32];
  char *l, *p;
  time_t d;
  struct tm *time_struct;

  FILE *df, *tf;
  int *meta;

  putenv("TZ=NFT-1DFT");
  d = time(NULL);
  time_struct = localtime(&d);
  strftime(today, 16, "%y%m%d", time_struct);

  mrec = malloc(sizeof(*mrec));

  mrec->marcline = malloc(100000);
  mrec->partitle = malloc(10000);
  mrec->subtitle = malloc(10000);
  mrec->year     = malloc(1000);
  mrec->url      = malloc(1000);
  mrec->fmat     = malloc(1000);
  mrec->s008     = malloc(41);

  mrec->ncreators = 0;
  mrec->ntitles   = 0;
  *mrec->marcline = 0;
  *mrec->subtitle = 0;
  *mrec->partitle = 0;
  *mrec->year     = 0;
  *mrec->url      = 0;
  *mrec->fmat     = 0;
  strcpy(mrec->s008, "                                        ");

  meta = malloc(sizeof(int));

  tf = (FILE *) NULL;


/* Open inputfile */

  df = fopen(dfile, "r");
  if (!df)
    return 0;                            /* Error: Unable to read data */



/* Open tracefile */

   if (*tfile)
   {
     tf = fopen(tfile, "w");
     if (!tf)
     {
       fclose(df);
       return 0;                         /* Error: Unable to create trace */
     }
   }

   *meta = FALSE;


/* Reads the file */ 


   while (l = fgets(line, 9999, df))
   {

/*   Remove trailing LF and / or CR     */

     while ( (l[strlen(l) - 1] == '\n') || (l[strlen(l) - 1] == '\r') )
       l[strlen(l) -1] = '\0';


/*   printf("... main  %s\n",l);                             */ 

/*   Stops reading file if "</head" or "<body" is encountered  */

     p = cstr(l, (char *) "</head");
     if (p) break;

     p = cstr(l, (char *) "<body");
     if (p) break;

     mline(l, (char *) buffer, (int *) meta, mrec, tf, format);
   }



/* Check if remaining data in buffer */
  
   mtag = dc_parse((char *) buffer);

   if (mtag) 
   {
     if (tf)
     {
       fprintf(tf, "Name  : %s\n", mtag->name   );
       fprintf(tf, "Type  : %s\n", mtag->type   );
       fprintf(tf, "Scheme: %s\n", mtag->scheme );
       fprintf(tf, "Value : %s\n", mtag->value  );
       fprintf(tf, "\n");
     }
     MARCmake(mtag, mrec, format);
   }
   free(mtag);


/* Close files */ 

   fclose(df);

   if (tf)
     fclose(tf);

/* Put URL into mrec (if not present)  */

   if (!*mrec->url)
     strcpy(mrec->url, url);

/* Put date into 008 */

   put008(mrec->s008, today, F008_DATE_ENTERED);
   put008(mrec->s008, "s", F008_TYPE_OF_DATE);

   switch (format)
   {
     case ISMARC  :
     {
       put008(mrec->s008, "k", F008_FORM_OF_PUBLICATION);
       break;
     }
   }

/* Tidy up the MARC buffer                                               */

   MARCtidy(mrec, buffer, format);

   return 1;
}
