/**
 *############################################################################
 * A component of the Greenstone Librarian Interface, part of the Greenstone
 * digital library suite from the New Zealand Digital Library Project at the
 * University of Waikato, New Zealand.
 *
 * Author: Michael Dewsnip, NZDL Project, University of Waikato, NZ
 *
 * Copyright (C) 2005 New Zealand Digital Library Project
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *############################################################################
 */

package org.greenstone.gatherer.metadata;


/** This class represents one entry in the metadata value table. */
public class MetadataValueTableEntry
    extends MetadataValue
{
    private int occurrences = 0;


    public MetadataValueTableEntry(MetadataElement metadata_element, MetadataValueTreeNode metadata_value_tree_node)
    {
	super(metadata_element, metadata_value_tree_node);

	occurrences = 1;
    }


    public MetadataValueTableEntry(MetadataValue metadata_value)
    {
	this(metadata_value.getMetadataElement(), metadata_value.getMetadataValueTreeNode());
	inheritsMetadataFromFolder(metadata_value.getFolderMetadataInheritedFrom());
	setIsOneFileOnlyMetadata(metadata_value.isOneFileOnlyMetadata());
    }


    public void anotherOccurrence()
    {
	occurrences++;
    }


    public int getOccurrences()
    {
	return occurrences;
    }


    public void setOccurrences(int occurrences)
    {
	this.occurrences = occurrences;
    }
}
