/*
 * Decompiled with CFR 0.152.
 */
package org.greenstone.gsdl3.collection;

import org.apache.log4j.Logger;
import org.greenstone.gsdl3.collection.Collection;
import org.greenstone.gsdl3.util.GSXML;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class XMLCollection
extends Collection {
    static Logger logger = Logger.getLogger((String)XMLCollection.class.getName());
    protected Element document_list = null;

    protected boolean findAndLoadInfo(Element coll_config_xml, Element build_config_xml) {
        Element config_doc_list;
        Element import_list;
        Element meta_list = (Element)GSXML.getChildByTagName(coll_config_xml, "metadataList");
        this.addMetadata(meta_list);
        meta_list = (Element)GSXML.getChildByTagName(build_config_xml, "metadataList");
        this.addMetadata(meta_list);
        meta_list = this.doc.createElement("metadataList");
        GSXML.addMetadata(this.doc, meta_list, "httpPath", this.site_http_address + "/collect/" + this.cluster_name);
        this.addMetadata(meta_list);
        Element display_list = (Element)GSXML.getChildByTagName(coll_config_xml, "displayItemList");
        if (display_list != null) {
            this.addDisplayItems(display_list);
        }
        if ((import_list = (Element)GSXML.getChildByTagName(coll_config_xml, "import")) != null) {
            Element plugin_list = (Element)GSXML.getChildByTagName(import_list, "pluginList");
            this.addPlugins(plugin_list);
        }
        this.document_list = (config_doc_list = (Element)GSXML.getChildByTagName(coll_config_xml, "documentList")) != null ? (Element)this.doc.importNode(config_doc_list, true) : this.doc.createElement("documentList");
        return true;
    }

    protected Element processMessage(Element request) {
        Element response = this.doc.createElement("response");
        response.setAttribute("from", this.cluster_name);
        String type = request.getAttribute("type");
        String lang = request.getAttribute("lang");
        response.setAttribute("type", type);
        if (type.equals("describe")) {
            Element description = (Element)this.description.cloneNode(false);
            response.appendChild(description);
            Element param_list = (Element)GSXML.getChildByTagName(request, "paramList");
            if (param_list == null) {
                this.addAllDisplayInfo(description, lang);
                description.appendChild(this.service_list);
                description.appendChild(this.metadata_list);
                description.appendChild(this.plugin_item_list);
                description.appendChild(this.document_list);
                return response;
            }
            NodeList params = param_list.getElementsByTagName("param");
            for (int i = 0; i < params.getLength(); ++i) {
                Element param = (Element)params.item(i);
                if (param.getAttribute("name") != "subset") continue;
                String info = param.getAttribute("value");
                if (info.equals("serviceList")) {
                    description.appendChild(this.service_list);
                    continue;
                }
                if (info.equals("metadataList")) {
                    description.appendChild(this.metadata_list);
                    continue;
                }
                if (info.equals("displayItemList")) {
                    this.addAllDisplayInfo(description, lang);
                    continue;
                }
                if (info.equals("documentList")) {
                    description.appendChild(this.document_list);
                    continue;
                }
                if (!info.equals("pluginList")) continue;
                description.appendChild(this.plugin_item_list);
            }
            return response;
        }
        if (type.equals("system")) {
            response = this.processSystemRequest(request);
        } else {
            logger.error((Object)("cant handle request of type " + type));
        }
        return response;
    }
}

