/*
 * Decompiled with CFR 0.152.
 */
package org.greenstone.util;

import java.io.IOException;
import java.net.BindException;
import java.net.ServerSocket;

public class PortFinder {
    public static final int MAX_PORT = 65535;
    public static final int PORTS_RESERVED = 1024;
    public final int PORT_BASE;
    public final int PORT_BLOCK_SIZE;
    private int nextFreePort;
    private int port = -1;

    public PortFinder() {
        this(1025, 64511);
    }

    public PortFinder(int base, int blocksize) {
        this.PORT_BASE = base;
        this.PORT_BLOCK_SIZE = blocksize;
        this.nextFreePort = this.PORT_BASE;
    }

    private void incrementNextFreePort() {
        int offset = this.nextFreePort - this.PORT_BASE;
        offset = (offset + 1) % this.PORT_BLOCK_SIZE;
        this.nextFreePort = this.PORT_BASE + offset;
    }

    public int findPortInRange(boolean verbose) throws Exception {
        try {
            boolean foundFreePort = false;
            for (int i = 0; i < this.PORT_BLOCK_SIZE; ++i) {
                if (PortFinder.isPortAvailable(this.nextFreePort, verbose)) {
                    foundFreePort = true;
                    break;
                }
                this.incrementNextFreePort();
            }
            if (!foundFreePort) {
                throw new Exception("Cannot find an available port in the range " + this.PORT_BASE + "-" + (this.PORT_BASE + this.PORT_BLOCK_SIZE));
            }
            this.port = this.nextFreePort;
            this.incrementNextFreePort();
        }
        catch (IOException e) {
            System.err.println("Error when trying to find an available port. In PortFinder.findPort() " + e);
        }
        return this.port;
    }

    public static boolean isValidPortNumber(int portNum) {
        return portNum >= 0 && portNum <= 65535;
    }

    public static boolean isAssignablePortNumber(int portNum) {
        return portNum > 1024 && portNum <= 65535;
    }

    public static int findAnyFreePort() throws Exception {
        ServerSocket tmpSocket = null;
        int portNumber = -1;
        try {
            tmpSocket = new ServerSocket(0);
            portNumber = tmpSocket.getLocalPort();
            tmpSocket.close();
        }
        catch (Exception e) {
            System.err.println("Unable to find a free port or close it. Got Exception: " + e);
            tmpSocket = null;
        }
        return portNumber;
    }

    public static boolean isPortAvailable(int portnum, boolean verbose) {
        ServerSocket tmpSocket = null;
        try {
            tmpSocket = new ServerSocket(portnum);
            tmpSocket.close();
            return true;
        }
        catch (BindException ex) {
            if (verbose) {
                System.err.println("Port " + portnum + " already in use or can't be assigned.");
            }
            tmpSocket = null;
            return false;
        }
        catch (Exception ex) {
            System.err.println("Problem creating or closing server socket at port " + portnum);
            tmpSocket = null;
            return false;
        }
    }
}

