/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.lucene45;

import java.io.Closeable;
import java.io.IOException;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.lucene.codecs.CodecUtil;
import org.apache.lucene.codecs.DocValuesProducer;
import org.apache.lucene.index.BinaryDocValues;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.DocsAndPositionsEnum;
import org.apache.lucene.index.DocsEnum;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.index.SegmentReadState;
import org.apache.lucene.index.SingletonSortedSetDocValues;
import org.apache.lucene.index.SortedDocValues;
import org.apache.lucene.index.SortedSetDocValues;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.IOUtils;
import org.apache.lucene.util.LongValues;
import org.apache.lucene.util.RamUsageEstimator;
import org.apache.lucene.util.packed.BlockPackedReader;
import org.apache.lucene.util.packed.MonotonicBlockPackedReader;
import org.apache.lucene.util.packed.PackedInts;

public class Lucene45DocValuesProducer
extends DocValuesProducer
implements Closeable {
    private final Map<Integer, NumericEntry> numerics;
    private final Map<Integer, BinaryEntry> binaries;
    private final Map<Integer, SortedSetEntry> sortedSets;
    private final Map<Integer, NumericEntry> ords;
    private final Map<Integer, NumericEntry> ordIndexes;
    private final AtomicLong ramBytesUsed;
    private final IndexInput data;
    private final int maxDoc;
    private final int version;
    private final Map<Integer, MonotonicBlockPackedReader> addressInstances;
    private final Map<Integer, MonotonicBlockPackedReader> ordIndexInstances;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Lucene45DocValuesProducer(SegmentReadState state, String dataCodec, String dataExtension, String metaCodec, String metaExtension) throws IOException {
        block7: {
            boolean success;
            block8: {
                IndexInput in;
                block6: {
                    this.addressInstances = new HashMap<Integer, MonotonicBlockPackedReader>();
                    this.ordIndexInstances = new HashMap<Integer, MonotonicBlockPackedReader>();
                    String metaName = IndexFileNames.segmentFileName(state.segmentInfo.name, state.segmentSuffix, metaExtension);
                    in = state.directory.openInput(metaName, state.context);
                    this.maxDoc = state.segmentInfo.getDocCount();
                    success = false;
                    try {
                        this.version = CodecUtil.checkHeader(in, metaCodec, 0, 1);
                        this.numerics = new HashMap<Integer, NumericEntry>();
                        this.ords = new HashMap<Integer, NumericEntry>();
                        this.ordIndexes = new HashMap<Integer, NumericEntry>();
                        this.binaries = new HashMap<Integer, BinaryEntry>();
                        this.sortedSets = new HashMap<Integer, SortedSetEntry>();
                        this.readFields(in, state.fieldInfos);
                        success = true;
                        if (!success) break block6;
                    }
                    catch (Throwable throwable) {
                        if (success) {
                            IOUtils.close(in);
                            throw throwable;
                        }
                        IOUtils.closeWhileHandlingException(in);
                        throw throwable;
                    }
                    IOUtils.close(in);
                    break block8;
                }
                IOUtils.closeWhileHandlingException(in);
            }
            success = false;
            try {
                String dataName = IndexFileNames.segmentFileName(state.segmentInfo.name, state.segmentSuffix, dataExtension);
                this.data = state.directory.openInput(dataName, state.context);
                int version2 = CodecUtil.checkHeader(this.data, dataCodec, 0, 1);
                if (this.version != version2) {
                    throw new CorruptIndexException("Format versions mismatch");
                }
                success = true;
                if (success) break block7;
            }
            catch (Throwable throwable) {
                if (success) throw throwable;
                IOUtils.closeWhileHandlingException(this.data);
                throw throwable;
            }
            IOUtils.closeWhileHandlingException(this.data);
        }
        this.ramBytesUsed = new AtomicLong(RamUsageEstimator.shallowSizeOfInstance(this.getClass()));
    }

    private void readSortedField(int fieldNumber, IndexInput meta, FieldInfos infos) throws IOException {
        if (meta.readVInt() != fieldNumber) {
            throw new CorruptIndexException("sorted entry for field: " + fieldNumber + " is corrupt (resource=" + meta + ")");
        }
        if (meta.readByte() != 1) {
            throw new CorruptIndexException("sorted entry for field: " + fieldNumber + " is corrupt (resource=" + meta + ")");
        }
        BinaryEntry b = Lucene45DocValuesProducer.readBinaryEntry(meta);
        this.binaries.put(fieldNumber, b);
        if (meta.readVInt() != fieldNumber) {
            throw new CorruptIndexException("sorted entry for field: " + fieldNumber + " is corrupt (resource=" + meta + ")");
        }
        if (meta.readByte() != 0) {
            throw new CorruptIndexException("sorted entry for field: " + fieldNumber + " is corrupt (resource=" + meta + ")");
        }
        NumericEntry n = Lucene45DocValuesProducer.readNumericEntry(meta);
        this.ords.put(fieldNumber, n);
    }

    private void readSortedSetFieldWithAddresses(int fieldNumber, IndexInput meta, FieldInfos infos) throws IOException {
        if (meta.readVInt() != fieldNumber) {
            throw new CorruptIndexException("sortedset entry for field: " + fieldNumber + " is corrupt (resource=" + meta + ")");
        }
        if (meta.readByte() != 1) {
            throw new CorruptIndexException("sortedset entry for field: " + fieldNumber + " is corrupt (resource=" + meta + ")");
        }
        BinaryEntry b = Lucene45DocValuesProducer.readBinaryEntry(meta);
        this.binaries.put(fieldNumber, b);
        if (meta.readVInt() != fieldNumber) {
            throw new CorruptIndexException("sortedset entry for field: " + fieldNumber + " is corrupt (resource=" + meta + ")");
        }
        if (meta.readByte() != 0) {
            throw new CorruptIndexException("sortedset entry for field: " + fieldNumber + " is corrupt (resource=" + meta + ")");
        }
        NumericEntry n1 = Lucene45DocValuesProducer.readNumericEntry(meta);
        this.ords.put(fieldNumber, n1);
        if (meta.readVInt() != fieldNumber) {
            throw new CorruptIndexException("sortedset entry for field: " + fieldNumber + " is corrupt (resource=" + meta + ")");
        }
        if (meta.readByte() != 0) {
            throw new CorruptIndexException("sortedset entry for field: " + fieldNumber + " is corrupt (resource=" + meta + ")");
        }
        NumericEntry n2 = Lucene45DocValuesProducer.readNumericEntry(meta);
        this.ordIndexes.put(fieldNumber, n2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void readFields(IndexInput meta, FieldInfos infos) throws IOException {
        int fieldNumber = meta.readVInt();
        while (fieldNumber != -1) {
            byte type = meta.readByte();
            if (type == 0) {
                this.numerics.put(fieldNumber, Lucene45DocValuesProducer.readNumericEntry(meta));
            } else if (type == 1) {
                BinaryEntry b = Lucene45DocValuesProducer.readBinaryEntry(meta);
                this.binaries.put(fieldNumber, b);
            } else if (type == 2) {
                this.readSortedField(fieldNumber, meta, infos);
            } else {
                if (type != 3) throw new CorruptIndexException("invalid type: " + type + ", resource=" + meta);
                SortedSetEntry ss = this.readSortedSetEntry(meta);
                this.sortedSets.put(fieldNumber, ss);
                if (ss.format == 0) {
                    this.readSortedSetFieldWithAddresses(fieldNumber, meta, infos);
                } else {
                    if (ss.format != 1) throw new AssertionError();
                    if (meta.readVInt() != fieldNumber) {
                        throw new CorruptIndexException("sortedset entry for field: " + fieldNumber + " is corrupt (resource=" + meta + ")");
                    }
                    if (meta.readByte() != 2) {
                        throw new CorruptIndexException("sortedset entry for field: " + fieldNumber + " is corrupt (resource=" + meta + ")");
                    }
                    this.readSortedField(fieldNumber, meta, infos);
                }
            }
            fieldNumber = meta.readVInt();
        }
    }

    static NumericEntry readNumericEntry(IndexInput meta) throws IOException {
        NumericEntry entry = new NumericEntry();
        entry.format = meta.readVInt();
        entry.missingOffset = meta.readLong();
        entry.packedIntsVersion = meta.readVInt();
        entry.offset = meta.readLong();
        entry.count = meta.readVLong();
        entry.blockSize = meta.readVInt();
        switch (entry.format) {
            case 1: {
                entry.minValue = meta.readLong();
                entry.gcd = meta.readLong();
                break;
            }
            case 2: {
                if (entry.count > Integer.MAX_VALUE) {
                    throw new CorruptIndexException("Cannot use TABLE_COMPRESSED with more than MAX_VALUE values, input=" + meta);
                }
                int uniqueValues = meta.readVInt();
                if (uniqueValues > 256) {
                    throw new CorruptIndexException("TABLE_COMPRESSED cannot have more than 256 distinct values, input=" + meta);
                }
                entry.table = new long[uniqueValues];
                for (int i = 0; i < uniqueValues; ++i) {
                    entry.table[i] = meta.readLong();
                }
                break;
            }
            case 0: {
                break;
            }
            default: {
                throw new CorruptIndexException("Unknown format: " + entry.format + ", input=" + meta);
            }
        }
        return entry;
    }

    static BinaryEntry readBinaryEntry(IndexInput meta) throws IOException {
        BinaryEntry entry = new BinaryEntry();
        entry.format = meta.readVInt();
        entry.missingOffset = meta.readLong();
        entry.minLength = meta.readVInt();
        entry.maxLength = meta.readVInt();
        entry.count = meta.readVLong();
        entry.offset = meta.readLong();
        switch (entry.format) {
            case 0: {
                break;
            }
            case 2: {
                entry.addressInterval = meta.readVInt();
                entry.addressesOffset = meta.readLong();
                entry.packedIntsVersion = meta.readVInt();
                entry.blockSize = meta.readVInt();
                break;
            }
            case 1: {
                entry.addressesOffset = meta.readLong();
                entry.packedIntsVersion = meta.readVInt();
                entry.blockSize = meta.readVInt();
                break;
            }
            default: {
                throw new CorruptIndexException("Unknown format: " + entry.format + ", input=" + meta);
            }
        }
        return entry;
    }

    SortedSetEntry readSortedSetEntry(IndexInput meta) throws IOException {
        SortedSetEntry entry = new SortedSetEntry();
        entry.format = this.version >= 1 ? meta.readVInt() : 0;
        if (entry.format != 1 && entry.format != 0) {
            throw new CorruptIndexException("Unknown format: " + entry.format + ", input=" + meta);
        }
        return entry;
    }

    @Override
    public NumericDocValues getNumeric(FieldInfo field) throws IOException {
        NumericEntry entry = this.numerics.get(field.number);
        return this.getNumeric(entry);
    }

    @Override
    public long ramBytesUsed() {
        return this.ramBytesUsed.get();
    }

    LongValues getNumeric(NumericEntry entry) throws IOException {
        IndexInput data = this.data.clone();
        data.seek(entry.offset);
        switch (entry.format) {
            case 0: {
                BlockPackedReader reader = new BlockPackedReader(data, entry.packedIntsVersion, entry.blockSize, entry.count, true);
                return reader;
            }
            case 1: {
                final long min = entry.minValue;
                final long mult = entry.gcd;
                final BlockPackedReader quotientReader = new BlockPackedReader(data, entry.packedIntsVersion, entry.blockSize, entry.count, true);
                return new LongValues(){

                    @Override
                    public long get(long id) {
                        return min + mult * quotientReader.get(id);
                    }
                };
            }
            case 2: {
                final long[] table = entry.table;
                int bitsRequired = PackedInts.bitsRequired(table.length - 1);
                final PackedInts.Reader ords = PackedInts.getDirectReaderNoHeader(data, PackedInts.Format.PACKED, entry.packedIntsVersion, (int)entry.count, bitsRequired);
                return new LongValues(){

                    @Override
                    public long get(long id) {
                        return table[(int)ords.get((int)id)];
                    }
                };
            }
        }
        throw new AssertionError();
    }

    @Override
    public BinaryDocValues getBinary(FieldInfo field) throws IOException {
        BinaryEntry bytes = this.binaries.get(field.number);
        switch (bytes.format) {
            case 0: {
                return this.getFixedBinary(field, bytes);
            }
            case 1: {
                return this.getVariableBinary(field, bytes);
            }
            case 2: {
                return this.getCompressedBinary(field, bytes);
            }
        }
        throw new AssertionError();
    }

    private BinaryDocValues getFixedBinary(FieldInfo field, final BinaryEntry bytes) {
        final IndexInput data = this.data.clone();
        return new LongBinaryDocValues(){

            @Override
            public void get(long id, BytesRef result) {
                long address = bytes.offset + id * (long)bytes.maxLength;
                try {
                    data.seek(address);
                    byte[] buffer = new byte[bytes.maxLength];
                    data.readBytes(buffer, 0, buffer.length);
                    result.bytes = buffer;
                    result.offset = 0;
                    result.length = buffer.length;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected MonotonicBlockPackedReader getAddressInstance(IndexInput data, FieldInfo field, BinaryEntry bytes) throws IOException {
        MonotonicBlockPackedReader addresses;
        Map<Integer, MonotonicBlockPackedReader> map = this.addressInstances;
        synchronized (map) {
            MonotonicBlockPackedReader addrInstance = this.addressInstances.get(field.number);
            if (addrInstance == null) {
                data.seek(bytes.addressesOffset);
                addrInstance = new MonotonicBlockPackedReader(data, bytes.packedIntsVersion, bytes.blockSize, bytes.count, false);
                this.addressInstances.put(field.number, addrInstance);
                this.ramBytesUsed.addAndGet(addrInstance.ramBytesUsed() + 4L);
            }
            addresses = addrInstance;
        }
        return addresses;
    }

    private BinaryDocValues getVariableBinary(FieldInfo field, final BinaryEntry bytes) throws IOException {
        final IndexInput data = this.data.clone();
        final MonotonicBlockPackedReader addresses = this.getAddressInstance(data, field, bytes);
        return new LongBinaryDocValues(){

            @Override
            public void get(long id, BytesRef result) {
                long startAddress = bytes.offset + (id == 0L ? 0L : addresses.get(id - 1L));
                long endAddress = bytes.offset + addresses.get(id);
                int length = (int)(endAddress - startAddress);
                try {
                    data.seek(startAddress);
                    byte[] buffer = new byte[length];
                    data.readBytes(buffer, 0, buffer.length);
                    result.bytes = buffer;
                    result.offset = 0;
                    result.length = length;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected MonotonicBlockPackedReader getIntervalInstance(IndexInput data, FieldInfo field, BinaryEntry bytes) throws IOException {
        MonotonicBlockPackedReader addresses;
        long interval = bytes.addressInterval;
        Map<Integer, MonotonicBlockPackedReader> map = this.addressInstances;
        synchronized (map) {
            MonotonicBlockPackedReader addrInstance = this.addressInstances.get(field.number);
            if (addrInstance == null) {
                data.seek(bytes.addressesOffset);
                long size = bytes.count % interval == 0L ? bytes.count / interval : 1L + bytes.count / interval;
                addrInstance = new MonotonicBlockPackedReader(data, bytes.packedIntsVersion, bytes.blockSize, size, false);
                this.addressInstances.put(field.number, addrInstance);
                this.ramBytesUsed.addAndGet(addrInstance.ramBytesUsed() + 4L);
            }
            addresses = addrInstance;
        }
        return addresses;
    }

    private BinaryDocValues getCompressedBinary(FieldInfo field, BinaryEntry bytes) throws IOException {
        IndexInput data = this.data.clone();
        MonotonicBlockPackedReader addresses = this.getIntervalInstance(data, field, bytes);
        return new CompressedBinaryDocValues(bytes, addresses, data);
    }

    @Override
    public SortedDocValues getSorted(FieldInfo field) throws IOException {
        final int valueCount = (int)this.binaries.get((Object)Integer.valueOf((int)field.number)).count;
        final BinaryDocValues binary = this.getBinary(field);
        NumericEntry entry = this.ords.get(field.number);
        IndexInput data = this.data.clone();
        data.seek(entry.offset);
        final BlockPackedReader ordinals = new BlockPackedReader(data, entry.packedIntsVersion, entry.blockSize, entry.count, true);
        return new SortedDocValues(){

            @Override
            public int getOrd(int docID) {
                return (int)ordinals.get(docID);
            }

            @Override
            public void lookupOrd(int ord, BytesRef result) {
                binary.get(ord, result);
            }

            @Override
            public int getValueCount() {
                return valueCount;
            }

            @Override
            public int lookupTerm(BytesRef key) {
                if (binary instanceof CompressedBinaryDocValues) {
                    return (int)((CompressedBinaryDocValues)binary).lookupTerm(key);
                }
                return super.lookupTerm(key);
            }

            @Override
            public TermsEnum termsEnum() {
                if (binary instanceof CompressedBinaryDocValues) {
                    return ((CompressedBinaryDocValues)binary).getTermsEnum();
                }
                return super.termsEnum();
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected MonotonicBlockPackedReader getOrdIndexInstance(IndexInput data, FieldInfo field, NumericEntry entry) throws IOException {
        MonotonicBlockPackedReader ordIndex;
        Map<Integer, MonotonicBlockPackedReader> map = this.ordIndexInstances;
        synchronized (map) {
            MonotonicBlockPackedReader ordIndexInstance = this.ordIndexInstances.get(field.number);
            if (ordIndexInstance == null) {
                data.seek(entry.offset);
                ordIndexInstance = new MonotonicBlockPackedReader(data, entry.packedIntsVersion, entry.blockSize, entry.count, false);
                this.ordIndexInstances.put(field.number, ordIndexInstance);
                this.ramBytesUsed.addAndGet(ordIndexInstance.ramBytesUsed() + 4L);
            }
            ordIndex = ordIndexInstance;
        }
        return ordIndex;
    }

    @Override
    public SortedSetDocValues getSortedSet(FieldInfo field) throws IOException {
        SortedSetEntry ss = this.sortedSets.get(field.number);
        if (ss.format == 1) {
            SortedDocValues values = this.getSorted(field);
            return new SingletonSortedSetDocValues(values);
        }
        if (ss.format != 0) {
            throw new AssertionError();
        }
        IndexInput data = this.data.clone();
        final long valueCount = this.binaries.get((Object)Integer.valueOf((int)field.number)).count;
        final LongBinaryDocValues binary = (LongBinaryDocValues)this.getBinary(field);
        final LongValues ordinals = this.getNumeric(this.ords.get(field.number));
        final MonotonicBlockPackedReader ordIndex = this.getOrdIndexInstance(data, field, this.ordIndexes.get(field.number));
        return new SortedSetDocValues(){
            long offset;
            long endOffset;

            @Override
            public long nextOrd() {
                if (this.offset == this.endOffset) {
                    return -1L;
                }
                long ord = ordinals.get(this.offset);
                ++this.offset;
                return ord;
            }

            @Override
            public void setDocument(int docID) {
                this.offset = docID == 0 ? 0L : ordIndex.get(docID - 1);
                this.endOffset = ordIndex.get(docID);
            }

            @Override
            public void lookupOrd(long ord, BytesRef result) {
                binary.get(ord, result);
            }

            @Override
            public long getValueCount() {
                return valueCount;
            }

            @Override
            public long lookupTerm(BytesRef key) {
                if (binary instanceof CompressedBinaryDocValues) {
                    return ((CompressedBinaryDocValues)binary).lookupTerm(key);
                }
                return super.lookupTerm(key);
            }

            @Override
            public TermsEnum termsEnum() {
                if (binary instanceof CompressedBinaryDocValues) {
                    return ((CompressedBinaryDocValues)binary).getTermsEnum();
                }
                return super.termsEnum();
            }
        };
    }

    private Bits getMissingBits(final long offset) throws IOException {
        if (offset == -1L) {
            return new Bits.MatchAllBits(this.maxDoc);
        }
        final IndexInput in = this.data.clone();
        return new Bits(){

            @Override
            public boolean get(int index) {
                try {
                    in.seek(offset + (long)(index >> 3));
                    return (in.readByte() & 1 << (index & 7)) != 0;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }

            @Override
            public int length() {
                return Lucene45DocValuesProducer.this.maxDoc;
            }
        };
    }

    @Override
    public Bits getDocsWithField(FieldInfo field) throws IOException {
        switch (field.getDocValuesType()) {
            case SORTED_SET: {
                return new DocValuesProducer.SortedSetDocsWithField(this.getSortedSet(field), this.maxDoc);
            }
            case SORTED: {
                return new DocValuesProducer.SortedDocsWithField(this.getSorted(field), this.maxDoc);
            }
            case BINARY: {
                BinaryEntry be = this.binaries.get(field.number);
                return this.getMissingBits(be.missingOffset);
            }
            case NUMERIC: {
                NumericEntry ne = this.numerics.get(field.number);
                return this.getMissingBits(ne.missingOffset);
            }
        }
        throw new AssertionError();
    }

    @Override
    public void close() throws IOException {
        this.data.close();
    }

    static class CompressedBinaryDocValues
    extends LongBinaryDocValues {
        final BinaryEntry bytes;
        final long interval;
        final long numValues;
        final long numIndexValues;
        final MonotonicBlockPackedReader addresses;
        final IndexInput data;
        final TermsEnum termsEnum;

        public CompressedBinaryDocValues(BinaryEntry bytes, MonotonicBlockPackedReader addresses, IndexInput data) throws IOException {
            this.bytes = bytes;
            this.interval = bytes.addressInterval;
            this.addresses = addresses;
            this.data = data;
            this.numValues = bytes.count;
            this.numIndexValues = addresses.size();
            this.termsEnum = this.getTermsEnum(data);
        }

        @Override
        public void get(long id, BytesRef result) {
            try {
                this.termsEnum.seekExact(id);
                BytesRef term = this.termsEnum.term();
                result.bytes = term.bytes;
                result.offset = term.offset;
                result.length = term.length;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        long lookupTerm(BytesRef key) {
            try {
                TermsEnum.SeekStatus status = this.termsEnum.seekCeil(key);
                if (status == TermsEnum.SeekStatus.END) {
                    return -this.numValues - 1L;
                }
                if (status == TermsEnum.SeekStatus.FOUND) {
                    return this.termsEnum.ord();
                }
                return -this.termsEnum.ord() - 1L;
            }
            catch (IOException bogus) {
                throw new RuntimeException(bogus);
            }
        }

        TermsEnum getTermsEnum() {
            try {
                return this.getTermsEnum(this.data.clone());
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        private TermsEnum getTermsEnum(final IndexInput input) throws IOException {
            input.seek(this.bytes.offset);
            return new TermsEnum(){
                private long currentOrd = -1L;
                private final BytesRef termBuffer;
                private final BytesRef term;
                {
                    this.termBuffer = new BytesRef(CompressedBinaryDocValues.this.bytes.maxLength < 0 ? 0 : CompressedBinaryDocValues.this.bytes.maxLength);
                    this.term = new BytesRef();
                }

                @Override
                public BytesRef next() throws IOException {
                    if (this.doNext() == null) {
                        return null;
                    }
                    this.setTerm();
                    return this.term;
                }

                private BytesRef doNext() throws IOException {
                    if (++this.currentOrd >= CompressedBinaryDocValues.this.numValues) {
                        return null;
                    }
                    int start = input.readVInt();
                    int suffix = input.readVInt();
                    input.readBytes(this.termBuffer.bytes, start, suffix);
                    this.termBuffer.length = start + suffix;
                    return this.termBuffer;
                }

                @Override
                public TermsEnum.SeekStatus seekCeil(BytesRef text) throws IOException {
                    int cmp;
                    long low = 0L;
                    long high = CompressedBinaryDocValues.this.numIndexValues - 1L;
                    while (low <= high) {
                        long mid = low + high >>> 1;
                        this.doSeek(mid * CompressedBinaryDocValues.this.interval);
                        cmp = this.termBuffer.compareTo(text);
                        if (cmp < 0) {
                            low = mid + 1L;
                            continue;
                        }
                        if (cmp > 0) {
                            high = mid - 1L;
                            continue;
                        }
                        this.setTerm();
                        return TermsEnum.SeekStatus.FOUND;
                    }
                    if (CompressedBinaryDocValues.this.numIndexValues == 0L) {
                        return TermsEnum.SeekStatus.END;
                    }
                    long block = low - 1L;
                    this.doSeek(block < 0L ? -1L : block * CompressedBinaryDocValues.this.interval);
                    while (this.doNext() != null) {
                        cmp = this.termBuffer.compareTo(text);
                        if (cmp == 0) {
                            this.setTerm();
                            return TermsEnum.SeekStatus.FOUND;
                        }
                        if (cmp <= 0) continue;
                        this.setTerm();
                        return TermsEnum.SeekStatus.NOT_FOUND;
                    }
                    return TermsEnum.SeekStatus.END;
                }

                @Override
                public void seekExact(long ord) throws IOException {
                    this.doSeek(ord);
                    this.setTerm();
                }

                private void doSeek(long ord) throws IOException {
                    long block = ord / CompressedBinaryDocValues.this.interval;
                    if (ord < this.currentOrd || block != this.currentOrd / CompressedBinaryDocValues.this.interval) {
                        this.currentOrd = ord - ord % CompressedBinaryDocValues.this.interval - 1L;
                        input.seek(CompressedBinaryDocValues.this.bytes.offset + CompressedBinaryDocValues.this.addresses.get(block));
                    }
                    while (this.currentOrd < ord) {
                        this.doNext();
                    }
                }

                private void setTerm() {
                    this.term.bytes = new byte[this.termBuffer.length];
                    this.term.offset = 0;
                    this.term.copyBytes(this.termBuffer);
                }

                @Override
                public BytesRef term() throws IOException {
                    return this.term;
                }

                @Override
                public long ord() throws IOException {
                    return this.currentOrd;
                }

                @Override
                public Comparator<BytesRef> getComparator() {
                    return BytesRef.getUTF8SortedAsUnicodeComparator();
                }

                @Override
                public int docFreq() throws IOException {
                    throw new UnsupportedOperationException();
                }

                @Override
                public long totalTermFreq() throws IOException {
                    return -1L;
                }

                @Override
                public DocsEnum docs(Bits liveDocs, DocsEnum reuse, int flags) throws IOException {
                    throw new UnsupportedOperationException();
                }

                @Override
                public DocsAndPositionsEnum docsAndPositions(Bits liveDocs, DocsAndPositionsEnum reuse, int flags) throws IOException {
                    throw new UnsupportedOperationException();
                }
            };
        }
    }

    static abstract class LongBinaryDocValues
    extends BinaryDocValues {
        LongBinaryDocValues() {
        }

        @Override
        public final void get(int docID, BytesRef result) {
            this.get((long)docID, result);
        }

        abstract void get(long var1, BytesRef var3);
    }

    protected static class SortedSetEntry {
        int format;

        private SortedSetEntry() {
        }
    }

    protected static class BinaryEntry {
        long missingOffset;
        long offset;
        int format;
        public long count;
        int minLength;
        int maxLength;
        public long addressesOffset;
        public long addressInterval;
        public int packedIntsVersion;
        public int blockSize;

        private BinaryEntry() {
        }
    }

    protected static class NumericEntry {
        long missingOffset;
        public long offset;
        int format;
        public int packedIntsVersion;
        public long count;
        public int blockSize;
        long minValue;
        long gcd;
        long[] table;

        private NumericEntry() {
        }
    }
}

