/**********************************************************************
 *
 * librarymain.cpp -- 
 * Copyright (C) 1999  The New Zealand Digital Library Project
 *
 * A component of the Greenstone digital library software
 * from the New Zealand Digital Library Project at the
 * University of Waikato, New Zealand.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *********************************************************************/

#include "gsdl_modules_cfg.h"
#include "receptionist.h"
#include "cgiwrapper.h"
#include "fileutil.h"
#include "nullproto.h"
// z39.50 stuff - johnmcp
#if defined(USE_Z3950)
#include "z3950proto.h"
#endif
#include "collectset.h"

#include "action.h"
#include "ispersistentaction.h"
#include "browserclass.h"


int main ()
{
  receptionist recpt;
  nullproto    nproto;
  collectset  *cservers;
#if defined(USE_Z3950)
  z3950proto   zproto;
#endif
  text_t       gsdlhome;
  text_t       collecthome;

  cservers = new collectset(gsdlhome,collecthome);

  // configure the receptionist server list
  text_tarray collection_list;
  cservers->getCollectionList(collection_list);
  text_tarray::iterator collection_iterator = collection_list.begin();
  while (collection_iterator != collection_list.end())
  {
    text_tarray colinfo;
    colinfo.push_back(*collection_iterator);
    colinfo.push_back(gsdlhome);
    colinfo.push_back(collecthome);
    colinfo.push_back(gsdlhome);
    recpt.configure("collectinfo", colinfo);
    collection_iterator++;
  }

  // set up the null protocol
  nproto.set_collectset(cservers);

  // add the protocol to the receptionist
  recpt.add_protocol (&nproto);

  // z39.50 stuff - johnmcp
#if defined(USE_Z3950)
  // add the z39.50 server information. Read in the file
  // etc/packages/z3950/z3950.cfg for list of servers and their databases.
  text_t z3950cfg = filename_cat (gsdlhome, "etc", "packages", "z3950", "z3950.cfg");
#ifdef USE_FASTCGI
  // currently can't use z39.50 if fastcgi used
#warning  "Disabling z39.50 support as fastcgi is in use"
  if (0) {
#else
  if (file_exists(z3950cfg)) {
#endif
    text_t z3950err = filename_cat (gsdlhome, "etc", "packages", "z3950", "z3950log.txt");
    zproto.read_config_file(z3950cfg,z3950err);
    // only add this protocol if we have any servers configured.
    if (zproto.getServerCount()>0)
      recpt.add_protocol (&zproto);
  }
#endif

  userdbclass *udb = new userdbclass(gsdlhome);
  keydbclass *kdb = new keydbclass(gsdlhome);

  add_all_actions(recpt,udb,kdb,isNotPersistent); // apache (without mod_gsdl) is not a persistent server
  // Note: these actions will become invalid at the end of this function. 
  // => We will retrieve them from the receptionist and delete them

  add_all_browsers(recpt);
  // Browsers are not currently deleted (at all?) in code.  Seems likely they
  // should be treated in a similar fashion to actions

  cgiwrapper (recpt, "");
  delete cservers;
  delete udb;
  delete kdb;

  // clean up the actions
  actionmapclass::iterator thisAction = recpt.get_actionmap_ptr()->begin();
  actionmapclass::iterator endAction = recpt.get_actionmap_ptr()->end();
  while (thisAction != endAction) {
    delete thisAction->second.a; 
    thisAction->second.a = NULL;
    ++thisAction;
  }
  thisAction = recpt.get_actionmap_ptr()->begin();
  recpt.get_actionmap_ptr()->erase(thisAction, endAction);


  /*
  // clean up the browsers
  browsermapclass::iterator thisBrowser = recpt.get_browsermap_ptr()->begin();
  browsermapclass::iterator endBrowser = recpt.get_browsermap_ptr()->end();
  while (thisBrowser != endBrowser) {
    delete thisBrowser->second.a; 
    thisBrowser->second.a = NULL;
    ++thisBrowser;
  }
  thisBrowser = recpt.get_browsermap_ptr()->begin();
  recpt.get_browsermap_ptr()->erase(thisBrowser, endBrowser);
  */

  return 0;
}
