/**********************************************************************
 *
 * qualified_dublincore.cpp --
 *
 * Copyright (C) 2004-2010  The New Zealand Digital Library Project
 *
 * A component of the Greenstone digital library software
 * from the New Zealand Digital Library Project at the
 * University of Waikato, New Zealand.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *********************************************************************/


#include "qualified_dublincore.h"

qualified_dublin_core::qualified_dublin_core() : dublin_core() {
  // These element names taken from the schema
  //http://www.greenstone.org/namespace/gsdl_qdc/1.0/gsdl_qdc.xsd

  // We have the following elements already by inheriting from dublin_core
  /*   elementSet.insert("title");
   elementSet.insert("creator");
   elementSet.insert("subject");
   elementSet.insert("description");
   elementSet.insert("publisher");
   elementSet.insert("contributor");
   elementSet.insert("date");
   elementSet.insert("type");
   elementSet.insert("format");
   elementSet.insert("identifier");
   elementSet.insert("source");
   elementSet.insert("language");
   elementSet.insert("relation");
   elementSet.insert("coverage");
   elementSet.insert("rights");
  */
   elementSet.insert("alternative");
   elementSet.insert("tableOfContents");
   elementSet.insert("abstract");
   elementSet.insert("created");
   elementSet.insert("valid");
   elementSet.insert("available");
   elementSet.insert("issued"); 
   elementSet.insert("modified");
   elementSet.insert("dateAccepted");
   elementSet.insert("dateCopyrighted");
   elementSet.insert("dateSubmitted");
   elementSet.insert("extent");
   elementSet.insert("medium");
   elementSet.insert("isVersionOf");
   elementSet.insert("hasVersion");
   elementSet.insert("isReplacedBy");
   elementSet.insert("replaces"); 
   elementSet.insert("isRequiredBy");
   elementSet.insert("requires"); 
   elementSet.insert("isPartOf");
   elementSet.insert("hasPart"); 
   elementSet.insert("isReferencedBy");
   elementSet.insert("references");
   elementSet.insert("isFormatOf");
   elementSet.insert("hasFormat");
   elementSet.insert("conformsTo");
   elementSet.insert("spatial");
   elementSet.insert("temporal");
   elementSet.insert("audience");
   elementSet.insert("accrualMethod");
   elementSet.insert("accrualPeriodicity");
   elementSet.insert("accrualPolicy");
   elementSet.insert("instructionalMethod");
   elementSet.insert("provenance");
   elementSet.insert("rightsHolder");
   elementSet.insert("mediator");
   elementSet.insert("educationLevel");
   elementSet.insert("accessRights");
   elementSet.insert("license"); 
   elementSet.insert("bibliographicCitation");
}
const text_t qualified_dublin_core::formatName() {
  return "gsdl_qdc";
}

const text_t qualified_dublin_core::formatPrefix() {
  return "dc";
}


void qualified_dublin_core::output_metadata_header(ostream &output)
{ 
  output << "    <metadata>\n";
  
  if (this->oaiConfigure->getOAIVersion() <= 110){
    // output dublin core wrapper for OAI v1.1
    output << "      <gsdl_qdc xmlns=\"http://greenstone.org/namespace/gsdl_qdc/1.0/\"\n"
	   << "          xmlns:xsi=\"http://www.w3c.org/2001/XMLSchema-instance\"\n"
	   << "          xsi:schemaLocation=\"http://greenstone.org/namespace/gsdl_qdc/1.0/ \n"
	   << "                              http://greenstone.org/namespace/gsdl_qdc/1.0/gsdl_qdc.xsd\">\n";
  }
  else { 
    output << "      <gsdl_qdc:gsdl_qdc\n"
	   << "          xmlns:gsdl_qdc=\"http://greenstone.org/namespace/gsdl_qdc/1.0/\"\n"
	   << "          xmlns:dc=\"http://purl.org/dc/terms/\"\n"
	   << "          xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n"
	   << "          xsi:schemaLocation=\"http://greenstone.org/namespace/gsdl_qdc/1.0/ \n"
	   << "                              http://greenstone.org/namespace/gsdl_qdc/1.0/gsdl_qdc.xsd\">\n";
  }
}

void qualified_dublin_core::output_metadata_footer(ostream &output)
{
  if (this->oaiConfigure->getOAIVersion() <= 110) {
    output << "      </gsdl_qdc>" << endl;
  }
  else {
    output << "      </gsdl_qdc:gsdl_qdc>" << endl;
  }

  output << "    </metadata>" << endl; 
  output.flush();
}

bool qualified_dublin_core::output_formatdata(ostream &output)
{
  output << "    <metadataPrefix>gsdl_qdc</metadataPrefix>" << endl;
  output << "    <schema>http://greenstone.org/namespace/gsdl_qdc/1.0/gsdl_qdc.xsd</schema>" << endl;
  output << "    <metadataNamespace>http://greenstone.org/namespace/gsdl_qdc/1.0/</metadataNamespace>"<<endl;
  return true;
}
