/* ------------------------------------------------------------------- */
/* MARCtidy  : Tidying up of MARC record, building the line format     */
/*             record.                                                 */
/*                                                                     */
/* Syntax    : MARCtidy(marcrec *mrec, char *buf, int format)          */
/*                                                                     */
/*             The preliminary MARC data are converted from the        */
/*             mrec struct to the buf line format buffer.              */
/*                                                                     */
/*             The main data is in mrec->marcline, while some          */
/*             additional data (year, URL ...) are kept in separat     */
/*             variables to be added in.                               */
/*                                                                     */
/* NOTE      : The behaviour of this program i sto some extent         */
/*             depending on the format argument!                       */
/*                                                                     */
/* Author    : Ole Husby, BIBSYS                                       */
/* Updated   : 1998-09-30                                              */
/* ------------------------------------------------------------------- */

#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif
#include "d2m.h"



void  nline(char *p, char *l, char *buf)
{
   strcat(buf, p);
   if (strncmp(p, "00", 2) != 0)
     strcat(buf, " ");
   strcat(buf, l);
   strcat(buf, "\n");
}



void MARCtidy(struct marcrec *mrec, char *buf, int format)
{

   char *p, *u, *l;
   char pre[64], line[10000];

   p = (char *) &pre;
   l = (char *) &line;

   *buf = 0;

   strcpy(p, "008");
   strcpy(l, mrec->s008);
   nline(p, l, buf);

   u = strtok(mrec->marcline, "\n");
   while (u && *u)
   {
      if (strlen(u) > 7)
      {
        *p = 0;
        strncat(p, u, 7);
        strcpy(l, u + 8);
        nline(p, l, buf);

	/* Add 200 subfields after $a - unimarc */
	if ( (strncmp(p, "200", 3) == 0) && (strncmp(p + 5, "$a", 2) == 0) )
	  {
	    if ( ( format == UNIMARC ) && ( *mrec->subtitle) )
	      {
		strcpy(p, "     $e");
		strcpy(l, mrec->subtitle);
		nline(p, l, buf);
	      }
	  }

/*      Add 245 subfields after $a */

        if ( (strncmp(p, "245", 3) == 0) && (strncmp(p + 5, "$a", 2) == 0) )
        {
          if ( ( format == NORMARC ) && ( *mrec->subtitle) )
          {
            strcpy(p, "     $b");
            strcpy(l, mrec->subtitle);
            nline(p, l, buf);
          }
          if ( *mrec->partitle )
          {
            if ( format == FINMARC || format == DANMARC ) 
            {
              strcpy(p, "    ");
              strcpy(l, mrec->partitle);
              nline(p, l, buf);
            }
            if ( format == ISMARC ) 
            {
              strcpy(l, mrec->partitle);
              nline(p, l, buf);
            }
          }
        } 

/*      Add year as 260 $c after $b                                    */

        if ( (strncmp(p, "260", 3) == 0) && (strncmp(p + 5, "$b", 2) == 0) )
        {
          if (*mrec->year)
          {
            strcpy(p, "     $c");
            strcpy(l, mrec->year);
            nline(p, l, buf);
            *mrec->year = 0;
          }
        } 
      }
      u = strtok(NULL, "\n");
   }

/* Add year as 260 $c if not aleady done                               */

   if (*mrec->year)
   {
     strcpy(p, "260  $c");
     strcpy(l, mrec->year);
     nline(p, l, buf);
   }

/* Add parallel title in spearate field  */

   if ( *mrec->partitle && ( format == ISMARC ) ) 
   {
     strcpy(p, "24630$c");
     strcpy(l, mrec->partitle);
     nline(p, l, buf);
   }


/* Add URL as 856 $u  (or 300 $a for unimarc)                       */

   if (*mrec->url)
   {
     if (format == UNIMARC) {
       strcpy(p, "300  $a");
       strcpy(l, mrec->url);
       nline(p, l, buf);


     } else {
       strcpy(p, "856  $u");
       strcpy(l, mrec->url);
       nline(p, l, buf);
     }
   }
/* Add format as $q (or 336 $a for unimarc)            */

     if (*mrec->fmat)
     {

       if (format == UNIMARC) {
	 strcpy(p, "336  $a");
	 strcpy(l, mrec->fmat);
	 nline(p, l, buf);
       }
       else {
	 strcpy(p, "     $q");
	 strcpy(l, mrec->fmat);
	 nline(p, l, buf);
       }
     }


}
