/**
 *############################################################################
 * A component of the Greenstone Librarian Interface, part of the Greenstone
 * digital library suite from the New Zealand Digital Library Project at the
 * University of Waikato, New Zealand.
 *
 * Author: Michael Dewsnip, NZDL Project, University of Waikato, NZ
 *
 * Copyright (C) 2004 New Zealand Digital Library Project
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *############################################################################
 */

package org.greenstone.gatherer.metadata;


import javax.swing.tree.*;


/** This class represents one Metadata value */
public class MetadataValueTreeNode
    extends DefaultMutableTreeNode
{
    static public final String METADATA_VALUE_TREE_NODE_HIERARCHY_TOKEN = "|";

    private String value = null;


    public MetadataValueTreeNode(Object object)
    {
	super(object);
    }


    public MetadataValueTreeNode(String value)
    {
	this.value = value;
    }


    public String getFullValue()
    {
	if (parent == null) {
	    return "";
	}

	if (((MetadataValueTreeNode) parent).isRoot()) {
	    return value;
	}

	return ((MetadataValueTreeNode) parent).getFullValue() + METADATA_VALUE_TREE_NODE_HIERARCHY_TOKEN + value;
    }


    public String getValue()
    {
	return value;
    }


    /** This is used to display the node in the value tree */
    public String toString()
    {
	return value;
    }
}
