/** This class is not currently used and therefore will not be compiled by makegli. */

package org.greenstone.gatherer.feedback;

import java.io.*;
import javax.imageio.*;
import java.awt.*;
import java.awt.image.*;
import com.sun.image.codec.jpeg.*;
import javax.swing.*;

/**
 * This class will separate a image file into 2 jpeg image files by taking
 * all the point in that image file that has the color red and save all that
 * points to another image file, while all the other point to another image
 * file.
 * @author Veronica Liesaputra
 */
public class SeparateGraphs
{
    /**
     * This is the BufferedImage that we want to separate.
     */
    private BufferedImage bi;

    /**
     * This constructor will save the image inside the file with the specified 
     * filename to the BufferedImage.
     */
    public SeparateGraphs(String filename)
    {
	try
	    {
		File f = new File(filename);
		bi = ImageIO.read(f);
	    }
	catch(IOException exp) {}
    }

    /**
     * This method will separate bi into 2 image and save it to
     * jpeg files with the specified filename.
     * The 2 image separated will be, 1 image is the image of all the points in bi that
     * have the color red and another image is the image of all other points in bi that
     * do not have the color red.
     * @param file1 this is the filename for the image of all other points that do not have color red.
     * @param file2 this is the filename for the image of all points that have the color red.
     */
    public void separate(String file1,String file2)
    {
	BufferedImage bi1,bi2;
	
	int width = bi.getWidth();
	int height = bi.getHeight();
	
	bi1 = new BufferedImage(width,height,BufferedImage.TYPE_INT_RGB);
	bi2 = new BufferedImage(width,height,BufferedImage.TYPE_INT_ARGB);

	for (int y = 0 ; y < height ; y++) 
	    {
		for (int x = 0 ; x < width ; x++)
		    {
			int rgb = bi.getRGB(x,y);
			Color c = new Color(rgb,true);
			if (c != Color.RED)
			    {
				bi1.setRGB(x,y,rgb);
			    }
			else
			    {
				bi2.setRGB(x,y,rgb);
			    }
		    }
	    }

	save(bi1,file1);
	save(bi2,file2);
    }

    /**
     * This method will save the BufferedImage into a jpeg file with the specified filenames.
     * @param b is the BufferedImage to be saved.
     * @param filename is the name of the jpeg files.
     */
    public void save(BufferedImage b,String filename)
    {
	try 
	    {
		File file = new File(filename);
		FileOutputStream out = new FileOutputStream(file);
	    
		JPEGImageEncoder encoder = JPEGCodec.createJPEGEncoder(out);
		JPEGEncodeParam param = encoder.getDefaultJPEGEncodeParam(b);
		param.setQuality(1.0f, false);
		encoder.setJPEGEncodeParam(param);
		encoder.encode(b);
		
	    } catch (Exception ex) {}
    }
}





