/**********************************************************************
 *
 * gsdltools.h -- 
 * A component of the Greenstone digital library software
 * from the New Zealand Digital Library Project at the
 * University of Waikato, New Zealand.
 *
 * Copyright (C) 1999  The New Zealand Digital Library Project
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *********************************************************************/


#ifndef GSDLTOOLS_H
#define GSDLTOOLS_H

// don't actually use this but some windows
// versions of STL complain about use of 
// bool keyword without it
#include "text_t.h"

// returns true if machine is little endian
bool littleEndian();

// escapes '\' and '_' characters with '\'
// note that single '\' characters occurring 
// naturally within text (or filenames!!) will
// be removed by the dm macro language
text_t dm_safe (const text_t &instring);

// escapes "\", "'" and "_" characters with '\'
// note that single '\' characters occurring 
// naturally within text (or filenames!!) will
// be removed by the dm macro language
//WARNING: instring will be appended to outstring
// so is your responsability to clean the outstring
// before call this function;
void dm_js_safe(const text_t &instring, text_t &outstring);
inline text_t dm_js_safe (const text_t &instring) {text_t outstring; dm_js_safe(instring, outstring); return outstring;}

// Convert '&' to "&amp;", '<' to "&lt;", and '>' to "&gt;"
text_t xml_safe(const text_t &text_string);

// gsdl_system creates a new process for the cmd command (which
// may contain arguments).
// cmd should contain the full path of the program to run.
// The child process inherits the environment of the calling
// process.
// If sync is true a synchronous call will be made, otherwise
// an asyncronous call.
// If sync is true the return value will be the exit code of
// the child process or -1 if the child process wasn't started.
// If sync is false the return value will be 0 if the process
// was started ok or -1 if it failed.
int gsdl_system (const text_t &cmd, bool sync, ostream &logout);

bool set_gsdl_env_vars (const text_t& gsdlhome) ;

// attempts to work out if perl is functional
bool perl_ok (ostream &logout);

#if defined(_MSC_VER)
void check_system_heap(char* title);
#endif

#endif







