/**************************************************************************
 *
 * longlong.h -- Use of GCC's long long integer types
 * Copyright (C) 1999 Tim A.H. Bell
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 **************************************************************************/

#ifndef H_LONGLONG
#define H_LONGLONG

#ifdef HAVE_CONFIG_H
# ifdef __WIN32__
#  include <win32cfg.h>
# else
#  include <config.h>
# endif
#endif

/*
  Use GCC's "long long" integer types for certain variables, to avoid
  overflowing 32 bit integers.

  Other files affected:
  
    lib:
        bitio_random.c
        bitio_random.h
	
    src/text:
        ivf.pass1.c
        ivf.pass2.c
        build.h
        mg_passes.c
        text.h
    
*/

/*#define TESTING_OVERFLOW*/

#ifdef TESTING_OVERFLOW

/* Test the overflow detection by using tiny (16-bit) types */
typedef unsigned short int mg_ullong;
typedef short int mg_llong;

#define ULL_FS "u"
#define LL_FS "d"

#elif defined __GNUC__ && ! defined DISABLE_LONG_LONG

/* We're using GCC, so it's okay to use "long long" (64-bit) types */
#define USE_LONG_LONG

typedef unsigned long long int mg_ullong;
typedef long long int mg_llong;

#define ULL_FS "llu"
#define LL_FS "lld"

#else

#if defined __unix__ || defined __APPLE__ || defined __MINGW32__ || (_MSC_VER >= 1800)
#include <stdint.h>
#else
typedef __int8            int8_t;
typedef __int16           int16_t; 
typedef __int32           int32_t;
typedef __int64           int64_t;
typedef unsigned __int8   uint8_t;
typedef unsigned __int16  uint16_t;
typedef unsigned __int32  uint32_t;
typedef unsigned __int64  uint64_t;
#endif
/* Not using GCC, so fall back on plain "long" (32-bit) types */
typedef uint32_t mg_ullong;
typedef int32_t mg_llong;

#define ULL_FS "lu"
#define LL_FS "ld"

#endif /* __GNUC__ */

#endif
