package org.greenstone.LuceneWrapper4;

import java.io.File;
import java.io.IOException;

import org.apache.lucene.analysis.Analyzer;
//import org.apache.lucene.analysis.LimitTokenCountAnalyzer;
import org.apache.lucene.analysis.miscellaneous.LimitTokenCountAnalyzer;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.store.FSDirectory; //import org.apache.lucene.store.SimpleFSDirectory;
import org.apache.lucene.util.Version;
//import org.apache.lucene.index.IndexWriter.MaxFieldLength;


/**
 *  Commonly used static functions, saves some repetition.
 *  The OpenMode flags CREATE, APPEND, or CREATE_OR_APPEND passed around in each case are to keep 
 *  the behaviour in the Lucene 4.7.2. upgrade similar to the default behaviour in Lucene 3.3.
 */
public final class GSLuceneUtil {

     /** 
      * Having a private constructor prevents instantiation and this being a final class prevents subclassing,
      * indicating that this is a class with purely static constants (and/or methods). 
      * See http://stackoverflow.com/questions/320588/interfaces-with-static-fields-in-java-for-sharing-constants
     */
    private GSLuceneUtil() {}

    public static IndexWriter getIndexWriter(String index_path) 
	throws IOException
    {
	return GSLuceneUtil.getIndexWriter(index_path, new GS2Analyzer(), IndexWriterConfig.OpenMode.CREATE_OR_APPEND);
    }

    public static IndexWriter getIndexWriter(String index_path, boolean create) 
	throws IOException
    {
	if(create) {
	    return GSLuceneUtil.getIndexWriter(index_path, new GS2Analyzer(), IndexWriterConfig.OpenMode.CREATE);
	} else {
	    return GSLuceneUtil.getIndexWriter(index_path, new GS2Analyzer(), IndexWriterConfig.OpenMode.APPEND);
	}
    }

    public static IndexWriter getIndexWriter(String index_path, Analyzer analyzer, boolean create) 
	throws IOException
    {
	if(create) {
	    return GSLuceneUtil.getIndexWriter(index_path, analyzer, IndexWriterConfig.OpenMode.CREATE);
	} else {
	    return GSLuceneUtil.getIndexWriter(index_path, analyzer, IndexWriterConfig.OpenMode.APPEND);
	}
    }

    public static IndexWriter getIndexWriter(String index_path, Analyzer analyzer, 
					     IndexWriterConfig.OpenMode openMode) 
	throws IOException 
    {
	IndexWriter index_writer = null;

	//SimpleFSDirectory index_path_dir = new SimpleFSDirectory(new File(index_path));
	FSDirectory index_path_dir = FSDirectory.open(new File(index_path));


	//if(GSLuceneConstants.MATCH_VERSION.compareTo(Version.LUCENE_36) < 0) {
	//    index_writer = new IndexWriter(index_path_dir, new GS2Analyzer(), 
	//    			       org.apache.lucene.index.IndexWriter.MaxFieldLength.UNLIMITED);
	//} else { // lucene 3.6 or greater

	//index_writer = new IndexWriter(index_path_dir, new IndexWriterConfig(GS_LUCENE_VERSION, new GS2Analyzer()));
	
	// see p.10 and 11 of http://alias-i.com/lingpipe-book/lucene-3-tutorial-0.5.pdf
	// "In order to index all the text in a field, however long that field may be, 
	// we need to wrap the StandardAnalyzer (here GS2Analyzer) in a LimitTokenCountAnalyzer 
	// We set the maximum field length to Integer.MAX_VALUE, the largest possible value available."
	Analyzer ltcAn = new LimitTokenCountAnalyzer(analyzer,Integer.MAX_VALUE);
	IndexWriterConfig indexWriterConfig = new IndexWriterConfig(GSLuceneConstants.MATCH_VERSION, ltcAn);
	if(openMode == null) {
	    indexWriterConfig.setOpenMode(IndexWriterConfig.OpenMode.CREATE_OR_APPEND);
	} else {
	    indexWriterConfig.setOpenMode(openMode);
	}
	// setOpenMode() only takes effect when IndexWriter is first created.
	index_writer = new IndexWriter(index_path_dir, indexWriterConfig);

	//}
	
	return index_writer;
    }

}