/**********************************************************************
 *
 * Compat.h
 * Copyright (C) 2003  UNESCO
 *
 * A component of the Greenstone digital library software
 * from the New Zealand Digital Library Project at the
 * University of Waikato, New Zealand.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *********************************************************************/

#ifndef _MSC_VER

#include <string>
#include <algorithm>
#include <iostream>
#include <sstream>
#include <stdio.h>
#include <sys/stat.h>

#define TCHAR  char
#define BOOL   bool
#define WORD   unsigned short
#define DWORD  mg_u_long
#define INT32  int
#define UINT32 unsigned int
#define LONG   mg_s_long
#define TRUE   true
#define FALSE  false

#define _MAX_PATH 512
#define SHRT_MAX  32732

/* Formatted i/o */

#define _tprintf    printf
#define _ftprintf   fprintf
#define _stprintf   sprintf
#define _sntprintf  _snprintf
#define _vtprintf   vprintf
#define _vftprintf  vfprintf
#define _vstprintf  vsprintf
#define _vsntprintf _vsnprintf
#define _tscanf     scanf
#define _ftscanf    fscanf
#define _stscanf    sscanf
/* String conversion functions */

#define _tcstod     strtod
#define _tcstol     strtol
#define _tcstoul    strtoul

#define _itot       _itoa
#define _ltot       _ltoa
#define _ultot      _ultoa
#define _ttoi       atoi
#define _ttol       atol

#define _ttoi64     _atoi64
#define _i64tot     _i64toa
#define _ui64tot    _ui64toa
/* String functions */

/* Note that _mbscat, _mbscpy and _mbsdup are functionally equivalent to 
   strcat, strcpy and strdup, respectively. */

#define _tcscat     strcat
#define _tcscpy     strcpy
#define _tcsdup     _strdup

#define _tcslen     strlen
#define _tcsxfrm    strxfrm


// #define assert
#define ASSERT
#define AssertFailed

// #define _T(par) par
#define LPCTSTR const char *
#define LPTSTR char *
#define FAR
#define TRACE
#define PRECONDITION
#define SIZE_T size_t



#endif
#define MoveMemory memmove
#define ZeroMemory(p,size) memset(p,0,size)


inline void fix_endianness(short int& x)
{
#if !defined(LITTLE_ENDIAN)
  if (x < 0) {
    unsigned short int ux = (unsigned short int) x;
    x = (ux>>8) | 
        (ux<<8);
  }
  else {
    x = (x>>8) | 
        (x<<8);
  }
#endif
}

inline void fix_endianness(mg_s_long& x)
{
#if !defined(LITTLE_ENDIAN)
  if (x < 0) {
    mg_u_long ux = (mg_u_long) x;
    x = (ux>>24) | 
      ((ux<<8) & 0x00FF0000) |
      ((ux>>8) & 0x0000FF00) |
      (ux<<24);
  }
  else {
    x = (x>>24) | 
      ((x<<8) & 0x00FF0000) |
      ((x>>8) & 0x0000FF00) |
      (x<<24);
  }
#endif
}
