/**********************************************************************
 *
 * filter.h -- 
 * Copyright (C) 1999  The New Zealand Digital Library Project
 *
 * A component of the Greenstone digital library software
 * from the New Zealand Digital Library Project at the
 * University of Waikato, New Zealand.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *********************************************************************/


#ifndef FILTER_H
#define FILTER_H

#include "gsdlconf.h"
#include "text_t.h"
#include "comtypes.h"


class filterclass {
protected:
  text_t gsdlhome;
  text_t collecthome;
  text_t dbhome;
  text_t collection;
  text_t collectdir;

  FilterOption_tmap filterOptions;

public:
  filterclass ();
  virtual ~filterclass ();

  // configure should be called once for each configuration line
  // default configures the default filter options
  virtual void configure (const text_t &key, const text_tarray &cfgline);

  // init should be called after all the configuration is done but
  // before any other methods are called
  // default checks all the filter option defaults
  virtual bool init (ostream &logout);

  // returns the name of this filter
  virtual text_t get_filter_name ();

  // returns the current filter options
  virtual void get_filteroptions (InfoFilterOptionsResponse_t &response,
				  comerror_t &err, ostream &logout);

  virtual void filter (const FilterRequest_t &request,
		       FilterResponse_t &response,
		       comerror_t &err, ostream &logout);

};


// The filterptr class does not 'own' the filter. The 
// filter should be deleted by the code which created it.
class filterptr {
public:
  filterclass *f;

  filterptr () {f=NULL;}
  ~filterptr () {}
};

bool operator==(const filterptr &x, const filterptr &y);
bool operator<(const filterptr &x, const filterptr &y);


typedef map<text_t, filterptr, lttext_t> filterptrmap;

// contains a list of filters indexed by their name
class filtermapclass {
protected:
  filterptrmap filterptrs;

public:
  // type support for filterptrmap
  typedef filterptrmap::iterator iterator;
  typedef filterptrmap::const_iterator const_iterator;
  typedef filterptrmap::reference reference;
  typedef filterptrmap::const_reference const_reference;
  typedef filterptrmap::size_type size_type;

  typedef filterptrmap::difference_type difference_type;
  typedef filterptrmap::const_reverse_iterator const_reverse_iterator;
  typedef filterptrmap::reverse_iterator reverse_iterator;
  
  // basic container support
  iterator begin () {return filterptrs.begin();}
  const_iterator begin () const {return filterptrs.begin();}
  iterator end () {return filterptrs.end();}
  const_iterator end () const {return filterptrs.end();}

  void erase(iterator pos) {filterptrs.erase(pos);}
  void erase(iterator first, iterator last) {filterptrs.erase(first, last);}
  filtermapclass &operator=(const filtermapclass &x) {filterptrs=x.filterptrs;return *this;}

  bool empty () const {return filterptrs.empty();}
  size_type size() const {return filterptrs.size();}


  // added functionality
  void clear () {filterptrs.erase(filterptrs.begin(),filterptrs.end());}

  // thefilter remains the property of the calling code but
  // should not be deleted until it is removed from this list.
  void addfilter (filterclass *thefilter);

  // getfilter will return NULL if the filter could not be found
  filterclass *getfilter (const text_t &key);
};



// some useful functions for dealing with document sets

// intersect places the result in set1
void intersect (text_tset &set1, const text_tset &set2);
void intersect (text_tarray &set1, const text_tset &set2);
void intersect (text_tarray &set1, const text_tarray &set2);

// tests to see if el is in set
bool in_set (const text_tset &set1, const text_t &el);
bool in_set (const text_tarray &set1, const text_t &el);

#endif
