/**********************************************************************
 *
 * settings.h
 * Copyright (C) 1996
 * 
 * A component of the fnord webserver written by bmorin@wpi.edu.
 *
 * Altered for use with the Greenstone digital library software by the
 * New Zealand Digital Library Project at the University of Waikato,
 * New Zealand.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *********************************************************************/

#ifndef SETTINGS_H
#define SETTINGS_H

#define GS_NETSCAPE 0
#define GS_IEXPLORE 1
#define GS_OTHER    2
#define GS_DEFAULT  3

// address resolution methods
#define ARM_NAME 0
#define ARM_IP 1
#define ARM_LOCALHOST 2
#define ARM_127_0_0_1 3

#include "text_t.h"
#include "cfgread.h"
#include "receptionist.h"
#include "locate.h"

// library settings
extern text_t gsdl_enterlib;
extern text_t gsdl_gsdlhome;
extern text_t gsdl_collecthome;
extern text_t gsdl_dbhome;
extern text_t gsdl_collections;
extern colinfo_tmap gsdl_collectinfo;

extern char gsdl_staticpages[MAX_FILENAME_SIZE];

// debug settings
extern char gsdl_log_name[MAX_FILENAME_SIZE];
extern int gsdl_keep_log;
extern int gsdl_show_console;

// general settings
extern int gsdl_port_num;
extern int gsdl_external_access;
extern int gsdl_auto_enter;
extern int gsdl_browser;
extern char gsdl_browser_exe[MAX_FILENAME_SIZE];
extern text_t gsdl_url;
extern text_t gsdl_host_IP;
extern text_t gsdl_conffile;
extern int gsdl_start_browser;
extern int gsdl_address_resolution_method;
extern text_t gsdl_mode_property_prefix;

void Settings_Dialog(HWND window, int netscapeneeded);

void read_settings (int netscapeneeded);
void write_settings (const text_t url);

void gsdl_check_browser_settings (int netscapeneeded);

#endif
