/**********************************************************************
 *
 * browseactiontools.cpp -- 
 * Copyright (C) 1999  The New Zealand Digital Library Project
 *
 * A component of the Greenstone digital library software
 * from the New Zealand Digital Library Project at the
 * University of Waikato, New Zealand.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *********************************************************************/


#include "browseactiontools.h"
#include <ctype.h>

void format_browsestring(const text_t& orig, text_t& formatted, int and_or)
{
  
 
  text_t conj = g_EmptyText;
  
  if(and_or == 0){ conj = " | "; }
  else { conj = " & "; }
  text_t::const_iterator here = orig.begin();
  text_t::const_iterator end = orig.end();
  
  //while not at the end of the filter string
  while(here!=end){
    //if seeing text, add it to the formatted string
    if(!isspace(*here)){
      formatted.push_back(*here);
      ++here;
    }
    //else, if seeing spaces, check that there is following text and add
    //the ncessary conjugation if there is.
    else if(isspace(*here)){
      while(isspace(*here) && here!=end) ++here;
      if(here!=end) formatted += conj;
    }
  }

}

// this stuff is all copied from the queryoptions code - don't ask how it all
// hangs in with the filters - those things are a mystery 
void set_browsefilter_options(FilterRequest_t &request, const text_t &browsestring,
			      cgiargsclass &args)
{
  request.filterName = "QueryFilter";

   OptionValue_t option;

   option.name = "Term";
   option.value = browsestring;
   request.filterOptions.push_back (option);
   
   option.name = "QueryType";
   option.value = "boolean";
   request.filterOptions.push_back (option);
  
   option.name = "MatchMode";
   option.value = (args.getintarg("bt")) ? "some" : "all";
   request.filterOptions.push_back (option);
   
   option.name = "Casefold";
   option.value = (args.getintarg("k")) ? "true" : "false";
   request.filterOptions.push_back (option);
   
   option.name = "Stem";
   option.value = (args.getintarg("s")) ? "true" : "false";
   request.filterOptions.push_back (option);

   option.name = "Maxdocs";
   option.value = -1;
   request.filterOptions.push_back (option);
   
   option.name = "Index";
   option.value = "dtx";
   request.filterOptions.push_back (option);
     
   
}

bool remove_no_meta_results(const text_t& metaname, FilterResponse_t &response, 
			    outconvertclass &outconvert)
{
  
  ResultDocInfo_tarray::iterator check = response.docInfo.begin();
  ResultDocInfo_tarray::iterator done = response.docInfo.end();
  // look through all the returned documents
  while(check != response.docInfo.end()){
   
    //if the document doesn't have the metadata item classified on 
    //remove it.
    text_t title = *((*check).metadata.find(metaname)->second).values.begin();
    if(title == g_EmptyText)
      {
	
	response.docInfo.erase(check);
	
      }
    else {
     
      ++check;
     
    }
 
  }
  return true;
}





