/*
 * Decompiled with CFR 0.152.
 */
package org.greenstone.server;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import org.greenstone.server.BaseServer;
import org.greenstone.server.BaseServerSettings;
import org.greenstone.util.ScriptReadWrite;

public class Server2Settings
extends BaseServerSettings {
    protected JComboBox prefix_combobox;
    protected JRadioButton[] hostRadioButtons = new JRadioButton[4];
    protected int address_resolution_method = 2;

    public Server2Settings(BaseServer server) {
        super(server);
    }

    @Override
    protected JPanel createServletPanel() {
        JPanel server2panel = new JPanel();
        server2panel.setLayout(new BorderLayout());
        JPanel connect_panel = new JPanel(new GridLayout(4, 1));
        connect_panel.setBackground(bg_color);
        connect_panel.setBorder(BorderFactory.createTitledBorder(BaseServer.dictionary.get(BaseServer.Property.SERVER_SETTINGS + ".AddressResolutionMethod")));
        this.hostRadioButtons = new JRadioButton[4];
        this.hostRadioButtons[0] = new JRadioButton(BaseServer.dictionary.get(BaseServer.Property.SERVER_SETTINGS + ".ResolveIP"));
        this.hostRadioButtons[1] = new JRadioButton(BaseServer.dictionary.get(BaseServer.Property.SERVER_SETTINGS + ".LocalIP"));
        this.hostRadioButtons[2] = new JRadioButton(BaseServer.dictionary.get(BaseServer.Property.SERVER_SETTINGS + ".AlwaysUse") + " localhost");
        this.hostRadioButtons[3] = new JRadioButton(BaseServer.dictionary.get(BaseServer.Property.SERVER_SETTINGS + ".AlwaysUse") + " 127.0.0.1");
        ButtonGroup hostGroup = new ButtonGroup();
        for (int i = 0; i < this.hostRadioButtons.length; ++i) {
            connect_panel.add(this.hostRadioButtons[i]);
            hostGroup.add(this.hostRadioButtons[i]);
            this.hostRadioButtons[i].setBackground(bg_color);
        }
        String addressResolutionMethod = BaseServer.config_properties.getProperty("address_resolution_method", "").trim();
        if (!addressResolutionMethod.equals("")) {
            this.address_resolution_method = Integer.parseInt(addressResolutionMethod);
        }
        this.hostRadioButtons[this.address_resolution_method].setSelected(true);
        JPanel comb_panel = new JPanel(new BorderLayout());
        comb_panel.add((Component)connect_panel, "Center");
        return comb_panel;
    }

    @Override
    public boolean[] onSave() {
        boolean hasChanged = false;
        boolean requireRestart = false;
        for (int i = 0; i < this.hostRadioButtons.length; ++i) {
            if (!this.hostRadioButtons[i].isSelected() || this.address_resolution_method == i) continue;
            this.address_resolution_method = i;
            hasChanged = true;
            requireRestart = true;
            this.server.reconfigRequired();
        }
        boolean[] returnValues = new boolean[]{hasChanged, requireRestart};
        return returnValues;
    }

    @Override
    public void save(ScriptReadWrite scriptReadWrite, ArrayList<String> newFileLines) {
        boolean keep_port;
        boolean auto_enter = this.autoEnter.isSelected();
        if (this.autoStart != auto_enter) {
            String newAutoEnter = auto_enter ? "1" : "0";
            newFileLines = scriptReadWrite.queryReplace(newFileLines, BaseServer.Property.AUTOSTART, newAutoEnter);
        }
        if (this.keepPort != (keep_port = this.keepPortToggle.isSelected())) {
            String newKeepPort = keep_port ? "1" : "0";
            newFileLines = scriptReadWrite.queryReplace(newFileLines, BaseServer.Property.KEEPPORT, newKeepPort);
        }
        newFileLines = scriptReadWrite.queryReplace(newFileLines, BaseServer.Property.ALLOW_EXTERNAL_ACCESS, this.externalaccess ? "1" : "0");
        String hostIP = "127.0.0.1";
        String hosts = "";
        InetAddress inetAddress = null;
        try {
            inetAddress = InetAddress.getLocalHost();
            hosts = inetAddress.getHostName();
            hostIP = inetAddress.getHostAddress();
        }
        catch (UnknownHostException e) {
            logger.error((Object)e);
            logger.info((Object)"Server2.java reload(): Defaulting host URL to localhost");
            hostIP = "127.0.0.1";
            hosts = "";
            this.address_resolution_method = 2;
        }
        newFileLines = scriptReadWrite.replaceOrAddLine(newFileLines, "hostIP", hostIP, true);
        newFileLines = scriptReadWrite.replaceOrAddLine(newFileLines, "hosts", hosts, true);
        newFileLines = scriptReadWrite.queryReplace(newFileLines, "address_resolution_method", Integer.toString(this.address_resolution_method));
    }
}

