/**********************************************************************
 *
 * gdbmset -- add or replace a single value from the GDBM database
 * Copyright (C) 1999  The New Zealand Digital Library Project
 *
 * A component of the Greenstone digital library software
 * from the New Zealand Digital Library Project at the
 * University of Waikato, New Zealand.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *********************************************************************/

#ifdef _MSC_VER
#include "autoconf.h"
#include "systems.h"
#include "gdbmconst.h"
#include "gdbm.h"

#else
#include <gdbm.h>
#endif

#include "gsdlconf.h"
#include <stdlib.h>
#include <cstring>

#if defined(GSDL_USE_OBJECTSPACE)
#include <ospace\std\iostream>
#elif defined(GSDL_USE_IOS_H)
#include <iostream.h>
#else
#include <iostream>
#endif

// use the standard namespace
#if !defined (GSDL_NAMESPACE_BROKEN)
#if defined(GSDL_USE_OBJECTSPACE)
using namespace ospace::std;
#else
using namespace std;
#endif
#endif

void 
print_usage (char *program_name) 
{
  cerr << "usage: " << program_name << " <database_path> <key> [<value>] [append]" << endl;
  cerr << "\t- if no value is given then the lexicon indicated by the key is removed" << endl;
  cerr << "\t- if a value is given followed by 'append' then the value is " << endl;
  cerr << "\t  added to the existing entry rather than overwriting it" << endl;
  cerr << endl;
}


int main (int argc, char *argv[]) 
{
  // The block_size parameter  is  ignored unless the file is a new file.
  // If it is less than 512, dbm will use the  stat  block size for the file system.
  int block_size = 0;
  GDBM_FILE dbf;
  datum key;
  
  // sanity check
  if ((argc < 3) || (argc>5)) {
      print_usage (argv[0]);
      exit (-1);
  }
  
  // open the database
#ifdef _MSC_VER
  // On Windows need to make sure the database is generated if it does not already exist
  // GDBM_WRCREAT flag means: open database for read/write, create if necessary
  // http://www.rt.com/man/gdbm.3.html is the Unix man page on gdbm_open 
  // http://trac.greenstone.org/changeset/928 - the 6th param of gdbm_open (only in the
  // Windows version of the function) was set to 1 when using WRCREAT
  // http://www.sfr-fresh.com/unix/misc/q-7.11.tar.gz:a/q-7.11/modules/gdbm/README-Gdbm
  dbf = gdbm_open (argv[1], block_size, GDBM_WRCREAT, 00664, NULL, 1);
#else
  dbf = gdbm_open  (argv[1], block_size, GDBM_WRCREAT, 00664, NULL);
  // dbf = gdbm_open  (argv[1], block_size, GDBM_WRITER, 00664, NULL);
#endif
  if (dbf == NULL) 
    {
      cerr << argv[0] << ": couldn't open database connection to " << argv[1] << endl;
      exit (-1);
    }
  
  key.dsize = strlen(argv[2]);
  key.dptr = argv[2];

  if(argc == 5) {
    
    if (strcmp(argv[4],"append")==0) {
      datum orig_content,concat_content;

      //cerr << "Appending [" << argv[2] << "] to '" << argv[3] << "' (length " << strlen(argv[3]) << ")" << endl;
      // get old value, then top up

      orig_content = gdbm_fetch (dbf, key);

      // append orig_content with argv[3]
      concat_content.dsize = orig_content.dsize + strlen(argv[3]);
      char* concat_data = new char[concat_content.dsize +1];//  make room for \0 at end
      if (orig_content.dsize>0) {
	strncpy(concat_data,orig_content.dptr,orig_content.dsize);
	strcpy(&concat_data[orig_content.dsize],argv[3]); // ensures \0 at end
      }
      else {
	// first time key has been used
	strcpy(concat_data,argv[3]); // ensures \0 at end
      }

      concat_content.dptr = concat_data;
      if(gdbm_store(dbf, key, concat_content, GDBM_REPLACE) != 0)
        {
          cerr << "failed to set [" << argv[2] << "] to '" << concat_data << "'" << endl;
        }
      delete [] concat_data;
    }
    else {
      print_usage (argv[0]);
      gdbm_close (dbf);
      exit(-1);
    }
  }
  else if (argc == 4) {
      datum content;

      //cerr << "Setting [" << argv[2] << "] to '" << argv[3] << "' (length " << strlen(argv[3]) << ")" << endl;
      content.dsize = strlen(argv[3]);
      content.dptr = argv[3];
      if(gdbm_store(dbf, key, content, GDBM_REPLACE) != 0)
        {
          cerr << "failed to set [" << argv[2] << "] to '" << argv[3] << "'" << endl;
        }
    }
  else
    {
      if(gdbm_delete(dbf, key) != 0)
        {
          cerr << "failed to remove [" << argv[2] << "]" << endl;
        }
    }
  gdbm_close (dbf);

  return 0;
}
