/**
 *#########################################################################
 *
 * A component of the Gatherer application, part of the Greenstone digital
 * library suite from the New Zealand Digital Library Project at the
 * University of Waikato, New Zealand.
 *
 * Copyright (C) 2022 New Zealand Digital Library Project
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *########################################################################
 */
package org.greenstone.gatherer.cdm;

import java.util.ArrayList;
import org.greenstone.gatherer.util.StaticStrings;
import org.w3c.dom.Element;

/** This class encapsulates a facet field - used by  SOLR
    It basically is an index, with a different field name */

public class Facet extends Index {

    static final String facet_element = StaticStrings.FACET_ELEMENT;
    //protected String default_element_name = null; // don't have default at this stage

    public Facet() {
    }

    public Facet(Element element) {
	super(element);
    }

    public Facet(ArrayList sources) {
	super(sources);
    }

    protected String getElementName() {
	return facet_element;
    }

    protected String getDefaultElementName() {
	return null; //StaticSTrings.FACET_DEFAULT_ELEMENT;
    }

    public String getType() {
	return SearchMeta.TYPE_FACET;
    }
    public DOMProxyListEntry create(Element element) {
	return new Facet(element);
    }

    public DOMProxyListEntry create(ArrayList sources) {
	return new Facet(sources);
    }

    
}