###########################################################################
#
# win32 makefile -- common code between gsdl runtime and buildtime
# A component of the Greenstone digital library software
# from the New Zealand Digital Library Project at the
# University of Waikato, New Zealand.
#
# Copyright (C) 1999  The New Zealand Digital Library Project
#
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#
###########################################################################

!IF "$(GSDLHOME)"==""
GSDLHOME = $(MAKEDIR)
!ELSE
GSDLHOME = $(GSDLHOME)
!ENDIF
COMMONHOME = $(MAKEDIR)
GSDL_VC4 = 0
DEBUG = 0
DLL = 0
DLLDEBUG = 0
USE_GDBM = 1
USE_JDBM = 1
USE_SQLITE = 1
USE_MSSQL = 0
# by default, all indexers are enabled
ENABLE_MG = 1
ENABLE_MGPP = 1
ENABLE_LUCENE = 1
# jni is disabled by default as this is the default for GS2. GS3 will set this explicitly
ENABLE_JNI = 0

MDEFINES = /f win32.mak

INDEXERSDIR = indexers

COMPILEDIRS = cgi-bin packages\windows\crypt\crypt \
	      packages\search4j src\lib 

INSTALLDIRS = cgi-bin packages\expat

#    src\getpw

PACKAGEDIRS = 

EXPAT_DIR = packages\expat\expat-1.95.8
SQLITE_DIR = packages\sqlite\sqlite-autoconf-3070602
JDBM_DIR = packages\jdbm
JDBMEDIT_DIR = src\jdbmedit

MAKECMD = $(MAKE) $(MDEFINES) GSDLHOME="$(GSDLHOME)" VISUAL_STUDIO_MAJORVERSION="$(VISUAL_STUDIO_MAJORVERSION)" BINDIR="$(GSDLHOME)\bin\windows" LIBDIR="$(GSDLHOME)\lib\windows"

!IF $(GSDL_VC4)
MAKECMD = $(MAKECMD) GSDL_VC4=1
!ENDIF
!IF $(DEBUG)
MAKECMD = $(MAKECMD) DEBUG=1
!ENDIF
!IF $(DLL)
MAKECMD = $(MAKECMD) DLL=1
!ENDIF
!IF $(DLLDEBUG)
MAKECMD = $(MAKECMD) DLLDEBUG=1
!ENDIF
!IF $(ENABLE_JNI)
MAKECMD = $(MAKECMD) ENABLE_JNI=1
!ENDIF
!IF !$(ENABLE_MG)
MAKECMD = $(MAKECMD) ENABLE_MG=0
!ENDIF
!IF !$(ENABLE_MGPP)
MAKECMD = $(MAKECMD) ENABLE_MGPP=0
!ENDIF
!IF !$(ENABLE_LUCENE)
MAKECMD = $(MAKECMD) ENABLE_LUCENE=0
!ENDIF

!IF $(USE_GDBM)
GDBM_DEFINES = -DUSE_GDBM
COMPILEDIRS = $(COMPILEDIRS) \
	packages\gdbm\gdbm-1.8.3
INSTALLDIRS = $(INSTALLDIRS) src\gdbmedit\db2txt src\gdbmedit\txt2db \
    src\gdbmedit\gdbmset src\gdbmedit\gdbmget \
    src\gdbmedit\gdbmkeys src\gdbmedit\gdbmdel 
!ELSE
GDBM_DEFINES =
MAKECMD = $(MAKECMD) USE_GDBM=0
!ENDIF

!IF $(USE_JDBM)
JDBM_DEFINES = -DUSE_JDBM
PACKAGEDIRS = $(PACKAGEDIRS) $(JDBM_DIR)
!ELSE
JDBM_DEFINES =
MAKECMD = $(MAKECMD) USE_JDBM=0
!ENDIF

!IF $(USE_SQLITE)
SQLITE_DEFINES = -DUSE_SQLITE
PACKAGEDIRS = $(PACKAGEDIRS) $(SQLITE_DIR)
!ELSE
SQLITE_DEFINES =
MAKECMD = $(MAKECMD) USE_SQLITE=0
!ENDIF

!IF $(USE_MSSQL)
MSSQL_DEFINES = -DUSE_MSSQL
MAKECMD = $(MAKECMD) USE_MSSQL=1
!ELSE
MSSQL_DEFINES =
!ENDIF

MAKECLEANCMD = $(MAKE) $(MDEFINES) GSDLHOME="$(GSDLHOME)" clean

all: win32.mak unzip $(INDEXERSDIR) $(PACKAGEDIRS) $(COMPILEDIRS) $(INSTALLDIRS) $(JDBMEDIT_DIR)

install: win32.mak $(INDEXERSDIR) $(INSTALLDIRS)

unzip:
	cd "$(COMMONHOME)"
	cd packages\windows\crypt
	if NOT EXIST "crypt" unzip crypt.zip
	cd "$(COMMONHOME)"
	IF NOT EXIST $(EXPAT_DIR) IF EXIST "$(GSDLHOME)\bin\windows\gunzip.exe" IF EXIST "$(GSDLHOME)\bin\windows\tar.exe" "$(GSDLHOME)\bin\windows\gunzip.exe" -cd "$(EXPAT_DIR).tar.gz" | "$(GSDLHOME)\bin\windows\tar.exe" xv --directory=./packages/expat
	@IF NOT EXIST $(EXPAT_DIR) echo ****** Couldn't extract archive $(EXPAT_DIR).tar.gz. Extract it manually, or check that gunzip.exe and tar.exe exist in GSDLHOME\bin\windows. ******
	@IF NOT EXIST $(EXPAT_DIR) exit /b 1
	cd "$(COMMONHOME)"
	
!IF "$(USE_SQLITE)" == "1"
	IF NOT EXIST $(SQLITE_DIR) IF EXIST "$(GSDLHOME)\bin\windows\gunzip.exe" IF EXIST "$(GSDLHOME)\bin\windows\tar.exe" "$(GSDLHOME)\bin\windows\gunzip.exe" -cd "$(SQLITE_DIR).tar.gz" | "$(GSDLHOME)\bin\windows\tar.exe" xv --directory=./packages/sqlite
	@IF NOT EXIST $(SQLITE_DIR) echo ****** Couldn't extract archive $(SQLITE_DIR).tar.gz. Extract it manually, or check that gunzip.exe and tar.exe exist in GSDLHOME\bin\windows. ******
	@IF NOT EXIST $(SQLITE_DIR) exit /b 1
	cd "$(COMMONHOME)"
!ENDIF

!IF "$(USE_JDBM)" == "1"
	IF NOT EXIST $(JDBM_DIR)\jdbm-1.0 IF EXIST "$(GSDLHOME)\bin\windows\gunzip.exe" IF EXIST "$(GSDLHOME)\bin\windows\tar.exe" "$(GSDLHOME)\bin\windows\gunzip.exe" -cd "$(JDBM_DIR)\gs-jdbm-1.0.tar.gz" | "$(GSDLHOME)\bin\windows\tar.exe" xv --directory=./packages/jdbm
	@IF NOT EXIST $(JDBM_DIR)\jdbm-1.0 echo ****** Couldn't extract archive $(JDBM_DIR)\gs-jdbm-1.0.tar.gz. Extract it manually, or check that gunzip.exe and tar.exe exist in GSDLHOME\bin\windows. ******
	@IF NOT EXIST $(JDBM_DIR)\jdbm-1.0 exit /b 1
!ENDIF

clean:
	cd "$(COMMONHOME)"
	cd cgi-bin
	$(MAKECLEANCMD)
	cd "$(COMMONHOME)"
!IF EXIST ("packages\windows\crypt\crypt")
	cd packages\windows\crypt\crypt
	$(MAKECLEANCMD)
!ENDIF
!IF EXIST ("packages\gdbm\gdbm-1.8.3")
	cd "$(COMMONHOME)"
	cd packages\gdbm\gdbm-1.8.3
	$(MAKECLEANCMD)
!ENDIF
	cd "$(COMMONHOME)"
!IF EXIST (packages\expat)
	cd packages\expat
	$(MAKECLEANCMD)
	cd "$(COMMONHOME)"
!ENDIF	
	cd src\lib
	$(MAKECLEANCMD)
!IF EXIST ("src\gdbmedit")
	cd "$(COMMONHOME)"
	cd src\gdbmedit\txt2db
	$(MAKECLEANCMD)
	cd "$(COMMONHOME)"
	cd src\gdbmedit\db2txt
	$(MAKECLEANCMD)
	cd "$(COMMONHOME)"
	cd src\gdbmedit\gdbmget
	$(MAKECLEANCMD)
	cd "$(COMMONHOME)"
	cd src\gdbmedit\gdbmset
	$(MAKECLEANCMD)
	cd "$(COMMONHOME)"
	cd src\gdbmedit\gdbmkeys
	$(MAKECLEANCMD)
	cd "$(COMMONHOME)"
	cd src\gdbmedit\gdbmdel
	$(MAKECLEANCMD)
!ENDIF
#	cd "$(COMMONHOME)"
#	cd src\getpw
#	$(MAKECLEANCMD)
	cd "$(COMMONHOME)"
	cd indexers
	set DEBUG=$(DEBUG)
	set VISUAL_STUDIO_MAJORVERSION=$(VISUAL_STUDIO_MAJORVERSION)
	set ENABLE_MG=$(ENABLE_MG)
	set ENABLE_MGPP=$(ENABLE_MGPP)
	set ENABLE_LUCENE=$(ENABLE_LUCENE)
	call winMake.bat clean
	set DEBUG=
	set VISUAL_STUDIO_MAJORVERSION=
	set ENABLE_MG=
	set ENABLE_MGPP=
	set ENABLE_LUCENE=
	cd "$(COMMONHOME)"
	cd packages\search4j
	$(MAKECLEANCMD)
!IF EXIST ("$(SQLITE_DIR)")
	cd "$(COMMONHOME)"
	cd "$(SQLITE_DIR)"
	$(MAKECLEANCMD)
	if exist "$(COMMONHOME)\packages\sqlite\lib\sqlite3.lib" del "$(COMMONHOME)\packages\sqlite\lib\sqlite3.lib"
!ENDIF
	cd "$(COMMONHOME)"	

$(COMPILEDIRS): FORCE
	cd "$(COMMONHOME)"
	cd "$@"
	$(MAKECMD)
	cd "$(GSDLHOME)"

!IF "$(INSTALLDIRS)" != ""
$(INSTALLDIRS): FORCE
	cd "$(COMMONHOME)"
	cd "$@"
	$(MAKECMD)
	$(MAKECMD) install
	cd "$(COMMONHOME)"
!ENDIF

$(SQLITE_DIR): FORCE
	cd "$(COMMONHOME)"
	cd "$@"
	$(MAKECMD)
	$(MAKECMD) install
	cd "$(COMMONHOME)"

$(JDBM_DIR): FORCE
	cd "$(COMMONHOME)\$(JDBM_DIR)\jdbm-1.0"
	set DEBUG=$(DEBUG)
	call winMake.bat all
	call winMake.bat install	
	set DEBUG=

$(JDBMEDIT_DIR): FORCE
!IF "$(USE_JDBM)" == "1"
	cd "$(COMMONHOME)"
	cd "$@"
	set DEBUG=$(DEBUG)
	call winMake.bat all
	call winMake.bat install	
	set DEBUG=
!ENDIF

$(INDEXERSDIR): FORCE
	cd "$(COMMONHOME)"
	cd "$@"
	set DEBUG=$(DEBUG)
	set VISUAL_STUDIO_MAJORVERSION=$(VISUAL_STUDIO_MAJORVERSION)
	set ENABLE_MG=$(ENABLE_MG)
	set ENABLE_MGPP=$(ENABLE_MGPP)
	set ENABLE_LUCENE=$(ENABLE_LUCENE)

!IF $(ENABLE_JNI)
	call winMake.bat all with-jni
	call winMake.bat install with-jni
!ELSE
	call winMake.bat all without-jni
	call winMake.bat install without-jni
!ENDIF

	set DEBUG=
	set VISUAL_STUDIO_MAJORVERSION=
	set ENABLE_MG=
	set ENABLE_MGPP=
	set ENABLE_LUCENE=
	if NOT EXIST "$(GSDLHOME)\bin\windows" mkdir "$(GSDLHOME)\bin\windows"
	if NOT EXIST "$(GSDLHOME)\bin\java" mkdir "$(GSDLHOME)\bin\java"
	for %%i in (bin\*.exe) do \
	  if exist %%i copy %%i "$(GSDLHOME)\bin\windows"
	if EXIST "lucene-gs\LuceneWrapper4.jar" copy "lucene-gs\LuceneWrapper4.jar" "$(GSDLHOME)\bin\java"
	@if NOT EXIST "lucene-gs\LuceneWrapper4.jar" echo Warning: Failed to find lucene-gs\LuceneWrapper4.jar. Greenstone will not be able to use Lucene for indexing
	cd "$(GSDLHOME)"

FORCE:

